/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.error.ErrorLog;
import sqlj.javac.ASTBlock;
import sqlj.javac.ExpressionNode;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.JavaParserImplTreeConstants;
import sqlj.javac.Node;
import sqlj.javac.SymTabEntry;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

public class SimpleNode
implements Node {
    private Node parent;
    private Node[] children;
    private int id;
    private static Node prunedNode = new SimpleNode(20);
    private String name = null;
    private int beginLine = -1;
    private int beginColumn = -1;
    protected Node enclosingClass = null;
    protected Node definingUnit = null;
    protected Hashtable symtab = null;
    private Node javaScope = null;
    private Parselet scope = null;
    protected TypeDescriptor desc = null;
    private Object info = null;
    static int totalCount = 0;
    int lastNodeCountTime = 0;

    SimpleNode() {
        this(-1);
    }

    public SimpleNode(int n2) {
        this.id = n2;
    }

    public SimpleNode(JavaParserImpl javaParserImpl, int n2) {
        this(n2);
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n2) {
        if (node instanceof ASTBlock && !node.hasSQL()) {
            node = prunedNode;
        }
        if (this.children == null) {
            this.children = new Node[n2 + 1];
        } else if (n2 >= this.children.length) {
            Node[] nodeArray = new Node[n2 + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n2] = node;
    }

    @Override
    public Node jjtGetChild(int n2) {
        return this.children[n2];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public String toString() {
        return this.id < 0 ? "<unknown>" : JavaParserImplTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    @Override
    public void dump(String string) {
        System.out.println(this.toString(string));
        for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(i2);
            if (simpleNode == null) continue;
            simpleNode.dump(string + " ");
        }
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int setName(String string, ErrorLog errorLog) {
        this.setName(string);
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setBeginLine(int n2) {
        this.beginLine = n2;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public void setBeginColumn(int n2) {
        this.beginColumn = n2;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    public Vector jjtGetChildren() {
        Vector<Node> vector = new Vector<Node>();
        for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
            vector.addElement(this.jjtGetChild(i2));
        }
        return vector;
    }

    public Node jjtGetLastChild() {
        if (this.jjtGetNumChildren() > 0) {
            return this.jjtGetChild(this.jjtGetNumChildren() - 1);
        }
        return null;
    }

    @Override
    public void addSymTab(Node node) {
        if (node == null || node.getSymTab() == null) {
            return;
        }
        Enumeration enumeration = node.getSymTab().elements();
        if (this.symtab == null) {
            this.symtab = new Hashtable();
        }
        while (enumeration.hasMoreElements()) {
            SymTabEntry symTabEntry = (SymTabEntry)enumeration.nextElement();
            if (symTabEntry.isType) {
                this.insertSymTab(symTabEntry.typ.getName(), symTabEntry);
                continue;
            }
            this.insertSymTab(symTabEntry.var.getName(), symTabEntry);
        }
    }

    @Override
    public Hashtable getSymTab() {
        return this.symtab;
    }

    public void insertSymTab(String string, SymTabEntry symTabEntry) {
        this.symtab.put(string, symTabEntry);
    }

    @Override
    public void insertSymTab(Node node, Node node2, int n2) {
        if (node2.getName() != null) {
            if (this.symtab == null) {
                this.symtab = new Hashtable();
            }
            this.insertSymTab(node.getName(), new SymTabEntry(node, node2, n2));
        }
    }

    public void insertSymTab(Node node, Node node2, int n2, ExpressionNode expressionNode) {
        if (node2.getName() != null) {
            if (this.symtab == null) {
                this.symtab = new Hashtable();
            }
            this.insertSymTab(node.getName(), new SymTabEntry(node, node2, n2, expressionNode));
        }
    }

    @Override
    public void insertSymTab(Node node, int n2) {
    }

    @Override
    public Node findName(String string, int n2, int n3) {
        SymTabEntry symTabEntry;
        if (this.symtab != null && (symTabEntry = (SymTabEntry)this.symtab.get(string)) != null && !symTabEntry.isType) {
            Node node = symTabEntry.var;
            Node node2 = symTabEntry.typ;
            int n4 = symTabEntry.mod;
            if (this instanceof ASTBlock) {
                if (n2 > node.getBeginLine() || n2 == node.getBeginLine() && n3 > node.getBeginColumn()) {
                    return node2;
                }
            } else {
                return node2;
            }
        }
        return null;
    }

    @Override
    public int getModifiers(String string, int n2, int n3) {
        Node node;
        SymTabEntry symTabEntry;
        if (this.symtab != null && (symTabEntry = (SymTabEntry)this.symtab.get(string)) != null && !symTabEntry.isType) {
            if (this instanceof ASTBlock) {
                if (n2 > symTabEntry.var.getBeginLine() || n2 == symTabEntry.var.getBeginLine() && n3 > symTabEntry.var.getBeginColumn()) {
                    return symTabEntry.mod;
                }
            } else {
                return symTabEntry.mod;
            }
        }
        return (node = (Node)this.getScope()) == null ? 0 : node.getModifiers(string, n2, n3);
    }

    @Override
    public JSClass lookupVarDecl(String string, int n2, int n3) throws ClassNotFoundException {
        Node node = this.findName(string, n2, n3);
        if (node != null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)node.getDescriptor();
            return classDescriptor == null ? null : classDescriptor.getReflection();
        }
        Node node2 = (Node)this.getScope();
        return node2 == null ? null : node2.lookupVarDecl(string, n2, n3);
    }

    public SymTabEntry getSymTabEntry(String string, int n2, int n3) {
        SimpleNode simpleNode;
        SymTabEntry symTabEntry;
        if (this.symtab != null && (symTabEntry = (SymTabEntry)this.symtab.get(string)) != null && !symTabEntry.isType) {
            if (this instanceof ASTBlock) {
                if (n2 > symTabEntry.var.getBeginLine() || n2 == symTabEntry.var.getBeginLine() && n3 > symTabEntry.var.getBeginColumn()) {
                    return symTabEntry;
                }
            } else {
                return symTabEntry;
            }
        }
        return (simpleNode = (SimpleNode)this.getScope()) == null ? null : simpleNode.getSymTabEntry(string, n2, n3);
    }

    @Override
    public void printSymTab() {
        Enumeration enumeration = this.symtab.elements();
        while (enumeration.hasMoreElements()) {
            SymTabEntry symTabEntry = (SymTabEntry)enumeration.nextElement();
            if (!symTabEntry.isType) {
                System.out.println("Var name is: " + symTabEntry.var.getName() + ".");
            }
            System.out.println("Type name is: " + symTabEntry.typ.getName() + ".");
        }
    }

    @Override
    public String getVarName() {
        return null;
    }

    @Override
    public void setScope(Parselet parselet) {
        if (this.scope != null) {
            throw new IllegalArgumentException("scope already set");
        }
        this.scope = parselet;
    }

    @Override
    public Parselet getScope() {
        return this.scope == null ? this.jjtGetParent() : this.scope;
    }

    @Override
    public Node getJavaScope() {
        if (this.javaScope != null) {
            return this.javaScope;
        }
        Parselet parselet = this;
        if (this.getScope() == null) {
            throw new NullPointerException("Internal error -- null scope for node " + this.toString());
        }
        while (!((parselet = parselet.getScope()) instanceof Node)) {
        }
        this.javaScope = parselet;
        return this.javaScope;
    }

    @Override
    public Parselet getEnclosingClass() {
        if (this.enclosingClass != null) {
            return this.enclosingClass;
        }
        this.enclosingClass = (Node)this.getJavaScope().getEnclosingClass();
        return this.enclosingClass;
    }

    @Override
    public Parselet getDefiningUnit() {
        if (this.definingUnit != null) {
            return this.definingUnit;
        }
        this.definingUnit = (Node)this.getJavaScope().getDefiningUnit();
        return this.definingUnit;
    }

    @Override
    public ClassNameResolver getClassResolver() {
        return this.getJavaScope().getClassResolver();
    }

    @Override
    public TypeDescriptor getDescriptor() {
        if (this.desc != null) {
            return this.desc;
        }
        this.desc = new TypeDescriptor();
        return this.desc;
    }

    @Override
    public void setInfo(Object object) {
        this.info = object;
    }

    @Override
    public Object getInfo() {
        return this.info;
    }

    @Override
    public boolean generate(OutputContext outputContext) throws IOException {
        return true;
    }

    protected void setDescriptor(TypeDescriptor typeDescriptor) {
        this.desc = typeDescriptor;
    }

    @Override
    public boolean hasSQL() {
        for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
            if (!this.jjtGetChild(i2).hasSQL()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numNodes() {
        return this.numNodes(++totalCount);
    }

    @Override
    public int numNodes(int n2) {
        int n3;
        if (this.lastNodeCountTime == n2) {
            n3 = 0;
        } else {
            this.lastNodeCountTime = n2;
            n3 = 1;
            for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
                n3 += this.jjtGetChild(i2).numNodes(n2);
            }
        }
        return n3;
    }
}

