/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.DynamicProfileWrapper;
import sqlj.runtime.profile.ref.LocalStatement;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTResultSetJDBC;
import sqlj.runtime.profile.ref.UntypedSelectProfile;

public class IterConvertProfile
extends DynamicProfileWrapper {
    public IterConvertProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    @Override
    public RTStatement getStatement(int n2) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n2);
        if (entryInfo.getRole() == 18) {
            if (entryInfo.getStatementType() != 4) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entryInfo.getSQLString());
            }
            if (entryInfo.getExecuteType() != 8) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
            }
            return new IterConvertStatement(this, entryInfo);
        }
        return super.getStatement(n2);
    }

    public static class IterConvertStatement
    extends LocalStatement
    implements RTCallableStatement {
        private static final Class[] ITER_CONSTRUCTOR_ARGS = new Class[]{RTResultSet.class};
        private ResultSet m_rs = null;
        private EntryInfo m_entry;
        private Profile m_profile;

        public IterConvertStatement(ConnectedProfile connectedProfile, EntryInfo entryInfo) throws SQLException {
            this.m_entry = entryInfo;
            this.m_profile = connectedProfile.getProfileData().getProfile();
        }

        @Override
        public void registerOutParameter(int n2, int n3) throws SQLException {
        }

        @Override
        public void setObject(int n2, Object object) throws SQLException {
            if (object instanceof ResultSet && n2 == 2) {
                this.m_rs = (ResultSet)object;
            } else {
                ProfileRefErrors.raise_UNEXPECTED_CALL("setObject");
            }
        }

        private ResultSet getResultSetParam() throws SQLException {
            if (this.m_rs == null) {
                ProfileRefErrors.raise_UNEXPECTED_CALL("getResultSetParam");
            }
            return this.m_rs;
        }

        @Override
        public int executeUpdate() {
            return 0;
        }

        @Override
        public Object getObject(int n2, Class clazz) throws SQLException {
            if (n2 == 1) {
                return IterConvertStatement.createIterator(this.m_profile, this.m_entry.getParamInfo(n2), this.toRTResultSet(this.getResultSetParam()));
            }
            ProfileRefErrors.raise_UNEXPECTED_CALL("getObject");
            return null;
        }

        public static Object createIterator(Profile profile, TypeInfo typeInfo, RTResultSet rTResultSet) throws SQLException {
            if (rTResultSet == null) {
                return null;
            }
            Class clazz = profile.getJavaType(typeInfo);
            if (ResultSetIterator.class.equals((Object)clazz)) {
                return UntypedSelectProfile.UntypedSelectStatement.newUntypedIterator(rTResultSet);
            }
            if (ResultSetIterator.class.isAssignableFrom(clazz)) {
                return IterConvertStatement.construct(clazz, ITER_CONSTRUCTOR_ARGS, new Object[]{rTResultSet});
            }
            ProfileRefErrors.raise_INVALID_ITERATOR(clazz);
            return null;
        }

        public static Object construct(Class clazz, Class[] classArray, Object[] objectArray) throws SQLException {
            Constructor constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(classArray);
                return constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new InstantiationError(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                ProfileRefErrors.raise_EXCEPTION_IN_CONSTRUCTOR(constructor.toString(), throwable);
                return null;
            }
        }

        protected RTResultSet toRTResultSet(ResultSet resultSet) throws SQLException {
            return new RTResultSetJDBC(resultSet);
        }
    }
}

