/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import java.util.concurrent.ConcurrentHashMap;

public class IfxTypes {
    public static final short IFX_TYPE_CHAR = 0;
    public static final short IFX_TYPE_SMALLINT = 1;
    public static final short IFX_TYPE_INT = 2;
    public static final short IFX_TYPE_FLOAT = 3;
    public static final short IFX_TYPE_SMFLOAT = 4;
    public static final short IFX_TYPE_DECIMAL = 5;
    public static final short IFX_TYPE_SERIAL = 6;
    public static final short IFX_TYPE_DATE = 7;
    public static final short IFX_TYPE_MONEY = 8;
    public static final short IFX_TYPE_NULL = 9;
    public static final short IFX_TYPE_DATETIME = 10;
    public static final short IFX_TYPE_BYTE = 11;
    public static final short IFX_TYPE_TEXT = 12;
    public static final short IFX_TYPE_VARCHAR = 13;
    public static final short IFX_TYPE_INTERVAL = 14;
    public static final short IFX_TYPE_NCHAR = 15;
    public static final short IFX_TYPE_NVCHAR = 16;
    public static final short IFX_TYPE_INT8 = 17;
    public static final short IFX_TYPE_VARCHAR2 = 63;
    public static final short IFX_TYPE_TIMESTAMP_TZ = 65;
    public static final short IFX_TYPE_NVCHAR2 = 64;
    public static final short IFX_TYPE_SERIAL8 = 18;
    public static final short IFX_TYPE_SET = 19;
    public static final short IFX_TYPE_MULTISET = 20;
    public static final short IFX_TYPE_LIST = 21;
    public static final short IFX_TYPE_ROW = 22;
    public static final short IFX_TYPE_COLLECTION = 23;
    public static final short IFX_TYPE_ROWREF = 24;
    public static final short IFX_TYPE_UDTVAR = 40;
    public static final short IFX_TYPE_UDTFIXED = 41;
    public static final short IFX_TYPE_REFSER8 = 42;
    public static final short IFX_TYPE_LVARCHAR = 43;
    public static final short IFX_TYPE_SENDRECV = 44;
    public static final short IFX_TYPE_BOOL = 45;
    public static final short IFX_TYPE_IMPEXP = 46;
    public static final short IFX_TYPE_IMPEXPBIN = 47;
    public static final short IFX_TYPE_SQLUDRDEFAULT = 48;
    public static final short IFX_TYPE_UNKNOWN = 49;
    public static final short IFX_TYPE_MAX = 54;
    public static final short IFX_TYPE_CLOB = 101;
    public static final short IFX_TYPE_BLOB = 102;
    public static final short IFX_TYPE_CURSOR = 2100;
    public static final short IFX_BIT_NOTNULLABLE = 256;
    public static final short IFX_BIT_DISTINCT = 2048;
    public static final short IFX_BIT_NAMEDROW = 4096;
    public static final short IFX_BIT_COLLCLIENT = Short.MIN_VALUE;
    public static final short IFX_BIT_DBOOLEAN = 16384;
    public static final short IFX_XID_LVARCHAR = 1;
    public static final short IFX_XID_SENDRECV = 2;
    public static final short IFX_XID_IMPEXP = 3;
    public static final short IFX_XID_IMPEXPBIN = 4;
    public static final short IFX_XID_BOOLEAN = 5;
    public static final short IFX_XID_POINTER = 6;
    public static final short IFX_XID_INDEXKEYARRAY = 7;
    public static final short IFX_XID_RTNPARAMTYPES = 8;
    public static final short IFX_XID_SELFUNCARGS = 9;
    public static final short IFX_XID_BLOB = 10;
    public static final short IFX_XID_CLOB = 11;
    public static final short IFX_XID_LOLIST = 12;
    public static final short IFX_XID_IFX_LO_SPEC = 13;
    public static final short IFX_XID_IFX_LO_STAT = 14;
    public static final short IFX_XID_STAT = 15;
    public static final short IFX_XID_CLIENTBINVAL = 16;
    public static final short IFX_XID_STREAM = 17;
    public static final short IFX_XID_IDSSECURITYLABEL = 18;
    public static final short IFX_XID_IDSELEMENTENC = 19;
    public static final short IFX_XID_IDSCOVERINGINFO = 20;
    public static final short IFX_XID_LLVC = 24;
    public static final short IFX_XID_JSON = 25;
    public static final short IFX_XID_BSON = 26;
    public static final short IFX_XID_CURSOR = 27;
    public static final short IFX_XID_RAW = 34;
    public static final short LAST_BUILTIN_XID_TYPE = 34;
    public static final short IFX_TYPE_BIGINT = 52;
    public static final short IFX_TYPE_BIGSERIAL = 53;
    public static final String IFX_XNAME_BLOB = "blob";
    public static final String IFX_XNAME_CLOB = "clob";
    public static final String IFX_XNAME_BOOL = "boolean";
    public static final String IFX_XNAME_LVARCHAR = "lvarchar";
    public static final String IFX_XNAME_BSON = "bson";
    public static final String IFX_XNAME_JSON = "json";
    public static final String IFX_XNAME_RAW = "raw";
    static ConcurrentHashMap<Integer, Integer> IfxToJDBCTypeTable;
    static ConcurrentHashMap<Integer, Integer> JDBCToIfxTypeTable;
    static ConcurrentHashMap<String, Integer> JavaToIfxTypeTable;
    static ConcurrentHashMap<Integer, String> IfxTypeToJavaTable;
    static ConcurrentHashMap<Integer, String> IfxTypeToNameTable;
    static ConcurrentHashMap<Integer, String> JDBCTypeToNameTable;
    static ConcurrentHashMap<String, Integer> IfxNameToIfxTypeTable;
    static ConcurrentHashMap<Integer, Integer> IfxToJDBC2TypeTable;
    static ConcurrentHashMap<Integer, Integer> IfxTypeToDecDigitsTable;
    static ConcurrentHashMap<Integer, Integer> IfxExTypeToDecDigitsTable;
    static ConcurrentHashMap<Integer, String> IfxExTypeToNameTable;

    private IfxTypes() {
    }

    public static int FromIfxToJDBC2Type(int n2) {
        Integer n3 = IfxToJDBC2TypeTable.get(n2);
        if (n3 == null) {
            n3 = 1111;
        }
        return n3;
    }

    public static int FromIfxToJDBCType(int n2) {
        Integer n3 = IfxToJDBCTypeTable.get(n2);
        if (n3 == null) {
            n3 = 1111;
        }
        return n3;
    }

    public static int FromJDBCToIfxType(int n2) {
        Integer n3 = JDBCToIfxTypeTable.get(n2);
        if (n3 == null) {
            n3 = 49;
        }
        return n3;
    }

    public static int FromJavaToIfxType(String string) {
        Integer n2 = JavaToIfxTypeTable.get(string);
        if (n2 == null) {
            n2 = 49;
        }
        return n2;
    }

    public static String FromIfxTypeToJava(int n2) {
        String string = IfxTypeToJavaTable.get(n2);
        if (string == null) {
            string = new String("unknown");
        }
        return string;
    }

    public static String IfxTypeToName(int n2) {
        String string = IfxTypeToNameTable.get(n2);
        if (string == null) {
            string = new String("unknown");
        }
        return string;
    }

    public static String IfxExTypeToName(int n2) {
        String string = IfxExTypeToNameTable.get(n2);
        if (string == null) {
            string = new String("unknown");
        }
        return string;
    }

    public static String JDBCTypeToName(int n2) {
        String string = JDBCTypeToNameTable.get(n2);
        if (string == null) {
            string = new String("unknown");
        }
        return string;
    }

    public static int FromIfxNameToIfxType(String string) {
        String string2 = new String(string);
        string2 = string2.trim();
        Integer n2 = IfxNameToIfxTypeTable.get(string2 = string2.toLowerCase());
        if (n2 == null) {
            n2 = 1111;
        }
        return n2;
    }

    public static int IfxTypeToDecDigits(int n2, int n3, int n4) {
        Integer n5;
        if (n2 == 40 || n2 == 41) {
            n5 = IfxExTypeToDecDigitsTable.get(n3);
        } else if (n2 == 5 || n2 == 8) {
            n5 = n4 >> 8 & 0xFF;
        } else if (n2 == 10 || n2 == 14) {
            int n6 = n4 >> 4 & 0xF;
            int n7 = n4 & 0xF;
            int n8 = n4 >> 8 & 0xFF;
            n5 = n8 + ((n7 > 10 ? 12 : n7) - n6) / 2;
        } else {
            n5 = IfxTypeToDecDigitsTable.get(n2);
        }
        if (n5 == null) {
            n5 = 0;
        }
        if (n5.equals(-1)) {
            n5 = n4;
        }
        return n5;
    }

    public static int IfxTypeToRightDecimal(int n2, int n3, int n4) {
        int n5;
        int n6 = n2 == 10 || n2 == 14 ? ((n5 = n4 & 0xF) > 10 ? n5 - 10 : 0) : (n2 == 5 || n2 == 8 ? n4 & 0xFF : 0);
        return n6;
    }

    public static boolean IsFloatTypes(int n2) {
        return (n2 &= 0xFF) == 3 || n2 == 4;
    }

    public static boolean isString(int n2) {
        return (n2 &= 0xFF) == 0 || n2 == 13 || n2 == 63 || n2 == 15 || n2 == 16 || n2 == 64 || n2 == 43;
    }

    public static boolean isUDT(int n2) {
        return (n2 &= 0xFF) == 40 || n2 == 41 || n2 == 45 || n2 == 43;
    }

    public static boolean isCollection(int n2) {
        return (n2 &= 0xFF) == 21 || n2 == 19 || n2 == 20;
    }

    public static boolean isComplexType(int n2) {
        if (IfxTypes.isCollection(n2)) {
            return true;
        }
        return (n2 &= 0xFF) == 22;
    }

    public static int getIfxTypeForExtendedTypes(int n2) {
        int n3 = 49;
        switch (n2) {
            case 5: {
                n3 = 45;
                break;
            }
            case 1: {
                n3 = 43;
                break;
            }
            case 10: 
            case 11: 
            case 25: 
            case 26: 
            case 34: 
            case 40: 
            case 41: {
                n3 = 44;
            }
        }
        return n3;
    }

    static {
        if (IfxToJDBCTypeTable == null) {
            IfxToJDBCTypeTable = new ConcurrentHashMap(54);
            IfxToJDBCTypeTable.putIfAbsent(0, 1);
            IfxToJDBCTypeTable.putIfAbsent(1, 5);
            IfxToJDBCTypeTable.putIfAbsent(2, 4);
            IfxToJDBCTypeTable.putIfAbsent(3, 8);
            IfxToJDBCTypeTable.putIfAbsent(4, 7);
            IfxToJDBCTypeTable.putIfAbsent(5, 3);
            IfxToJDBCTypeTable.putIfAbsent(6, 4);
            IfxToJDBCTypeTable.putIfAbsent(7, 91);
            IfxToJDBCTypeTable.putIfAbsent(8, 3);
            IfxToJDBCTypeTable.putIfAbsent(9, 0);
            IfxToJDBCTypeTable.putIfAbsent(10, 93);
            IfxToJDBCTypeTable.putIfAbsent(11, -4);
            IfxToJDBCTypeTable.putIfAbsent(12, -1);
            IfxToJDBCTypeTable.putIfAbsent(13, 12);
            IfxToJDBCTypeTable.putIfAbsent(63, 63);
            IfxToJDBCTypeTable.putIfAbsent(15, 1);
            IfxToJDBCTypeTable.putIfAbsent(16, 12);
            IfxToJDBCTypeTable.putIfAbsent(65, 2014);
            IfxToJDBCTypeTable.putIfAbsent(64, 64);
            IfxToJDBCTypeTable.putIfAbsent(14, 1);
            IfxToJDBCTypeTable.putIfAbsent(17, -5);
            IfxToJDBCTypeTable.putIfAbsent(18, -5);
            IfxToJDBCTypeTable.putIfAbsent(19, 1111);
            IfxToJDBCTypeTable.putIfAbsent(21, 1111);
            IfxToJDBCTypeTable.putIfAbsent(20, 1111);
            IfxToJDBCTypeTable.putIfAbsent(22, 2002);
            IfxToJDBCTypeTable.putIfAbsent(40, 2000);
            IfxToJDBCTypeTable.putIfAbsent(41, 2000);
            IfxToJDBCTypeTable.putIfAbsent(43, -1);
            IfxToJDBCTypeTable.putIfAbsent(44, 2000);
            IfxToJDBCTypeTable.putIfAbsent(45, 16);
            IfxToJDBCTypeTable.putIfAbsent(46, 2000);
            IfxToJDBCTypeTable.putIfAbsent(47, 2000);
            IfxToJDBCTypeTable.putIfAbsent(102, 2004);
            IfxToJDBCTypeTable.putIfAbsent(101, 2005);
            IfxToJDBCTypeTable.putIfAbsent(52, -5);
            IfxToJDBCTypeTable.putIfAbsent(53, -5);
        }
        if (JDBCToIfxTypeTable == null) {
            JDBCToIfxTypeTable = new ConcurrentHashMap(54);
            JDBCToIfxTypeTable.putIfAbsent(-5, 17);
            JDBCToIfxTypeTable.putIfAbsent(-2, 11);
            JDBCToIfxTypeTable.putIfAbsent(-7, 45);
            JDBCToIfxTypeTable.putIfAbsent(1, 0);
            JDBCToIfxTypeTable.putIfAbsent(91, 7);
            JDBCToIfxTypeTable.putIfAbsent(3, 5);
            JDBCToIfxTypeTable.putIfAbsent(8, 3);
            JDBCToIfxTypeTable.putIfAbsent(6, 3);
            JDBCToIfxTypeTable.putIfAbsent(4, 2);
            JDBCToIfxTypeTable.putIfAbsent(-4, 11);
            JDBCToIfxTypeTable.putIfAbsent(-1, 43);
            JDBCToIfxTypeTable.putIfAbsent(0, 9);
            JDBCToIfxTypeTable.putIfAbsent(2, 5);
            JDBCToIfxTypeTable.putIfAbsent(7, 4);
            JDBCToIfxTypeTable.putIfAbsent(5, 1);
            JDBCToIfxTypeTable.putIfAbsent(92, 10);
            JDBCToIfxTypeTable.putIfAbsent(93, 10);
            JDBCToIfxTypeTable.putIfAbsent(-6, 1);
            JDBCToIfxTypeTable.putIfAbsent(16, 45);
            JDBCToIfxTypeTable.putIfAbsent(-3, 11);
            JDBCToIfxTypeTable.putIfAbsent(12, 13);
            JDBCToIfxTypeTable.putIfAbsent(63, 63);
            JDBCToIfxTypeTable.putIfAbsent(2014, 65);
            JDBCToIfxTypeTable.putIfAbsent(64, 64);
            JDBCToIfxTypeTable.putIfAbsent(2000, 44);
            JDBCToIfxTypeTable.putIfAbsent(2002, 22);
            JDBCToIfxTypeTable.putIfAbsent(2003, 19);
            JDBCToIfxTypeTable.putIfAbsent(2004, 102);
            JDBCToIfxTypeTable.putIfAbsent(2005, 101);
            JDBCToIfxTypeTable.putIfAbsent(-5, 52);
            JDBCToIfxTypeTable.putIfAbsent(-5, 53);
            JDBCToIfxTypeTable.putIfAbsent(2100, 2100);
            JDBCToIfxTypeTable.putIfAbsent(2012, 2100);
        }
        if (JavaToIfxTypeTable == null) {
            JavaToIfxTypeTable = new ConcurrentHashMap(54);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.String"), 0);
            JavaToIfxTypeTable.putIfAbsent(new String("java.math.BigDecimal"), 5);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.Integer"), 2);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.Short"), 1);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.Long"), 17);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.Float"), 4);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.Double"), 3);
            JavaToIfxTypeTable.putIfAbsent(new String("[B"), 11);
            JavaToIfxTypeTable.putIfAbsent(new String("java.sql.Date"), 7);
            JavaToIfxTypeTable.putIfAbsent(new String("java.sql.Time"), 10);
            JavaToIfxTypeTable.putIfAbsent(new String("java.sql.Timestamp"), 10);
            JavaToIfxTypeTable.putIfAbsent(new String("com.gbasedbt.lang.IntervalYM"), 14);
            JavaToIfxTypeTable.putIfAbsent(new String("com.gbasedbt.lang.IntervalDF"), 14);
            JavaToIfxTypeTable.putIfAbsent(new String("java.util.ArrayList"), 21);
            JavaToIfxTypeTable.putIfAbsent(new String("java.util.LinkedList"), 21);
            JavaToIfxTypeTable.putIfAbsent(new String("java.util.Vector"), 21);
            JavaToIfxTypeTable.putIfAbsent(new String("java.util.HashSet"), 19);
            JavaToIfxTypeTable.putIfAbsent(new String("java.util.TreeSet"), 19);
            JavaToIfxTypeTable.putIfAbsent(new String("java.lang.Boolean"), 45);
            JavaToIfxTypeTable.putIfAbsent(new String("java.sql.Blob"), 102);
            JavaToIfxTypeTable.putIfAbsent(new String("java.sql.Clob"), 101);
        }
        if (IfxTypeToJavaTable == null) {
            IfxTypeToJavaTable = new ConcurrentHashMap(54);
            IfxTypeToJavaTable.putIfAbsent(0, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(1, new String("java.lang.Short"));
            IfxTypeToJavaTable.putIfAbsent(2, new String("java.lang.Integer"));
            IfxTypeToJavaTable.putIfAbsent(3, new String("java.lang.Double"));
            IfxTypeToJavaTable.putIfAbsent(4, new String("java.lang.Float"));
            IfxTypeToJavaTable.putIfAbsent(5, new String("java.math.BigDecimal"));
            IfxTypeToJavaTable.putIfAbsent(6, new String("java.lang.Integer"));
            IfxTypeToJavaTable.putIfAbsent(7, new String("java.sql.Date"));
            IfxTypeToJavaTable.putIfAbsent(8, new String("java.math.BigDecimal"));
            IfxTypeToJavaTable.putIfAbsent(10, new String("java.sql.Timestamp"));
            IfxTypeToJavaTable.putIfAbsent(65, new String("java.sql.Timestamp"));
            IfxTypeToJavaTable.putIfAbsent(11, new String("[B"));
            IfxTypeToJavaTable.putIfAbsent(12, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(13, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(63, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(14, new String("com.gbasedbt.lang.Interval"));
            IfxTypeToJavaTable.putIfAbsent(15, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(16, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(64, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(17, new String("java.lang.Long"));
            IfxTypeToJavaTable.putIfAbsent(18, new String("java.lang.Long"));
            IfxTypeToJavaTable.putIfAbsent(19, new String("java.sql.Array"));
            IfxTypeToJavaTable.putIfAbsent(20, new String("java.sql.Array"));
            IfxTypeToJavaTable.putIfAbsent(21, new String("java.sql.Array"));
            IfxTypeToJavaTable.putIfAbsent(22, new String("java.sql.Struct"));
            IfxTypeToJavaTable.putIfAbsent(40, new String("java.sql.SQLData"));
            IfxTypeToJavaTable.putIfAbsent(41, new String("java.sql.SQLData"));
            IfxTypeToJavaTable.putIfAbsent(43, new String("java.lang.String"));
            IfxTypeToJavaTable.putIfAbsent(44, new String("java.sql.SQLData"));
            IfxTypeToJavaTable.putIfAbsent(45, new String("java.lang.Boolean"));
            IfxTypeToJavaTable.putIfAbsent(46, new String("java.sql.SQLData"));
            IfxTypeToJavaTable.putIfAbsent(47, new String("java.sql.SQLData"));
            IfxTypeToJavaTable.putIfAbsent(52, new String("java.lang.Long"));
            IfxTypeToJavaTable.putIfAbsent(53, new String("java.lang.Long"));
        }
        if (IfxTypeToNameTable == null) {
            IfxTypeToNameTable = new ConcurrentHashMap(54);
            IfxTypeToNameTable.putIfAbsent(0, new String("char"));
            IfxTypeToNameTable.putIfAbsent(1, new String("smallint"));
            IfxTypeToNameTable.putIfAbsent(2, new String("int"));
            IfxTypeToNameTable.putIfAbsent(3, new String("float"));
            IfxTypeToNameTable.putIfAbsent(4, new String("smallfloat"));
            IfxTypeToNameTable.putIfAbsent(5, new String("decimal"));
            IfxTypeToNameTable.putIfAbsent(6, new String("serial"));
            IfxTypeToNameTable.putIfAbsent(7, new String("date"));
            IfxTypeToNameTable.putIfAbsent(8, new String("money"));
            IfxTypeToNameTable.putIfAbsent(10, new String("datetime"));
            IfxTypeToNameTable.putIfAbsent(65, new String("timestamp with time zone"));
            IfxTypeToNameTable.putIfAbsent(11, new String("byte"));
            IfxTypeToNameTable.putIfAbsent(12, new String("text"));
            IfxTypeToNameTable.putIfAbsent(13, new String("varchar"));
            IfxTypeToNameTable.putIfAbsent(63, new String("varchar2"));
            IfxTypeToNameTable.putIfAbsent(14, new String("interval"));
            IfxTypeToNameTable.putIfAbsent(15, new String("nchar"));
            IfxTypeToNameTable.putIfAbsent(16, new String("nvarchar"));
            IfxTypeToNameTable.putIfAbsent(64, new String("nvarchar2"));
            IfxTypeToNameTable.putIfAbsent(17, new String("int8"));
            IfxTypeToNameTable.putIfAbsent(18, new String("serial8"));
            IfxTypeToNameTable.putIfAbsent(43, new String(IFX_XNAME_LVARCHAR));
            IfxTypeToNameTable.putIfAbsent(45, new String(IFX_XNAME_BOOL));
            IfxTypeToNameTable.putIfAbsent(22, new String("row"));
            IfxTypeToNameTable.putIfAbsent(19, new String("set"));
            IfxTypeToNameTable.putIfAbsent(21, new String("list"));
            IfxTypeToNameTable.putIfAbsent(20, new String("multiset"));
            IfxTypeToNameTable.putIfAbsent(43, new String(IFX_XNAME_LVARCHAR));
            IfxTypeToNameTable.putIfAbsent(45, new String(IFX_XNAME_BOOL));
            IfxTypeToNameTable.putIfAbsent(102, new String(IFX_XNAME_BLOB));
            IfxTypeToNameTable.putIfAbsent(101, new String(IFX_XNAME_CLOB));
            IfxTypeToNameTable.putIfAbsent(44, new String("sendrecv"));
            IfxTypeToNameTable.putIfAbsent(46, new String("impexp"));
            IfxTypeToNameTable.putIfAbsent(47, new String("impexpbin"));
            IfxTypeToNameTable.putIfAbsent(52, new String("bigint"));
            IfxTypeToNameTable.putIfAbsent(53, new String("bigserial"));
            IfxTypeToNameTable.putIfAbsent(40, new String("sqludtvar"));
        }
        if (IfxNameToIfxTypeTable == null) {
            IfxNameToIfxTypeTable = new ConcurrentHashMap(54);
            IfxNameToIfxTypeTable.putIfAbsent(new String("char"), 0);
            IfxNameToIfxTypeTable.putIfAbsent(new String("smallint"), 1);
            IfxNameToIfxTypeTable.putIfAbsent(new String("int"), 2);
            IfxNameToIfxTypeTable.putIfAbsent(new String("integer"), 2);
            IfxNameToIfxTypeTable.putIfAbsent(new String("float"), 3);
            IfxNameToIfxTypeTable.putIfAbsent(new String("double precision"), 3);
            IfxNameToIfxTypeTable.putIfAbsent(new String("smallfloat"), 4);
            IfxNameToIfxTypeTable.putIfAbsent(new String("decimal"), 5);
            IfxNameToIfxTypeTable.putIfAbsent(new String("serial"), 6);
            IfxNameToIfxTypeTable.putIfAbsent(new String("date"), 7);
            IfxNameToIfxTypeTable.putIfAbsent(new String("money"), 8);
            IfxNameToIfxTypeTable.putIfAbsent(new String("datetime"), 10);
            IfxNameToIfxTypeTable.putIfAbsent(new String("timestamp with time zone"), 65);
            IfxNameToIfxTypeTable.putIfAbsent(new String("byte"), 11);
            IfxNameToIfxTypeTable.putIfAbsent(new String("text"), 12);
            IfxNameToIfxTypeTable.putIfAbsent(new String("varchar"), 13);
            IfxNameToIfxTypeTable.putIfAbsent(new String("varchar2"), 63);
            IfxNameToIfxTypeTable.putIfAbsent(new String("interval"), 14);
            IfxNameToIfxTypeTable.putIfAbsent(new String("nchar"), 15);
            IfxNameToIfxTypeTable.putIfAbsent(new String("nvarchar"), 16);
            IfxNameToIfxTypeTable.putIfAbsent(new String("nvarchar2"), 64);
            IfxNameToIfxTypeTable.putIfAbsent(new String("int8"), 17);
            IfxNameToIfxTypeTable.putIfAbsent(new String("serial8"), 18);
            IfxNameToIfxTypeTable.putIfAbsent(new String("row"), 22);
            IfxNameToIfxTypeTable.putIfAbsent(new String("set"), 19);
            IfxNameToIfxTypeTable.putIfAbsent(new String("list"), 21);
            IfxNameToIfxTypeTable.putIfAbsent(new String("multiset"), 20);
            IfxNameToIfxTypeTable.putIfAbsent(new String(IFX_XNAME_LVARCHAR), 43);
            IfxNameToIfxTypeTable.putIfAbsent(new String(IFX_XNAME_BOOL), 45);
            IfxNameToIfxTypeTable.putIfAbsent(new String(IFX_XNAME_BLOB), 102);
            IfxNameToIfxTypeTable.putIfAbsent(new String(IFX_XNAME_CLOB), 101);
            IfxNameToIfxTypeTable.putIfAbsent(new String("bigserial"), 53);
            IfxNameToIfxTypeTable.putIfAbsent(new String("bigint"), 52);
        }
        if (JDBCTypeToNameTable == null) {
            JDBCTypeToNameTable = new ConcurrentHashMap(54);
            JDBCTypeToNameTable.putIfAbsent(-5, new String("java.sql.Types.BIGINT"));
            JDBCTypeToNameTable.putIfAbsent(-2, new String("java.sql.Types.BINARY"));
            JDBCTypeToNameTable.putIfAbsent(-7, new String("java.sql.Types.BIT"));
            JDBCTypeToNameTable.putIfAbsent(1, new String("java.sql.Types.CHAR"));
            JDBCTypeToNameTable.putIfAbsent(91, new String("java.sql.Types.DATE"));
            JDBCTypeToNameTable.putIfAbsent(3, new String("java.sql.Types.DECIMAL"));
            JDBCTypeToNameTable.putIfAbsent(8, new String("java.sql.Types.DOUBLE"));
            JDBCTypeToNameTable.putIfAbsent(6, new String("java.sql.Types.FLOAT"));
            JDBCTypeToNameTable.putIfAbsent(4, new String("java.sql.Types.INTEGER"));
            JDBCTypeToNameTable.putIfAbsent(-4, new String("java.sql.Types.LONGVARBINARY"));
            JDBCTypeToNameTable.putIfAbsent(-1, new String("java.sql.Types.LONGVARCHAR"));
            JDBCTypeToNameTable.putIfAbsent(0, new String("java.sql.Types.NULL"));
            JDBCTypeToNameTable.putIfAbsent(2, new String("java.sql.Types.NUMERIC"));
            JDBCTypeToNameTable.putIfAbsent(7, new String("java.sql.Types.REAL"));
            JDBCTypeToNameTable.putIfAbsent(5, new String("java.sql.Types.SMALLINT"));
            JDBCTypeToNameTable.putIfAbsent(92, new String("java.sql.Types.TIME"));
            JDBCTypeToNameTable.putIfAbsent(93, new String("java.sql.Types.TIMESTAMP"));
            JDBCTypeToNameTable.putIfAbsent(-6, new String("java.sql.Types.TINYINT"));
            JDBCTypeToNameTable.putIfAbsent(1111, new String("java.sql.Types.OTHER"));
            JDBCTypeToNameTable.putIfAbsent(-3, new String("java.sql.Types.VARBINARY"));
            JDBCTypeToNameTable.putIfAbsent(12, new String("java.sql.Types.VARCHAR"));
            JDBCTypeToNameTable.putIfAbsent(2003, new String("java.sql.Types.ARRAY"));
            JDBCTypeToNameTable.putIfAbsent(2004, new String("java.sql.Types.BLOB"));
            JDBCTypeToNameTable.putIfAbsent(2005, new String("java.sql.Types.CLOB"));
            JDBCTypeToNameTable.putIfAbsent(2001, new String("java.sql.Types.DISTINCT"));
            JDBCTypeToNameTable.putIfAbsent(2000, new String("java.sql.Types.JAVA_OBJECT"));
            JDBCTypeToNameTable.putIfAbsent(2002, new String("java.sql.Types.STRUCT"));
            JDBCTypeToNameTable.putIfAbsent(16, new String("java.sql.Types.BOOLEAN"));
        }
        if (IfxToJDBC2TypeTable == null) {
            IfxToJDBC2TypeTable = new ConcurrentHashMap(54);
            IfxToJDBC2TypeTable.putIfAbsent(0, 1);
            IfxToJDBC2TypeTable.putIfAbsent(1, 5);
            IfxToJDBC2TypeTable.putIfAbsent(2, 4);
            IfxToJDBC2TypeTable.putIfAbsent(3, 8);
            IfxToJDBC2TypeTable.putIfAbsent(4, 7);
            IfxToJDBC2TypeTable.putIfAbsent(5, 3);
            IfxToJDBC2TypeTable.putIfAbsent(6, 4);
            IfxToJDBC2TypeTable.putIfAbsent(7, 91);
            IfxToJDBC2TypeTable.putIfAbsent(8, 3);
            IfxToJDBC2TypeTable.putIfAbsent(9, 0);
            IfxToJDBC2TypeTable.putIfAbsent(10, 93);
            IfxToJDBC2TypeTable.putIfAbsent(65, 2014);
            IfxToJDBC2TypeTable.putIfAbsent(11, -4);
            IfxToJDBC2TypeTable.putIfAbsent(12, -1);
            IfxToJDBC2TypeTable.putIfAbsent(13, 12);
            IfxToJDBC2TypeTable.putIfAbsent(63, 63);
            IfxToJDBC2TypeTable.putIfAbsent(64, 64);
            IfxToJDBC2TypeTable.putIfAbsent(15, 1);
            IfxToJDBC2TypeTable.putIfAbsent(16, 12);
            IfxToJDBC2TypeTable.putIfAbsent(14, 1);
            IfxToJDBC2TypeTable.putIfAbsent(17, -5);
            IfxToJDBC2TypeTable.putIfAbsent(18, -5);
            IfxToJDBC2TypeTable.putIfAbsent(19, 2003);
            IfxToJDBC2TypeTable.putIfAbsent(21, 2003);
            IfxToJDBC2TypeTable.putIfAbsent(20, 2003);
            IfxToJDBC2TypeTable.putIfAbsent(22, 2002);
            IfxToJDBC2TypeTable.putIfAbsent(40, 2000);
            IfxToJDBC2TypeTable.putIfAbsent(41, 2000);
            IfxToJDBC2TypeTable.putIfAbsent(43, -1);
            IfxToJDBC2TypeTable.putIfAbsent(44, 2000);
            IfxToJDBC2TypeTable.putIfAbsent(45, 16);
            IfxToJDBC2TypeTable.putIfAbsent(46, 2000);
            IfxToJDBC2TypeTable.putIfAbsent(47, 2000);
            IfxToJDBC2TypeTable.putIfAbsent(101, 2005);
            IfxToJDBC2TypeTable.putIfAbsent(102, 2004);
            IfxToJDBC2TypeTable.putIfAbsent(53, -5);
            IfxToJDBC2TypeTable.putIfAbsent(52, -5);
        }
        if (IfxTypeToDecDigitsTable == null) {
            IfxTypeToDecDigitsTable = new ConcurrentHashMap(54);
            IfxTypeToDecDigitsTable.putIfAbsent(0, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(1, 5);
            IfxTypeToDecDigitsTable.putIfAbsent(2, 10);
            IfxTypeToDecDigitsTable.putIfAbsent(3, 15);
            IfxTypeToDecDigitsTable.putIfAbsent(4, 7);
            IfxTypeToDecDigitsTable.putIfAbsent(5, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(6, 10);
            IfxTypeToDecDigitsTable.putIfAbsent(7, 10);
            IfxTypeToDecDigitsTable.putIfAbsent(8, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(9, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(10, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(65, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(11, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(12, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(13, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(63, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(15, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(16, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(64, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(14, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(17, 19);
            IfxTypeToDecDigitsTable.putIfAbsent(18, 19);
            IfxTypeToDecDigitsTable.putIfAbsent(19, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(21, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(22, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(40, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(41, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(43, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(44, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(45, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(46, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(47, 0);
            IfxTypeToDecDigitsTable.putIfAbsent(102, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(101, -1);
            IfxTypeToDecDigitsTable.putIfAbsent(52, 19);
            IfxTypeToDecDigitsTable.putIfAbsent(53, 19);
        }
        if (IfxExTypeToDecDigitsTable == null) {
            IfxExTypeToDecDigitsTable = new ConcurrentHashMap(54);
            IfxExTypeToDecDigitsTable.putIfAbsent(1, -1);
            IfxExTypeToDecDigitsTable.putIfAbsent(2, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(3, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(4, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(5, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(6, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(7, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(8, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(9, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(10, -1);
            IfxExTypeToDecDigitsTable.putIfAbsent(11, -1);
            IfxExTypeToDecDigitsTable.putIfAbsent(12, 0);
            IfxExTypeToDecDigitsTable.putIfAbsent(15, 0);
        }
        if (IfxExTypeToNameTable == null) {
            IfxExTypeToNameTable = new ConcurrentHashMap(34);
            IfxExTypeToNameTable.putIfAbsent(1, new String("IFX_XID_LVARCHAR"));
            IfxExTypeToNameTable.putIfAbsent(2, new String("IFX_XID_SENDRECV"));
            IfxExTypeToNameTable.putIfAbsent(3, new String("IFX_XID_IMPEXP"));
            IfxExTypeToNameTable.putIfAbsent(4, new String("IFX_XID_IMPEXPBIN"));
            IfxExTypeToNameTable.putIfAbsent(5, new String("IFX_XID_BOOLEAN"));
            IfxExTypeToNameTable.putIfAbsent(6, new String("IFX_XID_POINTER"));
            IfxExTypeToNameTable.putIfAbsent(7, new String("IFX_XID_INDEXKEYARRAY"));
            IfxExTypeToNameTable.putIfAbsent(8, new String("IFX_XID_RTNPARAMTYPES"));
            IfxExTypeToNameTable.putIfAbsent(9, new String("IFX_XID_SELFUNCARGS"));
            IfxExTypeToNameTable.putIfAbsent(10, new String("IFX_XID_BLOB"));
            IfxExTypeToNameTable.putIfAbsent(11, new String("IFX_XID_CLOB"));
            IfxExTypeToNameTable.putIfAbsent(12, new String("IFX_XID_LOLIST"));
            IfxExTypeToNameTable.putIfAbsent(13, new String("IFX_XID_IFX_LO_SPEC"));
            IfxExTypeToNameTable.putIfAbsent(14, new String("IFX_XID_IFX_LO_STAT"));
            IfxExTypeToNameTable.putIfAbsent(16, new String("IFX_XID_CLIENTBINVAL"));
            IfxExTypeToNameTable.putIfAbsent(17, new String("IFX_XID_STREAM"));
            IfxExTypeToNameTable.putIfAbsent(18, new String("IFX_XID_IDSSECURITYLABEL"));
            IfxExTypeToNameTable.putIfAbsent(19, new String("IFX_XID_IDSELEMENTENC"));
            IfxExTypeToNameTable.putIfAbsent(20, new String("IFX_XID_IDSCOVERINGINFO"));
            IfxExTypeToNameTable.putIfAbsent(24, new String("IFX_XID_LLVC"));
            IfxExTypeToNameTable.putIfAbsent(25, new String("IFX_XID_JSON"));
            IfxExTypeToNameTable.putIfAbsent(26, new String("IFX_XID_BSON"));
            IfxExTypeToNameTable.putIfAbsent(34, new String("IFX_XID_RAW"));
        }
    }
}

