/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.bson.BSONDecoder;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.Transformer;
import org.bson.a;
import org.bson.b;
import org.bson.c;
import org.bson.util.ClassMap;

public class BSON {
    static final Logger a = Logger.getLogger("org.bson.BSON");
    public static final byte EOO = 0;
    public static final byte NUMBER = 1;
    public static final byte STRING = 2;
    public static final byte OBJECT = 3;
    public static final byte ARRAY = 4;
    public static final byte BINARY = 5;
    public static final byte UNDEFINED = 6;
    public static final byte OID = 7;
    public static final byte BOOLEAN = 8;
    public static final byte DATE = 9;
    public static final byte NULL = 10;
    public static final byte REGEX = 11;
    public static final byte REF = 12;
    public static final byte CODE = 13;
    public static final byte SYMBOL = 14;
    public static final byte CODE_W_SCOPE = 15;
    public static final byte NUMBER_INT = 16;
    public static final byte TIMESTAMP = 17;
    public static final byte NUMBER_LONG = 18;
    public static final byte MINKEY = -1;
    public static final byte MAXKEY = 127;
    public static final byte B_GENERAL = 0;
    public static final byte B_FUNC = 1;
    public static final byte B_BINARY = 2;
    public static final byte B_UUID = 3;
    private static final int b = 256;
    private static boolean c = false;
    private static boolean d = false;
    static ClassMap<List<Transformer>> e = new ClassMap();
    static ClassMap<List<Transformer>> f = new ClassMap();
    protected static Charset _utf8 = Charset.forName("UTF-8");
    static ThreadLocal<BSONEncoder> g = new b();
    static ThreadLocal<BSONDecoder> h = new c();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int regexFlags(String string) {
        int n2;
        int n3;
        boolean bl;
        block9: {
            bl = BasicBSONObject.b;
            n3 = 0;
            if (string != null && string.length() != 0) break block9;
            return n3;
        }
        string = string.toLowerCase();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2);
            if (bl) return n2;
            a a2 = org.bson.a.getByCharacter((char)n2);
            if (a2 == null) throw new IllegalArgumentException("unrecognized flag [" + string.charAt(i2) + "] " + string.charAt(i2));
            n3 |= a2.javaFlag;
            if (a2.unsupported == null) continue;
            BSON.a(a2.unsupported);
            if (!bl) continue;
            throw new IllegalArgumentException("unrecognized flag [" + string.charAt(i2) + "] " + string.charAt(i2));
        }
        n2 = n3;
        return n2;
    }

    public static int regexFlag(char c2) {
        a a2 = org.bson.a.getByCharacter(c2);
        if (a2 == null) {
            throw new IllegalArgumentException("unrecognized flag [" + c2 + "]");
        }
        if (a2.unsupported != null) {
            BSON.a(a2.unsupported);
            return 0;
        }
        return a2.javaFlag;
    }

    public static String regexFlags(int n2) {
        int n3;
        StringBuilder stringBuilder;
        block6: {
            boolean bl = BasicBSONObject.b;
            stringBuilder = new StringBuilder();
            for (a a2 : org.bson.a.values()) {
                n3 = n2 & a2.javaFlag;
                if (bl) break block6;
                if (n3 <= 0) continue;
                stringBuilder.append(a2.flagChar);
                n2 -= a2.javaFlag;
                if (!bl) continue;
            }
            n3 = n2;
        }
        if (n3 > 0) {
            throw new IllegalArgumentException("some flags could not be recognized.");
        }
        return stringBuilder.toString();
    }

    private static void a(String string) {
        a.info("flag " + string + " not supported by db.");
    }

    public static boolean hasDecodeHooks() {
        return d;
    }

    public static void addEncodingHook(Class<?> clazz, Transformer transformer) {
        c = true;
        List<Transformer> list = e.get(clazz);
        if (list == null) {
            list = new CopyOnWriteArrayList<Transformer>();
            e.put(clazz, list);
        }
        list.add(transformer);
    }

    public static void addDecodingHook(Class<?> clazz, Transformer transformer) {
        d = true;
        List<Transformer> list = f.get(clazz);
        if (list == null) {
            list = new CopyOnWriteArrayList<Transformer>();
            f.put(clazz, list);
        }
        list.add(transformer);
    }

    public static Object applyEncodingHooks(Object object) {
        Object object2;
        boolean bl;
        block11: {
            bl = BasicBSONObject.b;
            if (!BSON.a()) {
                return object;
            }
            if (e.size() != 0 && object != null) break block11;
            return object;
        }
        List<Transformer> list = e.get(object.getClass());
        if (list != null) {
            for (Transformer transformer : list) {
                object2 = transformer.transform(object);
                if (!bl) {
                    object = object2;
                    if (!bl) continue;
                }
                break;
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    public static Object applyDecodingHooks(Object object) {
        Object object2;
        boolean bl;
        block8: {
            bl = BasicBSONObject.b;
            if (BSON.a() && object != null) break block8;
            return object;
        }
        List<Transformer> list = f.get(object.getClass());
        if (list != null) {
            for (Transformer transformer : list) {
                object2 = transformer.transform(object);
                if (!bl) {
                    object = object2;
                    if (!bl) continue;
                }
                break;
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    public static List<Transformer> getEncodingHooks(Class<?> clazz) {
        return e.get(clazz);
    }

    public static void clearEncodingHooks() {
        c = false;
        e.clear();
    }

    public static void removeEncodingHooks(Class<?> clazz) {
        e.remove(clazz);
    }

    public static void removeEncodingHook(Class<?> clazz, Transformer transformer) {
        BSON.getEncodingHooks(clazz).remove(transformer);
    }

    public static List<Transformer> getDecodingHooks(Class<?> clazz) {
        return f.get(clazz);
    }

    public static void clearDecodingHooks() {
        d = false;
        f.clear();
    }

    public static void removeDecodingHooks(Class<?> clazz) {
        f.remove(clazz);
    }

    public static void removeDecodingHook(Class<?> clazz, Transformer transformer) {
        BSON.getDecodingHooks(clazz).remove(transformer);
    }

    public static void clearAllHooks() {
        BSON.clearEncodingHooks();
        BSON.clearDecodingHooks();
    }

    private static boolean a() {
        boolean bl;
        block5: {
            block4: {
                if (!c && !d) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public static byte[] encode(BSONObject bSONObject) {
        BSONEncoder bSONEncoder = g.get();
        try {
            byte[] byArray = bSONEncoder.encode(bSONObject);
            return byArray;
        }
        finally {
            bSONEncoder.done();
        }
    }

    public static BSONObject decode(byte[] byArray) {
        BSONDecoder bSONDecoder = h.get();
        return bSONDecoder.readObject(byArray);
    }

    public static int toInt(Object object) {
        block10: {
            int n2;
            block12: {
                block11: {
                    if (object == null) {
                        throw new NullPointerException("can't be null");
                    }
                    if (object instanceof Number) {
                        return ((Number)object).intValue();
                    }
                    if (!(object instanceof Boolean)) break block10;
                    if (!((Boolean)object).booleanValue()) break block11;
                    n2 = 1;
                    break block12;
                }
                n2 = 0;
            }
            return n2;
        }
        throw new IllegalArgumentException("can't convert: " + object.getClass().getName() + " to int");
    }
}

