/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.util.Vector;
import sqlj.framework.BaseJSClass;
import sqlj.framework.JSClass;
import sqlj.framework.JSConstructor;
import sqlj.framework.JSField;
import sqlj.framework.JSMethod;
import sqlj.javac.ASTConstructorDeclaration;
import sqlj.javac.ASTMethodDeclaration;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.SimpleTypeNode;
import sqlj.javac.SymTabEntry;
import sqlj.util.ClassDescriptor;
import sqlj.util.TypeDescriptor;

public class JavaClass
extends JSClass {
    protected SimpleTypeNode m_class;
    protected JSClass declaringClass;
    private JSClass superClass;
    protected JSClass[] interfaces;
    protected JSField[] fields;
    protected JSMethod[] methods;
    private JSConstructor[] constructors;
    private JavaParserImpl javaParser;

    public JavaClass(SimpleTypeNode simpleTypeNode, BaseJSClass baseJSClass, JavaParserImpl javaParserImpl) throws ClassNotFoundException {
        super(baseJSClass);
        int n2;
        Vector vector;
        this.m_class = simpleTypeNode;
        this.javaParser = javaParserImpl;
        String string = this.m_class.getSuperName();
        if (string != null) {
            try {
                this.superClass = this.resolveClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.Warning("Undefined base class '" + string + "'.");
            }
        } else {
            this.superClass = null;
        }
        if ((vector = this.m_class.getInterfaces()).size() > 0) {
            this.interfaces = new JSClass[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                try {
                    this.interfaces[n2] = this.resolveClass((String)vector.elementAt(n2));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.Warning("Undefined base interface '" + vector.elementAt(n2) + "'.");
                }
            }
        } else {
            this.interfaces = new JSClass[0];
        }
        if ((vector = this.m_class.getMethods()).size() > 0) {
            this.methods = new JSMethod[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.methods[n2] = ((ASTMethodDeclaration)vector.elementAt(n2)).getJSMethod(this);
            }
        } else {
            this.methods = new JSMethod[0];
        }
        if ((vector = this.m_class.getConstructors()).size() > 0) {
            this.constructors = new JSConstructor[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.constructors[n2] = ((ASTConstructorDeclaration)vector.elementAt(n2)).getJSConstructor(this);
            }
        } else {
            this.constructors = new JSConstructor[0];
        }
        if ((vector = this.m_class.getFields()).size() > 0) {
            this.fields = new JSField[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(n2);
                if (symTabEntry.isType) continue;
                try {
                    this.fields[n2] = symTabEntry.getJSField(this);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.Warning("Undefined field type '" + symTabEntry.typ.getName() + "'.");
                }
            }
        } else {
            this.fields = new JSField[0];
        }
    }

    final void Warning(String string) {
        if (this.javaParser != null) {
            this.javaParser.Warning(string);
        }
    }

    final void Error(String string, int n2, int n3) {
        if (this.javaParser != null) {
            this.javaParser.Error(string, n2, n3);
        }
    }

    final void Error(String string) {
        if (this.javaParser != null) {
            this.javaParser.Error(string);
        }
    }

    @Override
    public JSClass getSuperclass() {
        return this.superClass;
    }

    @Override
    public JSClass[] getInterfaces() {
        return this.interfaces;
    }

    @Override
    public JSClass getDeclaringClass() {
        if (this.declaringClass != null) {
            return this.declaringClass;
        }
        TypeDescriptor typeDescriptor = this.m_class.getScope().getDescriptor();
        if (typeDescriptor instanceof ClassDescriptor) {
            try {
                this.declaringClass = ((ClassDescriptor)typeDescriptor).getReflection();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this.declaringClass;
        }
        return null;
    }

    @Override
    public JSClass[] getDeclaredClasses() {
        return new JSClass[0];
    }

    @Override
    public JSField[] getDeclaredFields() {
        if (this.fields == null) {
            return new JSField[0];
        }
        return this.fields;
    }

    @Override
    public JSMethod[] getDeclaredMethods() {
        return this.methods;
    }

    @Override
    public JSConstructor[] getDeclaredConstructors() {
        return this.constructors;
    }
}

