/*
 * Decompiled with CFR 0.152.
 */
package sqlj.tools;

import java.util.Enumeration;
import java.util.Hashtable;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.options.HasOptions;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.OptionInfoArray;
import sqlj.framework.options.PropertyList;
import sqlj.mesg.SemanticOptions;
import sqlj.mesg.TranslatorOptions;

public class SqljOptions
implements HasOptions {
    private static final Boolean noValue = new Boolean(false);
    private Hashtable all_keys;
    private ErrorLog m_el;

    public SqljOptions(String[] stringArray, ErrorLog errorLog) {
        this.m_el = errorLog;
        this.all_keys = new Hashtable(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.all_keys.put(stringArray[i2], noValue);
        }
    }

    @Override
    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        Enumeration enumeration = propertyList.propertyNames(false);
        while (enumeration.hasMoreElements()) {
            String string = ((String)enumeration.nextElement()).trim();
            if (this.all_keys.get(string) == null) continue;
            String[] stringArray = new String[]{propertyList.getProperty(string), propertyList.getPropertyLocation(string)};
            this.all_keys.put(string, stringArray);
        }
    }

    @Override
    public String[][] getOptionInfo() {
        Enumeration enumeration = this.all_keys.keys();
        OptionInfoArray optionInfoArray = new OptionInfoArray();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = TranslatorOptions.getOptionInfo(string);
            stringArray[4] = SemanticOptions.theWordDefault();
            Object v2 = this.all_keys.get(string);
            if (v2 != null && v2 != noValue) {
                String[] stringArray2 = (String[])v2;
                stringArray[2] = stringArray2[0];
                stringArray[4] = stringArray2[1];
            }
            optionInfoArray.addInfo(stringArray);
        }
        return optionInfoArray.getInfo();
    }

    String getOption(String string) {
        String[] stringArray;
        Object v2 = this.all_keys.get(string);
        if (v2 == null || v2 == noValue) {
            String[] stringArray2 = TranslatorOptions.getOptionInfo(string);
            stringArray = new String[]{stringArray2[2], stringArray2[4]};
            this.all_keys.put(string, stringArray);
        } else {
            if (v2 == noValue) {
                return null;
            }
            stringArray = (String[])v2;
        }
        return stringArray[0];
    }

    boolean getBoolean(String string) {
        try {
            return this.getBooleanOption(string);
        }
        catch (InvalidOptionException invalidOptionException) {
            return false;
        }
    }

    boolean getBooleanOption(String string) throws InvalidOptionException {
        String string2 = this.getOption(string);
        if (string2 == null) {
            return false;
        }
        if (string2.equals("")) {
            return true;
        }
        if ((string2 = string2.toLowerCase().trim()).equals("1") || string2.equals("y") || string2.equals("yes") || string2.equals("t") || string2.equals("true") || string2.equals("on") || string2.equals("+")) {
            return true;
        }
        if (string2.equals("0") || string2.equals("n") || string2.equals("no") || string2.equals("f") || string2.equals("false") || string2.equals("off") || string2.equals("-")) {
            return false;
        }
        throw new InvalidOptionException(string2);
    }
}

