/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.gbasedbt.jdbc.IfmxCallableStatement;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxInteger;
import com.gbasedbt.jdbc.IfxLvarchar;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxSqli;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.UDRMetaData;

public class UDRManager {
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    static Hashtable JavaToIfxNameTable;
    static final String IFX_FILE_TO_FILE = "function gbasedbt.ifx_file_to_file(lvarchar,int,lvarchar,int)";
    static final int LO_SERVER_FILE = 0x10000000;
    static final int LO_CLIENT_FILE = 0x20000000;

    public UDRManager(Connection connection) throws SQLException {
        if (connection == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        this.conn = (IfxConnection)connection;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
        if (TraceFlag.compiletrace) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.out.println("UDRManager: Trace is NULL");
            } else {
                this.trace.writeTrace(1, "UDRManager: constructor exited");
            }
        }
    }

    public void createUDRs(UDRMetaData uDRMetaData, String string, String string2, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:createUDRs() entered");
        }
        if (uDRMetaData == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        UDRManager.checkJarFile(string, this.locale);
        int n3 = this.conn.getDatabaseType();
        if (n3 == 0) {
            throw IfxErrMsg.getSQLException(-79844, "", this.locale);
        }
        Hashtable hashtable = uDRMetaData.udrs;
        if (hashtable == null || hashtable.size() == 0) {
            throw IfxErrMsg.getSQLException(-79842, "", this.locale);
        }
        String string3 = uDRMetaData.jarFileSQLName;
        if (string3 == null) {
            throw IfxErrMsg.getSQLException(-79843, "", this.locale);
        }
        UDRManager.checkJarInSysCatalog(string3, this.conn, this.locale);
        String string4 = UDRManager.transportJarToServer(string, this.jarTmpPath, this.conn, this.locale);
        if (n3 == 1 || n3 == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(string3, string4, n2, this.conn);
            UDRManager.registerUDRs(uDRMetaData, string2, null, this.conn, this.locale);
        }
        catch (SQLException sQLException) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw sQLException;
            }
            throw sQLException;
        }
        if (!(n3 != 1 && n3 != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(string4, this.conn);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:createUDRs() exited");
        }
    }

    public void removeUDR(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String) entered");
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        String string2 = "DROP ROUTINE " + string;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string2);
        }
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string2);
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String) exited");
        }
    }

    public void removeUDR(String string, Class[] classArray) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String, Class[]) entered");
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        String string2 = "";
        if (classArray != null) {
            string2 = UDRManager.fromClassesToIfxNames(classArray, null, null, this.trace, this.locale);
        }
        String string3 = "DROP ROUTINE " + string + "(" + string2 + ")";
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + string3);
        }
        Statement statement = this.conn.createStatement();
        statement.executeUpdate(string3);
        statement.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:removeUDR(String, Class[]) exited");
        }
    }

    public void removeJar(String string, int n2) throws SQLException {
        UDRManager.removeJarNow(string, n2, this.conn, this.locale);
    }

    public void setJarTmpPath(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDRManager:setJarTmpPath() entered");
        }
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, string, this.locale);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "jarTmpPath = " + this.jarTmpPath);
            this.trace.writeTrace(1, "UDRManager:setJarTmpPath() exited");
        }
    }

    static boolean isNTServer(IfxConnection ifxConnection) throws SQLException {
        boolean bl = false;
        int n2 = 0;
        if (ifxConnection == null) {
            return false;
        }
        String string = ifxConnection.getDbVersion();
        for (int i2 = 0; !bl && i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '.' || ++n2 != 2 || string.charAt(i2 + 1) != 'T') continue;
            bl = true;
        }
        return bl;
    }

    static String getJarTmpPathNow(IfxConnection ifxConnection, String string, Locale locale) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, "", locale);
        }
        if (UDRManager.isNTServer(ifxConnection)) {
            return string + "\\";
        }
        return string + "/";
    }

    static void checkJarFile(String string, Locale locale) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, "", locale);
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw IfxErrMsg.getSQLException(-79845, "", locale);
        }
    }

    static void checkJarInSysCatalog(String string, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:checkJarInSysCatalog() entered");
        }
        String string2 = "select tabname from gbasedbt.systables where tabname = 'retained_jars' and owner = 'sqlj'";
        Statement statement = ifxConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = resultSet.next();
        resultSet.close();
        if (!bl) {
            statement.close();
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "sql = " + string2);
                trace.writeTrace(1, "UDRManager:checkJarInSysCatalog() exited");
            }
            return;
        }
        String string3 = ifxConnection.getDbName() + "." + ifxConnection.getUserName() + "." + string;
        string2 = "select jarname from 'sqlj'.retained_jars where jarname = '" + string3 + "'";
        resultSet = statement.executeQuery(string2);
        boolean bl2 = resultSet.next();
        resultSet.close();
        statement.close();
        if (bl2) {
            throw IfxErrMsg.getSQLException(-79839, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "sql = " + string2);
            trace.writeTrace(1, "UDRManager:checkJarInSysCatalog() exited");
        }
    }

    static String transportJarToServer(String string, String string2, IfxConnection ifxConnection, Locale locale) throws SQLException {
        int n2;
        String string3;
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:transportJarToServer() entered");
            trace.writeTrace(3, "jarfile = '" + string + "'");
            trace.writeTrace(3, "jarTmpPath = '" + string2 + "'");
        }
        String string4 = System.getProperty("file.separator");
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "fsep = '" + string4 + "'");
        }
        if (!(string3 = string.substring((n2 = string.lastIndexOf(string4)) + 1)).endsWith(".jar")) {
            throw IfxErrMsg.getSQLException(-79846, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "jarnameDotJar = '" + string3 + "'");
        }
        String string5 = string2 + string3;
        IfxLvarchar ifxLvarchar = new IfxLvarchar(string);
        ifxLvarchar.setConnection(ifxConnection);
        ifxLvarchar.setExtendedTypeName("lvarchar");
        IfxInteger ifxInteger = new IfxInteger(0x20000000);
        IfxLvarchar ifxLvarchar2 = new IfxLvarchar(string5);
        ifxLvarchar2.setConnection(ifxConnection);
        ifxLvarchar2.setExtendedTypeName("lvarchar");
        IfxInteger ifxInteger2 = new IfxInteger(0x10000000);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        vector.addElement(ifxLvarchar);
        vector.addElement(ifxInteger);
        vector.addElement(ifxLvarchar2);
        vector.addElement(ifxInteger2);
        IfxSqli ifxSqli = null;
        try {
            ifxSqli = new IfxSqli((IfxSqliConnect)ifxConnection);
        }
        catch (Exception exception) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "exception occurs: " + exception.toString());
            }
            throw IfxErrMsg.getSQLException(-79735, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager.transportJarToServer():");
            trace.writeTrace(3, "Transport from: '" + string + "'");
            trace.writeTrace(3, "            to: '" + string5 + "'");
        }
        Vector<IfxObject> vector2 = ifxSqli.executeFastPath(IFX_FILE_TO_FILE, vector, false);
        ifxSqli.clear();
        ifxSqli = null;
        if (!UDRManager.isNTServer(ifxConnection)) {
            UDRManager.changeFilePermissionInServer(string5, ifxConnection);
        }
        UDRManager.changeFilePermissionInClient(string, ifxConnection, locale);
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:transportJarToServer() exited");
        }
        return string5;
    }

    static void changeFilePermissionInClient(String string, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:changeFilePermissionInClient() entered");
        }
        String string2 = null;
        string2 = System.getProperty("file.separator").equals("/") ? "chmod a+w " + string : "attrib -r " + string;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "cmd is '" + string2 + "'");
        }
        try {
            Process process = Runtime.getRuntime().exec(string2);
            if (process.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79838, "", locale);
            }
        }
        catch (Exception exception) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "exception occurs: " + exception.toString());
            }
            throw IfxErrMsg.getSQLException(-79838, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:changeFilePermissionInClient() exited");
        }
    }

    static void changeFilePermissionInServer(String string, IfxConnection ifxConnection) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:changeFilePermissionInServer() entered");
        }
        Statement statement = ifxConnection.createStatement();
        String string2 = null;
        string2 = UDRManager.isNTServer(ifxConnection) ? "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'cmd /C attrib -r ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_chperm (fname varchar(80)) \nsystem 'chmod 666 ' || fname; \nEND PROCEDURE";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + string2);
        }
        statement.execute(string2);
        string2 = "EXECUTE PROCEDURE udtudrmgr_chperm ('" + string + "')";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + string2);
        }
        statement.execute(string2);
        string2 = "DROP PROCEDURE udtudrmgr_chperm (varchar)";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + string2);
        }
        statement.execute(string2);
        statement.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:changeFilePermissionInServer() exited");
        }
    }

    static void removeFileInServer(String string, IfxConnection ifxConnection) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:removeFileInServer() entered");
        }
        Statement statement = ifxConnection.createStatement();
        String string2 = null;
        string2 = UDRManager.isNTServer(ifxConnection) ? "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'cmd /C del ' || fname; \nEND PROCEDURE" : "CREATE PROCEDURE udtudrmgr_rmfile (fname varchar(80)) \nsystem 'rm ' || fname; \nEND PROCEDURE";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + string2);
        }
        statement.execute(string2);
        string2 = "EXECUTE PROCEDURE udtudrmgr_rmfile ('" + string + "')";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + string2);
        }
        statement.execute(string2);
        string2 = "DROP PROCEDURE udtudrmgr_rmfile (varchar)";
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "UDRManager: sql = " + string2);
        }
        statement.execute(string2);
        statement.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:removeFileInServer() exited");
        }
    }

    static void installJarNow(String string, String string2, int n2, IfxConnection ifxConnection) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:installJarNow() entered");
        }
        String string3 = "file:" + string2;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "sql = execute procedure sqlj.install_jar('" + string3 + "', '" + string + "', " + n2 + ")");
        }
        IfmxCallableStatement ifmxCallableStatement = (IfmxCallableStatement)ifxConnection.prepareCall("{ call sqlj.install_jar(?,?,?) }");
        ifmxCallableStatement.setString(1, string3);
        ifmxCallableStatement.setString(2, string);
        ifmxCallableStatement.setInt(3, n2);
        ifmxCallableStatement.executeUpdate();
        ifmxCallableStatement.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:installJarNow() exited");
        }
    }

    static void removeJarNow(String string, int n2, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:removeJarNow() entered");
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, "", locale);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "sql = execute procedure sqlj.remove_jar('" + string + "', " + n2 + ")");
        }
        IfmxCallableStatement ifmxCallableStatement = (IfmxCallableStatement)ifxConnection.prepareCall("{ call sqlj.remove_jar(?,?) }");
        ifmxCallableStatement.setString(1, string);
        ifmxCallableStatement.setInt(2, n2);
        ifmxCallableStatement.executeUpdate();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:removeJarNow() exited");
        }
    }

    static void registerUDRs(UDRMetaData uDRMetaData, String string, String string2, IfxConnection ifxConnection, Locale locale) throws SQLException {
        Trace trace = null;
        if (TraceFlag.compiletrace) {
            trace = ifxConnection.getTrace();
            trace.writeTrace(1, "UDRManager:registerUDRs() entered");
        }
        Method method = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Hashtable hashtable = uDRMetaData.udrs;
        if (hashtable == null || hashtable.size() == 0) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(1, "UDRManager:registerUDRs() exited");
            }
            return;
        }
        String string9 = uDRMetaData.jarFileSQLName;
        Statement statement = ifxConnection.createStatement();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            method = (Method)enumeration.nextElement();
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "m = " + method.toString());
            }
            string3 = method.getName();
            UDRMetaData.udrinfo udrinfo2 = (UDRMetaData.udrinfo)hashtable.get(method);
            string4 = udrinfo2.sqlname;
            string5 = UDRManager.fromClassesToIfxNames(method.getParameterTypes(), string, string2, trace, locale);
            string6 = UDRManager.fromClassesToJavaNames(method.getParameterTypes(), trace);
            string7 = UDRManager.fromClassesToIfxNames(new Class[]{method.getReturnType()}, string, string2, trace, locale);
            string8 = string7.equals("void") ? "CREATE PROCEDURE " + string4 + " (" + string5 + ") EXTERNAL NAME '" + string9 + ":" + string + "." + string3 + "(" + string6 + ")' LANGUAGE JAVA NOT VARIANT END PROCEDURE" : "CREATE FUNCTION " + string4 + " (" + string5 + ") RETURNS " + string7 + " EXTERNAL NAME '" + string9 + ":" + string + "." + string3 + "(" + string6 + ")' LANGUAGE JAVA NOT VARIANT END FUNCTION";
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "sql = " + string8);
            }
            statement.executeUpdate(string8);
        }
        statement.close();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:registerUDRs() exited");
        }
    }

    static String fromClassesToJavaNames(Class[] classArray, Trace trace) {
        int n2;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:fromClassesToJavaNames() entered");
        }
        if ((n2 = classArray.length) == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != n2 - 1) {
                stringBuffer.append(classArray[i2].getName() + ", ");
                continue;
            }
            stringBuffer.append(classArray[i2].getName());
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "buf = '" + stringBuffer.toString() + "'");
            trace.writeTrace(1, "UDRManager:fromClassesToJavaNames() exited");
        }
        return stringBuffer.toString();
    }

    static String fromClassesToIfxNames(Class[] classArray, String string, String string2, Trace trace, Locale locale) throws SQLException {
        int n2;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "UDRManager:fromClassesToIfxNames() entered");
        }
        if ((n2 = classArray.length) == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = -1;
            String string3 = null;
            String string4 = classArray[i2].getName();
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "javatypename = " + string4);
            }
            if (string4.equals(string)) {
                if (string2 != null) {
                    string3 = string2;
                }
            } else {
                if (string4.equals("java.lang.Object") || string4.equals("java.sql.SQLData")) {
                    throw IfxErrMsg.getSQLException(-79860, "", locale);
                }
                string3 = UDRManager.JavaToIfxName(string4);
                if (string3.equals("unknown")) {
                    throw IfxErrMsg.getSQLException(-79714, "", locale);
                }
            }
            if (i2 != n2 - 1) {
                stringBuffer.append(string3 + ", ");
                continue;
            }
            stringBuffer.append(string3);
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(3, "buf = '" + stringBuffer.toString() + "'");
            trace.writeTrace(1, "UDRManager:fromClassesToIfxNames() exited");
        }
        return stringBuffer.toString();
    }

    private static String JavaToIfxName(String string) {
        String string2 = (String)JavaToIfxNameTable.get(string);
        if (string2 == null) {
            return "unknown";
        }
        return string2;
    }

    static {
        if (JavaToIfxNameTable == null) {
            JavaToIfxNameTable = new Hashtable(30);
            JavaToIfxNameTable.put(new String("boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("char"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("byte"), new String("char(1)"));
            JavaToIfxNameTable.put(new String("short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("int"), new String("int"));
            JavaToIfxNameTable.put(new String("long"), new String("int8"));
            JavaToIfxNameTable.put(new String("float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.lang.String"), new String("lvarchar"));
            JavaToIfxNameTable.put(new String("java.math.BigDecimal"), new String("decimal"));
            JavaToIfxNameTable.put(new String("java.lang.Boolean"), new String("boolean"));
            JavaToIfxNameTable.put(new String("java.lang.Integer"), new String("int"));
            JavaToIfxNameTable.put(new String("java.lang.Short"), new String("smallint"));
            JavaToIfxNameTable.put(new String("java.lang.Long"), new String("int8"));
            JavaToIfxNameTable.put(new String("java.lang.Float"), new String("smallfloat"));
            JavaToIfxNameTable.put(new String("java.lang.Double"), new String("float"));
            JavaToIfxNameTable.put(new String("java.sql.Date"), new String("date"));
            JavaToIfxNameTable.put(new String("java.sql.Time"), new String("datetime hour to second"));
            JavaToIfxNameTable.put(new String("java.sql.Timestamp"), new String("datetime year to fraction(5)"));
            JavaToIfxNameTable.put(new String("com.gbasedbt.lang.IntervalYM"), new String("interval year to month"));
            JavaToIfxNameTable.put(new String("com.gbasedbt.lang.IntervalDF"), new String("interval day to fraction(5)"));
            JavaToIfxNameTable.put(new String("java.sql.Blob"), new String("blob"));
            JavaToIfxNameTable.put(new String("java.sql.Clob"), new String("clob"));
        }
    }
}

