/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.util.Vector;
import sqlj.codegen.CursorJSClass;
import sqlj.codegen.JSClassType;
import sqlj.framework.JSClass;
import sqlj.framework.JSMethod;
import sqlj.mesg.CodegenErrors;

public class IteratorMetaData {
    private static final int BY_NAME = 1;
    private static final int BY_POSITION = 2;
    private static final int UNKNOWN = 0;
    private static final JSClass[] NO_PARAMS = new JSClass[0];
    private static final JSClass[] CONSTRUCTOR_PARAMS = new JSClass[]{JSClassType.RTResultSet_TYPE.toClass()};
    private int m_iterType = 0;
    private Vector m_columnNames = new Vector();
    private Vector m_columnTypes = new Vector();
    private int m_numCols = 0;

    public IteratorMetaData(JSClass jSClass, JSClass jSClass2) throws Exception {
        jSClass = this.getBaseIterator(jSClass, jSClass2);
        if (JSClass.NamedIterator_TYPE.isAssignableFrom(jSClass)) {
            this.initNamedData(jSClass);
        } else if (JSClass.PositionedIterator_TYPE.isAssignableFrom(jSClass)) {
            this.initPositionedData(jSClass);
        }
    }

    private JSClass getBaseIterator(JSClass jSClass, JSClass jSClass2) throws Exception {
        if (!jSClass2.hasAccessTo(jSClass) || jSClass.resolveConstructor(CONSTRUCTOR_PARAMS, jSClass2).length != 1) {
            String string = CodegenErrors.cannot_construct_iterator(jSClass.getName());
            throw new Exception(string);
        }
        JSClass jSClass3 = this.getLastImplementing(jSClass, JSClass.NamedIterator_TYPE);
        JSClass jSClass4 = this.getLastImplementing(jSClass, JSClass.PositionedIterator_TYPE);
        if (jSClass3 != null) {
            if (jSClass4 != null) {
                String string = CodegenErrors.ambiguous_iterator(jSClass.getName());
                throw new Exception(string);
            }
            return jSClass3;
        }
        if (jSClass4 == null) {
            String string = CodegenErrors.incomplete_iterator(jSClass.getName());
            throw new Exception(string);
        }
        return jSClass4;
    }

    private JSClass getLastImplementing(JSClass jSClass, JSClass jSClass2) {
        if (!jSClass2.isAssignableFrom(jSClass)) {
            return null;
        }
        JSClass jSClass3;
        while ((jSClass3 = jSClass.getSuperclass()) != null && jSClass2.isAssignableFrom(jSClass3)) {
            jSClass = jSClass3;
        }
        return jSClass;
    }

    public boolean isByName() {
        return this.m_iterType == 1;
    }

    public boolean isByPosition() {
        return this.m_iterType == 2;
    }

    public int getColumnCount() {
        return this.m_numCols;
    }

    public String getColumnName(int n2) {
        return (String)this.m_columnNames.elementAt(n2 - 1);
    }

    public JSClass getColumnType(int n2) {
        return (JSClass)this.m_columnTypes.elementAt(n2 - 1);
    }

    private void initNamedData(JSClass jSClass) {
        this.m_iterType = 1;
        JSMethod[] jSMethodArray = jSClass.getDeclaredMethods();
        for (int i2 = 0; i2 < jSMethodArray.length; ++i2) {
            this.addColumn(jSMethodArray[i2]);
        }
    }

    private void initPositionedData(JSClass jSClass) {
        this.m_iterType = 2;
        int n2 = 1;
        while (true) {
            try {
                String string = CursorJSClass.getColumnAccessName(n2);
                this.addColumn(jSClass.getDeclaredMethod(string, NO_PARAMS));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                break;
            }
            ++n2;
        }
    }

    private void addColumn(JSMethod jSMethod) {
        ++this.m_numCols;
        this.m_columnTypes.addElement(jSMethod.getReturnType());
        this.m_columnNames.addElement(jSMethod.getName());
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String string) {
            super(string);
        }
    }
}

