/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Vector;
import sqlj.framework.InnerClassDescriptor;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;

public class ClassFileReader
implements InnerClassDescriptor {
    private DataInputStream m_in;
    private String[] m_cpStrings = null;
    private int[] m_cpClassNames = null;
    private String m_className = null;
    private Vector m_declaredClasses = new Vector();
    private Vector m_declaredClassNames = new Vector();
    private String m_declaringClassName = null;
    private Class m_declaringClass = null;
    private boolean m_declaringDirty = false;
    private boolean m_declaredDirty = false;
    private Class m_class = null;
    private int m_modifiers = 0;
    private ClassPath m_classPath = null;
    private static final int CLASS_ATTRIBUTE = 1;
    private static final int FIELD_ATTRIBUTE = 2;
    private static final int METHOD_ATTRIBUTE = 3;

    @Override
    public Class getDescribedClass() {
        return this.m_class;
    }

    @Override
    public void setDescribedClass(Class clazz) {
        this.m_class = clazz;
        this.m_declaredDirty = true;
        this.m_declaringDirty = true;
    }

    private void describeClass(boolean bl) throws SecurityException {
        this.m_declaringClass = null;
        this.m_declaredClasses.removeAllElements();
        this.m_declaredClassNames.removeAllElements();
        this.m_declaringClassName = null;
        this.m_className = null;
        this.m_modifiers = this.m_class.getModifiers();
        if (this.m_class.isPrimitive() || this.m_class.isArray()) {
            this.m_declaringDirty = false;
            this.m_declaredDirty = false;
            return;
        }
        if (bl && this.m_class.getName().indexOf(36) == -1) {
            this.m_declaringDirty = false;
            return;
        }
        this.m_in = this.getInputStream(this.m_class);
        try {
            this.readClass();
        }
        catch (IOException iOException) {
            throw new ClassFormatError(this.m_class.getName());
        }
        finally {
            try {
                this.m_in.close();
            }
            catch (IOException iOException) {}
        }
        this.m_declaringClass = this.classForName(this.m_declaringClassName);
        int n2 = this.m_declaredClassNames.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)this.m_declaredClassNames.elementAt(i2);
            this.m_declaredClasses.addElement(this.classForName(string));
        }
        this.m_declaredDirty = false;
        this.m_declaringDirty = false;
    }

    protected DataInputStream getInputStream(Class clazz) throws SecurityException {
        String string = "/" + clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = null;
        try {
            inputStream = clazz.getResourceAsStream(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                ClassFile classFile;
                if (this.m_classPath == null) {
                    this.m_classPath = new ClassPath(System.getProperty("java.class.path"));
                }
                if ((classFile = this.m_classPath.getFile(string = clazz.getName().replace('.', File.separatorChar) + ".class")) != null) {
                    inputStream = classFile.getInputStream();
                }
            }
            catch (IOException iOException) {
                throw new SecurityException(iOException.getMessage());
            }
        }
        if (inputStream == null) {
            throw new SecurityException("unable to load bytecode for " + clazz);
        }
        return new DataInputStream(inputStream);
    }

    private Class classForName(String string) throws SecurityException {
        if (string == null) {
            return null;
        }
        try {
            return Class.forName(string.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SecurityException("can't load class " + string);
        }
    }

    @Override
    public Class getDeclaringClass() throws SecurityException {
        if (this.m_declaringDirty) {
            try {
                this.describeClass(true);
            }
            catch (SecurityException securityException) {
                this.m_declaringClass = this.m_class.getDeclaringClass();
            }
        }
        return this.m_declaringClass;
    }

    @Override
    public int getModifiers() {
        if (this.m_declaringDirty) {
            try {
                this.describeClass(true);
            }
            catch (SecurityException securityException) {
                this.m_modifiers = this.m_class.getModifiers();
            }
        }
        return this.m_modifiers;
    }

    @Override
    public Class[] getDeclaredClasses() throws SecurityException {
        if (this.m_declaredDirty) {
            try {
                this.describeClass(false);
            }
            catch (SecurityException securityException) {
                return this.m_class.getDeclaredClasses();
            }
        }
        Object[] objectArray = new Class[this.m_declaredClasses.size()];
        this.m_declaredClasses.copyInto(objectArray);
        return objectArray;
    }

    public void readClass() throws IOException {
        this.m_in.skipBytes(8);
        int n2 = this.u2();
        this.m_cpStrings = new String[n2];
        this.m_cpClassNames = new int[n2];
        int n3 = 1;
        while (n3 < n2) {
            n3 = this.cp_info(n3);
        }
        this.m_in.skipBytes(2);
        int n4 = this.u2();
        this.m_className = this.className(n4);
        this.m_in.skipBytes(2);
        n2 = this.u2();
        this.m_in.skipBytes(n2 * 2);
        n2 = this.u2();
        for (n3 = 0; n3 < n2; ++n3) {
            this.field_info();
        }
        n2 = this.u2();
        for (n3 = 0; n3 < n2; ++n3) {
            this.method_info();
        }
        n2 = this.u2();
        for (n3 = 0; n3 < n2; ++n3) {
            this.attribute_info(1);
        }
    }

    public int cp_info(int n2) throws IOException {
        int n3 = this.u1();
        switch (n3) {
            case 7: {
                this.m_cpClassNames[n2] = this.u2();
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.m_in.skipBytes(4);
                break;
            }
            case 8: {
                this.m_in.skipBytes(2);
                break;
            }
            case 5: 
            case 6: {
                this.m_in.skipBytes(8);
                ++n2;
                break;
            }
            case 1: {
                this.m_cpStrings[n2] = this.m_in.readUTF();
                break;
            }
            default: {
                throw new IllegalArgumentException("tag " + n3 + " at ndx " + n2);
            }
        }
        return n2 + 1;
    }

    public String className(int n2) {
        return this.m_cpStrings[this.m_cpClassNames[n2]];
    }

    public void field_info() throws IOException {
        this.m_in.skipBytes(6);
        int n2 = this.u2();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute_info(2);
        }
    }

    public void method_info() throws IOException {
        this.m_in.skipBytes(6);
        int n2 = this.u2();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute_info(3);
        }
    }

    public void attribute_info(int n2) throws IOException {
        int n3 = this.u2();
        int n4 = this.u4();
        if (this.m_cpStrings[n3].equals("InnerClasses") && n2 == 1) {
            int n5 = this.u2();
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = this.u2();
                int n7 = this.u2();
                int n8 = this.u2();
                int n9 = this.u2();
                if (this.className(n6).equals(this.m_className)) {
                    this.m_declaringClassName = this.className(n7);
                    this.m_modifiers |= n9;
                    continue;
                }
                if (!this.className(n7).equals(this.m_className)) continue;
                this.m_declaredClassNames.addElement(this.className(n6));
            }
        } else {
            this.m_in.skipBytes(n4);
        }
    }

    public int u4() throws IOException {
        return this.m_in.readInt();
    }

    public int u2() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    public int u1() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    public static void main(String[] stringArray) throws Exception {
        ClassFileReader classFileReader = new ClassFileReader();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Class<?> clazz = Class.forName(stringArray[i2]);
            classFileReader.setDescribedClass(clazz);
            System.out.println("----------------------");
            System.out.println("class " + clazz.getName());
            System.out.println("has mods " + Modifier.toString(clazz.getModifiers()));
            System.out.println("new mods " + Modifier.toString(classFileReader.getModifiers()));
            System.out.println("is declared in " + classFileReader.getDeclaringClass());
            Class[] classArray = classFileReader.getDeclaredClasses();
            System.out.println("and declares " + classArray.length + " classes");
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                System.out.println(classArray[i3]);
            }
        }
    }
}

