/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.framework.JSClass;
import sqlj.javac.Node;
import sqlj.javac.SimpleNode;
import sqlj.javac.Token;
import sqlj.util.ClassDescriptor;
import sqlj.util.TypeDescriptor;

public class ASTType
extends SimpleNode {
    private int dimension = 0;
    private StringBuffer bracketText = new StringBuffer();

    ASTType(int n2) {
        super(n2);
    }

    private ASTType(int n2, String string) {
        super(19);
        this.dimension = n2;
        this.bracketText.append(string);
    }

    ASTType backup() {
        return new ASTType(this.dimension, this.bracketText.toString());
    }

    void restore(ASTType aSTType) {
        this.dimension = aSTType.dimension;
        this.bracketText = aSTType.bracketText;
    }

    void addArrayDimension() {
        ++this.dimension;
        this.bracketText.append("[]");
    }

    void addArrayDimension(Token token, Token token2) {
        ++this.dimension;
        this.addBracketText(token, token2);
    }

    @Override
    public TypeDescriptor getDescriptor() {
        if (this.desc != null) {
            return this.desc;
        }
        Node node = this.getJavaScope();
        try {
            JSClass jSClass = this.getJavaScope().getClassResolver().getClass(this.getName()).getJSClass();
            for (int i2 = 0; i2 < this.dimension; ++i2) {
                jSClass = JSClass.reflectArrayOf(jSClass);
            }
            this.desc = new ClassDescriptor(jSClass.getBaseJSClass());
            return this.desc;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    String getText() {
        return this.getName() + this.bracketText.toString();
    }

    String getTypeName() {
        String string = "";
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            string = string + "[";
        }
        return string + this.getName();
    }

    private void addBracketText(Token token, Token token2) {
        token.getTextTo(this.bracketText);
        token2.getTextTo(this.bracketText);
    }
}

