/*
 * Decompiled with CFR 0.152.
 */
package sqlj.util.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.LogEntry;
import sqlj.framework.error.Position;
import sqlj.framework.error.Warning;
import sqlj.framework.ide.TranslationLog;

public class ErrorLogger
implements ErrorLog {
    private static final int POS_UNSET = 0;
    private static final int START_POS_SET = 1;
    private static final int END_POS_SET = 2;
    private int m_pos_state;
    private static LogEntry first = new LogEntry("");
    private String m_file_name = null;
    private ErrorLogger m_el = null;
    private Vector m_children = new Vector(2);
    private Vector m_error = new Vector(2);
    private int m_sline;
    private int m_scol;
    private int m_eline;
    private int m_ecol;
    private String m_file;
    private int m_error_count;
    private int m_warning_count;

    public ErrorLogger(String string) {
        this.m_file_name = string;
        this.m_sline = -1;
        this.m_scol = -1;
        this.m_eline = -1;
        this.m_ecol = -1;
        this.m_pos_state = 0;
        this.m_error_count = 0;
        this.m_warning_count = 0;
    }

    public ErrorLogger() {
        this((String)null);
    }

    private ErrorLogger(ErrorLogger errorLogger) {
        this();
        this.m_el = errorLogger;
        if (errorLogger != null) {
            this.m_file_name = errorLogger.m_file_name;
        }
    }

    @Override
    public void setFileName(String string) {
        this.m_file_name = string;
    }

    @Override
    public String getFileName() {
        return this.m_file_name;
    }

    public ErrorLogger createChild() {
        ErrorLogger errorLogger = new ErrorLogger(this);
        this.m_children.addElement(errorLogger);
        errorLogger.m_file_name = this.m_file_name;
        return errorLogger;
    }

    public ErrorLogger createChild(String string) {
        ErrorLogger errorLogger = new ErrorLogger(this);
        this.m_children.addElement(errorLogger);
        errorLogger.m_sline = 1;
        errorLogger.m_scol = 1;
        errorLogger.m_file_name = string;
        return errorLogger;
    }

    protected void removeChild(ErrorLogger errorLogger) {
        this.m_children.removeElement(errorLogger);
    }

    public void abort() {
        this.m_el.removeChild(this);
        this.m_el = null;
        this.m_children = null;
        this.m_error = null;
    }

    public void close() {
        this.abort();
    }

    public void setStartPos(int n2, int n3) {
        if (this.m_pos_state != 0 && this.m_pos_state != 1) {
            throw new IllegalArgumentException("ErrorLogger.setStartPos(): illegal to change start pos.");
        }
        this.m_sline = n2;
        this.m_scol = n3;
        this.m_pos_state = 1;
    }

    @Override
    public Position getDefaultRegion() {
        if (this.m_pos_state == 2) {
            return new Position(this.m_sline, this.m_scol, this.m_eline, this.m_ecol);
        }
        if (this.m_pos_state == 1) {
            return new Position(this.m_sline, this.m_scol);
        }
        return new Position();
    }

    public void setEndPos(int n2, int n3) {
        if (this.m_pos_state == 0) {
            throw new IllegalArgumentException("ErrorLogger.setEndPos(): must setStartPos() first.");
        }
        if (this.m_pos_state != 1) {
            throw new IllegalArgumentException("ErrorLogger.setStartPos(): illegal to change end pos.");
        }
        this.m_eline = n2;
        this.m_ecol = n3;
        this.m_pos_state = 2;
        Enumeration enumeration = this.m_error.elements();
        while (enumeration.hasMoreElements()) {
            LogEntry logEntry = (LogEntry)enumeration.nextElement();
            if (!logEntry.less(first)) continue;
            logEntry.setRegion(this.m_sline, this.m_scol, this.m_eline, this.m_ecol);
        }
    }

    public void printLog(Writer writer) {
        SortedVector sortedVector = new SortedVector();
        ErrorLogger.collectLog(this, sortedVector);
        Enumeration enumeration = sortedVector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                writer.write(((LogEntry)enumeration.nextElement()).toString());
                writer.write("\n");
            }
            catch (IOException iOException) {}
        }
    }

    public void printLog(TranslationLog translationLog) {
        SortedVector sortedVector = new SortedVector();
        ErrorLogger.collectLog(this, sortedVector);
        Enumeration enumeration = sortedVector.elements();
        while (enumeration.hasMoreElements()) {
            LogEntry logEntry = (LogEntry)enumeration.nextElement();
            Position position = logEntry.getPosition();
            if (position == null) {
                position = new Position();
            }
            if (logEntry instanceof Warning) {
                translationLog.logWarning(logEntry.getMessage(), position.startLine(), position.startCol(), position.endLine(), position.endCol());
                continue;
            }
            if (logEntry instanceof JSError) {
                translationLog.logError(logEntry.getMessage(), position.startLine(), position.startCol(), position.endLine(), position.endCol());
                continue;
            }
            translationLog.logInfo(logEntry.getMessage(), position.startLine(), position.startCol(), position.endLine(), position.endCol());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        SortedVector sortedVector = new SortedVector();
        ErrorLogger.collectLog(this, sortedVector);
        Enumeration enumeration = sortedVector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static void collectLog(ErrorLogger errorLogger, SortedVector sortedVector) {
        Enumeration enumeration = errorLogger.m_error.elements();
        while (enumeration.hasMoreElements()) {
            sortedVector.addOrderedElement((LogEntry)enumeration.nextElement());
        }
        errorLogger.m_error = new Vector(2);
        enumeration = errorLogger.m_children.elements();
        while (enumeration.hasMoreElements()) {
            ErrorLogger.collectLog((ErrorLogger)enumeration.nextElement(), sortedVector);
        }
    }

    @Override
    public void addEntry(LogEntry logEntry) {
        logEntry.setFileName(this.m_file_name);
        this.addEntryRegion(logEntry);
    }

    @Override
    public void addEntry(LogEntry logEntry, int n2, int n3) {
        logEntry.setPosition(n2, n3);
        logEntry.setFileName(this.m_file_name);
        this.m_error.addElement(logEntry);
        if (logEntry instanceof JSError) {
            this.incErrorCount();
        } else if (logEntry instanceof Warning) {
            this.incWarningCount();
        }
    }

    public void addEntryRegion(LogEntry logEntry) {
        if (this.m_pos_state == 2) {
            logEntry.setRegion(this.m_sline, this.m_scol, this.m_eline, this.m_ecol);
        }
        logEntry.setFileName(this.m_file_name);
        this.m_error.addElement(logEntry);
        if (logEntry instanceof JSError) {
            this.incErrorCount();
        } else if (logEntry instanceof Warning) {
            this.incWarningCount();
        }
    }

    @Override
    public void addEntryRegion(LogEntry logEntry, int n2, int n3, int n4, int n5) {
        logEntry.setRegion(n2, n3, n4, n5);
        logEntry.setFileName(this.m_file_name);
        this.m_error.addElement(logEntry);
        if (logEntry instanceof JSError) {
            this.incErrorCount();
        } else if (logEntry instanceof Warning) {
            this.incWarningCount();
        }
    }

    public void reportError(Object object) {
        JSError jSError = new JSError(object);
        jSError.setPosition(new Position());
        jSError.setFileName(this.m_file_name);
        this.m_error.addElement(jSError);
        this.incErrorCount();
    }

    public void reportError(int n2, int n3, Object object) {
        JSError jSError = new JSError(object);
        jSError.setPosition(n2, n3);
        jSError.setFileName(this.m_file_name);
        this.m_error.addElement(jSError);
        this.incErrorCount();
    }

    public void reportErrorRegion(Object object) {
        JSError jSError = new JSError(object);
        jSError.setPosition(new Position());
        jSError.setFileName(this.m_file_name);
        this.m_error.addElement(jSError);
        this.incErrorCount();
    }

    public void reportErrorRegion(int n2, int n3, int n4, int n5, Object object) {
        JSError jSError = new JSError(object);
        jSError.setRegion(n2, n3, n4, n5);
        jSError.setFileName(this.m_file_name);
        this.m_error.addElement(jSError);
        this.incErrorCount();
    }

    public void reportWarning(Object object) {
        Warning warning = new Warning(object);
        warning.setPosition(new Position());
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportWarning(int n2, int n3, Object object) {
        Warning warning = new Warning(object);
        warning.setPosition(n2, n3);
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportWarningRegion(Object object) {
        Warning warning = new Warning(object);
        warning.setPosition(new Position());
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportWarningRegion(int n2, int n3, int n4, int n5, Object object) {
        Warning warning = new Warning(object);
        warning.setRegion(n2, n3, n4, n5);
        warning.setFileName(this.m_file_name);
        this.m_error.addElement(warning);
        this.incWarningCount();
    }

    public void reportInfo(Object object) {
        Info info = new Info(object);
        info.setPosition(new Position());
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void reportInfo(int n2, int n3, Object object) {
        Info info = new Info(object);
        info.setPosition(n2, n3);
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void reportInfoRegion(Object object) {
        Info info = new Info(object);
        info.setPosition(new Position());
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    public void reportInfoRegion(int n2, int n3, int n4, int n5, Object object) {
        Info info = new Info(object);
        info.setRegion(n2, n3, n4, n5);
        info.setFileName(this.m_file_name);
        this.m_error.addElement(info);
    }

    @Override
    public void incErrorCount() {
        ++this.m_error_count;
    }

    @Override
    public int errorCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.m_children.size(); ++i2) {
            ErrorLogger errorLogger = (ErrorLogger)this.m_children.elementAt(i2);
            if (errorLogger == null) continue;
            n2 += errorLogger.errorCount();
        }
        return n2 + this.m_error_count;
    }

    @Override
    public void incWarningCount() {
        ++this.m_warning_count;
    }

    @Override
    public int warningCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.m_children.size(); ++i2) {
            ErrorLogger errorLogger = (ErrorLogger)this.m_children.elementAt(i2);
            if (errorLogger == null) continue;
            n2 += errorLogger.warningCount();
        }
        return n2 + this.m_warning_count;
    }

    static {
        first.setRegion(-99, -99, -99, -99);
    }

    class SortedVector
    extends Vector {
        SortedVector(int n2) {
            super(n2);
        }

        SortedVector() {
        }

        void addOrderedElement(LogEntry logEntry) {
            int n2 = this.size();
            boolean bl = false;
            for (int i2 = 0; i2 < n2 && !bl; ++i2) {
                if (!logEntry.less((LogEntry)this.elementAt(i2))) continue;
                this.insertElementAt(logEntry, i2);
                bl = true;
            }
            if (!bl) {
                this.addElement(logEntry);
            }
        }
    }
}

