/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtil {
    private DOMUtil() {
    }

    public static Node getPreviousSibling2(Node node) {
        Node ret = node.getPreviousSibling();
        if (ret == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtil.getPreviousSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node last = ret.getLastChild();
                if (last == null) {
                    ret = DOMUtil.getPreviousSibling2(ret);
                    break;
                }
                ret = last;
            }
        }
        return ret;
    }

    public static Node getNextSibling2(Node node) {
        Node ret = node.getNextSibling();
        if (ret == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtil.getNextSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node first = ret.getFirstChild();
                if (first == null) {
                    ret = DOMUtil.getNextSibling2(ret);
                    break;
                }
                ret = first;
            }
        }
        return ret;
    }

    public static Node getFirstChild2(Node node) {
        Node ret = node.getFirstChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node first = ret.getFirstChild();
            if (first == null) {
                ret = DOMUtil.getNextSibling2(ret);
                break;
            }
            ret = first;
        }
        return ret;
    }

    public static Node getLastChild2(Node node) {
        Node ret = node.getLastChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node last = ret.getLastChild();
            if (last == null) {
                ret = DOMUtil.getPreviousSibling2(ret);
                break;
            }
            ret = last;
        }
        return ret;
    }

    public static Element getFirstChildElement(Node parent) {
        Node child = DOMUtil.getFirstChild2(parent);
        while (child != null && child.getNodeType() != 1) {
            child = DOMUtil.getNextSibling2(child);
        }
        return (Element)child;
    }

    public static Element getNextElement(Node me) {
        Node next = me;
        while ((next = DOMUtil.getNextSibling2(next)) != null && next.getNodeType() != 1) {
        }
        return (Element)next;
    }

    public static final void removeAllChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    public static boolean nodesEqual(Node thisNode, Node otherNode) {
        if (thisNode == otherNode) {
            return true;
        }
        return thisNode.getNodeType() == otherNode.getNodeType();
    }

    public static boolean paramsEqual(AlgorithmParameterSpec spec1, AlgorithmParameterSpec spec2) {
        if (spec1 == spec2) {
            return true;
        }
        if (spec1 instanceof XPathFilter2ParameterSpec && spec2 instanceof XPathFilter2ParameterSpec) {
            return DOMUtil.paramsEqual((XPathFilter2ParameterSpec)spec1, (XPathFilter2ParameterSpec)spec2);
        }
        if (spec1 instanceof ExcC14NParameterSpec && spec2 instanceof ExcC14NParameterSpec) {
            return DOMUtil.paramsEqual((ExcC14NParameterSpec)spec1, (ExcC14NParameterSpec)spec2);
        }
        if (spec1 instanceof XPathFilterParameterSpec && spec2 instanceof XPathFilterParameterSpec) {
            return DOMUtil.paramsEqual((XPathFilterParameterSpec)spec1, (XPathFilterParameterSpec)spec2);
        }
        if (spec1 instanceof XSLTTransformParameterSpec && spec2 instanceof XSLTTransformParameterSpec) {
            return DOMUtil.paramsEqual((XSLTTransformParameterSpec)spec1, (XSLTTransformParameterSpec)spec2);
        }
        return false;
    }

    private static boolean paramsEqual(XPathFilter2ParameterSpec spec1, XPathFilter2ParameterSpec spec2) {
        List<XPathType> types = spec1.getXPathList();
        List<XPathType> otypes = spec2.getXPathList();
        int size = types.size();
        if (size != otypes.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            XPathType type = types.get(i);
            XPathType otype = otypes.get(i);
            if (type.getExpression().equals(otype.getExpression()) && type.getNamespaceMap().equals(otype.getNamespaceMap()) && type.getFilter() == otype.getFilter()) continue;
            return false;
        }
        return true;
    }

    private static boolean paramsEqual(ExcC14NParameterSpec spec1, ExcC14NParameterSpec spec2) {
        return spec1.getPrefixList().equals(spec2.getPrefixList());
    }

    private static boolean paramsEqual(XPathFilterParameterSpec spec1, XPathFilterParameterSpec spec2) {
        boolean XPathEquals = spec1.getXPath().equals(spec2.getXPath());
        boolean NamespaceMapEquals = spec1.getNamespaceMap().equals(spec2.getNamespaceMap());
        return XPathEquals && NamespaceMapEquals;
    }

    private static boolean paramsEqual(XSLTTransformParameterSpec spec1, XSLTTransformParameterSpec spec2) {
        XMLStructure ostylesheet = spec2.getStylesheet();
        if (!(ostylesheet instanceof DOMStructure)) {
            return false;
        }
        Node ostylesheetElem = ((DOMStructure)ostylesheet).getNode();
        XMLStructure stylesheet = spec1.getStylesheet();
        if (!(stylesheet instanceof DOMStructure)) {
            return false;
        }
        Node stylesheetElem = ((DOMStructure)stylesheet).getNode();
        return DOMUtil.nodesEqual(stylesheetElem, ostylesheetElem);
    }
}

