/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.X509DataImpl;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.math.BigInteger;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

class X509IssuerSerialImpl
extends XMLStructureImpl
implements X509IssuerSerial {
    private String name;
    private BigInteger serial;

    X509IssuerSerialImpl(AlgorithmFactory f, String n, BigInteger s) {
        super(f);
        if (n == null) {
            throw new NullPointerException("The issuer name must not be null.");
        }
        if (s == null) {
            throw new NullPointerException("The serial number must not be null.");
        }
        X509DataImpl.encodeDName(n);
        this.name = n;
        this.serial = s;
    }

    @Override
    public String getIssuerName() {
        return this.name;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serial;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof X509IssuerSerial)) {
            return false;
        }
        X509IssuerSerial ois = (X509IssuerSerial)obj;
        boolean nameEqual = this.name.equals(ois.getIssuerName());
        boolean serialEqual = this.serial.equals(ois.getSerialNumber());
        return nameEqual && serialEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.serial.hashCode();
        return result;
    }
}

