/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.CacheObject;
import com.sun.javaws.ui.CacheViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class CacheTable
extends JTable {
    private static final TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    static final int JNLP_ROW_HEIGHT = 36;
    static final int RESOURCE_ROW_HEIGHT = 26;
    static final int JNLP_TYPE = 0;
    static final int RESOURCE_TYPE = 1;
    static final int DELETED_TYPE = 2;
    private final CacheViewer viewer;
    private final int tableType;
    private final boolean isSystem;

    public CacheTable(CacheViewer cacheViewer, int n, boolean bl) {
        this.viewer = cacheViewer;
        this.tableType = n;
        this.isSystem = bl;
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        int n2 = this.tableType == 0 ? 36 : 26;
        this.setRowHeight(n2);
        this.setPreferredScrollableViewportSize(new Dimension(640, 280));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                int n2;
                if (mouseEvent.isPopupTrigger() && (n2 = (n = mouseEvent.getY()) / CacheTable.this.getRowHeight()) < CacheTable.this.getModel().getRowCount()) {
                    CacheTable.this.getSelectionModel().clearSelection();
                    CacheTable.this.getSelectionModel().addSelectionInterval(n2, n2);
                    CacheTable.this.viewer.popupApplicationMenu(CacheTable.this, mouseEvent.getX(), n);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                int n2;
                if (mouseEvent.isPopupTrigger() && (n2 = (n = mouseEvent.getY()) / CacheTable.this.getRowHeight()) < CacheTable.this.getModel().getRowCount()) {
                    CacheTable.this.getSelectionModel().clearSelection();
                    CacheTable.this.getSelectionModel().addSelectionInterval(n2, n2);
                    CacheTable.this.viewer.popupApplicationMenu(CacheTable.this, mouseEvent.getX(), n);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                if (mouseEvent.getClickCount() == 2 && CacheTable.this.getSelectedRows().length == 1 && mouseEvent.getButton() == 1) {
                    int n = CacheTable.this.getColumnModel().getColumnIndexAtX(point.x);
                    if (CacheTable.this.getSelectedRow() == CacheTable.this.rowAtPoint(point) && n < 3) {
                        if (CacheTable.this.tableType == 0) {
                            CacheTable.this.viewer.runApplication();
                        } else if (CacheTable.this.tableType == 2) {
                            CacheTable.this.viewer.importApplication();
                        } else {
                            CacheTable.this.viewer.showInformation();
                        }
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                block9: {
                    block11: {
                        int n;
                        block10: {
                            boolean bl;
                            int n2;
                            block8: {
                                n = keyEvent.getKeyCode();
                                n2 = keyEvent.getModifiers();
                                if (n != 121) break block8;
                                if ((n2 & 1) == 0) break block8;
                                int n3 = CacheTable.this.getRowHeight() * CacheTable.this.getSelectedRow() + 6;
                                int n4 = 100;
                                if (CacheTable.this.getModel() instanceof CacheTableModel) {
                                    CacheTableModel cacheTableModel = (CacheTableModel)CacheTable.this.getModel();
                                    n4 = cacheTableModel.getPreferredWidth(0);
                                }
                                int n5 = 2 * n4 / 3;
                                CacheTable.this.viewer.popupApplicationMenu(CacheTable.this, n5, n3);
                                break block9;
                            }
                            if (n != 10) break block10;
                            boolean bl2 = bl = (n2 & 2) == 0;
                            if (CacheTable.this.tableType == 0) {
                                CacheTable.this.viewer.runApplication(bl);
                            } else if (CacheTable.this.tableType == 2) {
                                CacheTable.this.viewer.importApplication();
                            } else {
                                CacheTable.this.viewer.showInformation();
                            }
                            keyEvent.consume();
                            break block9;
                        }
                        if (n == 127) break block11;
                        if (n != 8) break block9;
                    }
                    CacheTable.this.viewer.delete();
                }
            }
        });
        this.reset();
    }

    public String getSizeLabelText() {
        long l = Cache.getCacheSize((boolean)this.isSystem);
        long l2 = this.getInstalledSize(this.isSystem);
        long l3 = l - l2;
        String string = this.getSizeString(l2);
        String string2 = this.getSizeString(l3);
        if (this.isSystem) {
            return ResourceManager.getString((String)"viewer.size.system", (String)string, (String)string2);
        }
        return ResourceManager.getString((String)"viewer.size", (String)string, (String)string2);
    }

    private String getSizeString(long l) {
        String string = l > 10240L ? " " + ResourceManager.getString((String)"viewer.measure.units.kb", (String)String.valueOf(l / 1024L)) : " " + l / 1024L + "." + ResourceManager.getString((String)"viewer.measure.units.kb", (String)String.valueOf(l % 1024L / 102L));
        return string;
    }

    private long getInstalledSize(boolean bl) {
        ArrayList arrayList = CacheUtil.getInstalledResources(bl);
        Iterator iterator = arrayList.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)((File)iterator.next()));
            if (cacheEntry == null) continue;
            l += cacheEntry.getSize();
        }
        return l;
    }

    public void reset() {
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().removeListSelectionListener(this.viewer);
        TableModel tableModel = this.getModel();
        if (tableModel instanceof CacheTableModel) {
            ((CacheTableModel)tableModel).removeMouseListenerFromHeaderInTable(this);
        }
        CacheTableModel cacheTableModel = new CacheTableModel(this.tableType, this.isSystem);
        this.setModel(cacheTableModel);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setHeaderRenderer(new CacheTableHeaderRenderer());
            int n = cacheTableModel.getPreferredWidth(i);
            tableColumn.setPreferredWidth(n);
            tableColumn.setMinWidth(n);
        }
        this.setDefaultRenderer(JLabel.class, cacheTableModel);
        cacheTableModel.addMouseListenerToHeaderInTable(this);
        this.getSelectionModel().addListSelectionListener(this.viewer);
        this.getSelectionModel().clearSelection();
    }

    public CacheObject getCacheObject(int n) {
        return ((CacheTableModel)this.getModel()).getCacheObject(n);
    }

    public String[] getAllHrefs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TableModel tableModel = this.getModel();
        if (tableModel instanceof CacheTableModel) {
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                String string = ((CacheTableModel)tableModel).getRowHref(i);
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private class CacheTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private CacheTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (jTable != null) {
                jTable.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.title") + " " + ResourceManager.getMessage((String)"viewer.table"));
                jTable.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.table.Description"));
                object2 = jTable.getTableHeader();
                if (object2 != null) {
                    this.setForeground(((Component)object2).getForeground());
                    this.setBackground(((Component)object2).getBackground());
                    this.setFont(((Component)object2).getFont());
                    ((JTableHeader)object2).getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.title") + " " + ResourceManager.getMessage((String)"viewer.table"));
                    ((JTableHeader)object2).getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.table.Description"));
                }
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            object2 = CacheObject.getHeaderToolTipText(n2, CacheTable.this.tableType);
            if (object2 != null && ((String)object2).length() > 0) {
                this.setToolTipText((String)object2);
            }
            return this;
        }
    }

    private class CacheTableModel
    extends AbstractTableModel
    implements TableCellRenderer {
        private boolean isSystem;
        private int tableType;
        private CacheObject[] rows;
        private int sortColumn;
        private boolean sortAscending;
        private MouseListener mouseListener = null;

        public CacheTableModel(int n, boolean bl) {
            this.tableType = n;
            this.isSystem = bl;
            this.rows = new CacheObject[0];
            this.sortColumn = -1;
            this.sortAscending = true;
            this.refresh();
            this.fireTableDataChanged();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Component) {
                Component component = (Component)object;
                if (bl) {
                    component.setForeground(jTable.getSelectionForeground());
                    component.setBackground(jTable.getSelectionBackground());
                } else {
                    component.setForeground(jTable.getForeground());
                    component.setBackground(jTable.getBackground());
                }
                CacheObject.hasFocus(component, bl2);
                return component;
            }
            return defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private boolean isEntryIPEqual(CacheObject cacheObject, CacheObject cacheObject2) {
            String string = cacheObject.getCodebaseIP();
            String string2 = cacheObject2.getCodebaseIP();
            return string == null && string2 == null || string != null && string.equals(string2) || string2 != null && string2.equals(string);
        }

        private boolean validateEntry(ArrayList arrayList, CacheObject cacheObject) {
            for (int i = 0; i < arrayList.size(); ++i) {
                CacheObject cacheObject2 = (CacheObject)arrayList.get(i);
                if (!cacheObject2.getUrlString().equals(cacheObject.getUrlString()) || this.isEntryIPEqual(cacheObject2, cacheObject)) continue;
                return false;
            }
            return true;
        }

        public void refresh() {
            Cache.removeDuplicateEntries((boolean)false);
            ArrayList<CacheObject> arrayList = new ArrayList<CacheObject>();
            if (this.tableType == 0) {
                for (File file : Cache.getJnlpCacheEntries((boolean)this.isSystem)) {
                    CacheObject cacheObject;
                    LaunchDesc launchDesc;
                    File file2 = new File(file.getPath() + ".idx");
                    CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)file2);
                    if (cacheEntry == null || !cacheEntry.isValidEntry() || (launchDesc = (cacheObject = new CacheObject(cacheEntry, this, this.tableType)).getLaunchDesc()) == null || !launchDesc.isApplicationDescriptor() || !this.validateEntry(arrayList, cacheObject)) continue;
                    arrayList.add(cacheObject);
                }
            } else if (this.tableType == 1) {
                File[] fileArray = Cache.getCacheEntries((boolean)this.isSystem);
                for (int i = 0; i < fileArray.length; ++i) {
                    CacheObject cacheObject;
                    CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)fileArray[i]);
                    if (cacheEntry == null || !cacheEntry.isValidEntry() || !this.validateEntry(arrayList, cacheObject = new CacheObject(cacheEntry, this, this.tableType))) continue;
                    arrayList.add(cacheObject);
                }
            } else if (this.tableType == 2) {
                Properties properties = Cache.getRemovedApps();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    arrayList.add(new CacheObject(string2, string, this));
                }
            }
            this.rows = arrayList.toArray(new CacheObject[0]);
            if (this.sortColumn != -1) {
                this.sort();
            }
        }

        CacheObject getCacheObject(int n) {
            return this.rows[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.rows[n].getObject(n2);
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public String getRowHref(int n) {
            return this.rows[n].getHref();
        }

        public int getColumnCount() {
            return CacheObject.getColumnCount(this.tableType);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.rows[n].isEditable(n2);
        }

        public Class getColumnClass(int n) {
            return CacheObject.getClass(n, this.tableType);
        }

        public String getColumnName(int n) {
            return CacheObject.getColumnName(n, this.tableType);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.rows[n].setValue(n2, object);
        }

        public int getPreferredWidth(int n) {
            return CacheObject.getPreferredWidth(n, this.tableType);
        }

        public void removeMouseListenerFromHeaderInTable(JTable jTable) {
            if (this.mouseListener != null) {
                jTable.getTableHeader().removeMouseListener(this.mouseListener);
            }
        }

        public void addMouseListenerToHeaderInTable(JTable jTable) {
            final JTable jTable2 = jTable;
            jTable2.setColumnSelectionAllowed(false);
            final ListSelectionModel listSelectionModel = jTable2.getSelectionModel();
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    TableColumnModel tableColumnModel = jTable2.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = listSelectionModel.getMinSelectionIndex();
                    listSelectionModel.clearSelection();
                    int n3 = jTable2.convertColumnIndexToModel(n);
                    if (mouseEvent.getClickCount() == 1 && n3 >= 0) {
                        int n4 = mouseEvent.getModifiers() & 1;
                        CacheTableModel.this.sortAscending = n4 == 0;
                        CacheTableModel.this.sortColumn = n3;
                        CacheTableModel.this.runSort(listSelectionModel, n2);
                    }
                }
            };
            jTable2.getTableHeader().addMouseListener(this.mouseListener);
        }

        public void sort() {
            boolean bl = false;
            if (this.sortAscending) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    for (int j = i + 1; j < this.getRowCount(); ++j) {
                        if (this.rows[i].compareColumns(this.rows[j], this.sortColumn) <= 0) continue;
                        bl = true;
                        CacheObject cacheObject = this.rows[i];
                        this.rows[i] = this.rows[j];
                        this.rows[j] = cacheObject;
                    }
                }
            } else {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    for (int j = i + 1; j < this.getRowCount(); ++j) {
                        if (this.rows[j].compareColumns(this.rows[i], this.sortColumn) <= 0) continue;
                        bl = true;
                        CacheObject cacheObject = this.rows[i];
                        this.rows[i] = this.rows[j];
                        this.rows[j] = cacheObject;
                    }
                }
            }
            if (bl) {
                this.fireTableDataChanged();
            }
        }

        private void runSort(final ListSelectionModel listSelectionModel, final int n) {
            new Thread(new Runnable(){

                public void run() {
                    CacheObject cacheObject = null;
                    if (n >= 0) {
                        cacheObject = CacheTableModel.this.rows[n];
                    }
                    CacheTableModel.this.sort();
                    if (cacheObject != null) {
                        for (int i = 0; i < CacheTableModel.this.rows.length; ++i) {
                            if (CacheTableModel.this.rows[i] != cacheObject) continue;
                            listSelectionModel.clearSelection();
                            listSelectionModel.addSelectionInterval(i, i);
                            break;
                        }
                    }
                }
            }).start();
        }
    }
}

