/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.net.InetAddress;
import java.util.Arrays;

public class ChannelBinding {
    private InetAddress initiatorAddress = null;
    private InetAddress acceptorAddress = null;
    private byte[] appData = null;

    public ChannelBinding(InetAddress inetAddress, InetAddress inetAddress2, byte[] byArray) {
        this.initiatorAddress = inetAddress;
        this.acceptorAddress = inetAddress2;
        if (byArray != null) {
            this.appData = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.appData, 0, byArray.length);
        }
    }

    public ChannelBinding(byte[] byArray) {
        if (byArray != null) {
            this.appData = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.appData, 0, byArray.length);
        }
    }

    public InetAddress getInitiatorAddress() {
        return this.initiatorAddress;
    }

    public InetAddress getAcceptorAddress() {
        return this.acceptorAddress;
    }

    public byte[] getApplicationData() {
        return this.appData;
    }

    public boolean equals(Object object) {
        try {
            boolean bl;
            boolean bl2;
            if (object == null || !(object instanceof ChannelBinding)) {
                return false;
            }
            ChannelBinding channelBinding = (ChannelBinding)object;
            byte[] byArray = channelBinding.getApplicationData();
            if (!Arrays.equals(this.appData, byArray)) {
                return false;
            }
            InetAddress inetAddress = channelBinding.getInitiatorAddress();
            boolean bl3 = bl2 = this.initiatorAddress == null && inetAddress == null || this.initiatorAddress != null && this.initiatorAddress.equals(inetAddress);
            if (!bl2) {
                return false;
            }
            InetAddress inetAddress2 = channelBinding.getAcceptorAddress();
            boolean bl4 = bl = this.acceptorAddress == null && inetAddress2 == null || this.acceptorAddress != null && this.acceptorAddress.equals(inetAddress2);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        if (this.initiatorAddress != null) {
            return this.initiatorAddress.hashCode();
        }
        if (this.acceptorAddress != null) {
            return this.acceptorAddress.hashCode();
        }
        if (this.appData != null) {
            return new String(this.appData).hashCode();
        }
        return 1;
    }
}

