/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.ibm.security.jgss.i18n.PropertyResource;

public class GSSException
extends Exception {
    private static final long serialVersionUID = -2706218945227726672L;
    public static final int BAD_BINDINGS = 1;
    public static final int BAD_MECH = 2;
    public static final int BAD_NAME = 3;
    public static final int BAD_NAMETYPE = 4;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int CONTEXT_EXPIRED = 7;
    public static final int CREDENTIALS_EXPIRED = 8;
    public static final int DEFECTIVE_CREDENTIAL = 9;
    public static final int DEFECTIVE_TOKEN = 10;
    public static final int FAILURE = 11;
    public static final int NO_CONTEXT = 12;
    public static final int NO_CRED = 13;
    public static final int BAD_QOP = 14;
    public static final int UNAUTHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    public static final int DUPLICATE_TOKEN = 19;
    public static final int OLD_TOKEN = 20;
    public static final int UNSEQ_TOKEN = 21;
    public static final int GAP_TOKEN = 22;
    private static final int LAST_MAJOR_CODE = 22;
    private int major = 11;
    private int minor;
    private String minorMessage;
    private String majorString;
    private static final String[] statusMessageKeys = new String[]{"GSSMechanismSpecificError", "GSSChannelBindingMismatch", "GSSUnsupportedMechanism", "GSSInvalidName", "GSSBadNameType", "GSSBadStatusCode", "GSSBadIntegrityCheck", "GSSContextExpired", "GSSCredentialExpired", "GSSDefectiveCredential", "GSSDefectiveToken", "GSSGeneralFailure", "GSSBadContext", "GSSBadCredential", "GSSUnsupportedQOP", "GSSOperationUnauthorized", "GSSOperationUnavailable", "GSSDuplicateCredentialElement", "GSSMultiMechanismName", "GSSDuplicateToken", "GSSExpiredToken", "GSSOutOfSequenceToken", "GSSMissingToken", "GSSInvalidMajorStatusCode"};

    public GSSException(int n) {
        if (n > 0 && n <= 22) {
            this.major = n;
        }
        this.setMajorString();
    }

    public GSSException(int n, int n2, String string) {
        if (n > 0 && n <= 22) {
            this.major = n;
        }
        this.minor = n2;
        this.minorMessage = string;
        this.setMajorString();
    }

    private void setMajorString() {
        PropertyResource propertyResource = PropertyResource.getExceptionInstance();
        this.majorString = propertyResource.getString(statusMessageKeys[this.major]);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getMajorString() {
        return this.majorString;
    }

    public String getMinorString() {
        return this.minorMessage;
    }

    public void setMinor(int n, String string) {
        this.minor = n;
        this.minorMessage = string;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        PropertyResource propertyResource = PropertyResource.getGeneralInstance();
        if (this.minorMessage != null) {
            return propertyResource.getFormattedString("GSSException", new Object[]{"org.ietf.jgss.GSSException", new Integer(this.major), new Integer(this.minor), this.majorString, this.minorMessage});
        }
        return propertyResource.getFormattedString("GSSExceptionNullMinor", new Object[]{"org.ietf.jgss.GSSException", new Integer(this.major), new Integer(this.minor), this.majorString});
    }
}

