/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryUsageUtil;
import java.lang.management.MemoryNotificationInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MemoryNotificationInfoUtil {
    private static CompositeType compositeType;

    private static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                String[] names = new String[]{"poolName", "usage", "count"};
                String[] descs = new String[]{"poolName", "usage", "count"};
                OpenType[] types = new OpenType[]{SimpleType.STRING, MemoryUsageUtil.getCompositeType(), SimpleType.LONG};
                try {
                    compositeType = new CompositeType(MemoryNotificationInfo.class.getName(), MemoryNotificationInfo.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(MemoryNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (info != null) {
                CompositeType type = MemoryNotificationInfoUtil.getCompositeType();
                String[] names = new String[]{"poolName", "usage", "count"};
                Object[] values = new Object[]{info.getPoolName(), MemoryUsageUtil.toCompositeData(info.getUsage()), info.getCount()};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    private MemoryNotificationInfoUtil() {
    }
}

