/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit;

import com.ibm.oti.vm.J9UnmodifiableClass;
import com.ibm.oti.vm.VM;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

@J9UnmodifiableClass
public final class JITHelpers {
    private static final JITHelpers helpers;
    private static final Unsafe unsafe;
    private static final int CLASS_IS_INTERFACE_OR_PRIMITIVE;
    private static final long JLCLASS_J9CLASS_OFFSET;
    private static final int POINTER_SIZE;
    private static final boolean IS_32_BIT;
    public static final boolean IS_BIG_ENDIAN;
    private static final int DESCRIPTION_WORD_SIZE;
    private static final int DESCRIPTION_WORD_BIT_SIZE;
    private static final int SLOT_SIZE;

    private JITHelpers() {
    }

    @CallerSensitive
    public static JITHelpers getHelpers() {
        if (Reflection.getCallerClass().getClassLoader() != null) {
            throw new SecurityException("JITHelpers");
        }
        return helpers;
    }

    private static JITHelpers jitHelpers() {
        return helpers;
    }

    public native int transformedEncodeUTF16Big(long var1, long var3, int var5);

    public native int transformedEncodeUTF16Little(long var1, long var3, int var5);

    private static native int javaLangClassJ9ClassOffset();

    private static int classIsInterfaceFlag() {
        return 512;
    }

    public Class<?> getSuperclass(Class<?> clazz) {
        if (IS_32_BIT) {
            int j9Class = unsafe.getInt(clazz, JLCLASS_J9CLASS_OFFSET);
            int romClass = unsafe.getInt(j9Class + VM.J9CLASS_ROMCLASS_OFFSET);
            int modifiers = unsafe.getInt(romClass + VM.J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (modifiers & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                int superclasses = unsafe.getInt(j9Class + VM.J9CLASS_SUPERCLASSES_OFFSET);
                int depthAndFlags = unsafe.getInt(j9Class + VM.J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                int depth = depthAndFlags & VM.J9_JAVA_CLASS_DEPTH_MASK;
                if (depth > 0) {
                    int superclass = unsafe.getInt(superclasses + POINTER_SIZE * (depth - 1));
                    return this.getClassFromJ9Class32(superclass);
                }
            }
        } else {
            long j9Class = unsafe.getLong(clazz, JLCLASS_J9CLASS_OFFSET);
            long romClass = unsafe.getLong(j9Class + (long)VM.J9CLASS_ROMCLASS_OFFSET);
            int modifiers = unsafe.getInt(romClass + (long)VM.J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (modifiers & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                long superclasses = unsafe.getLong(j9Class + (long)VM.J9CLASS_SUPERCLASSES_OFFSET);
                long depthAndFlags = unsafe.getLong(j9Class + (long)VM.J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                long depth = depthAndFlags & (long)VM.J9_JAVA_CLASS_DEPTH_MASK;
                if (depth > 0L) {
                    long superclass = unsafe.getLong(superclasses + (long)POINTER_SIZE * (depth - 1L));
                    return this.getClassFromJ9Class64(superclass);
                }
            }
        }
        return null;
    }

    public boolean isArray(Object obj) {
        if (this.is32Bit()) {
            int j9Class = this.getJ9ClassFromObject32(obj);
            int flags = this.getClassDepthAndFlagsFromJ9Class32(j9Class);
            return (flags & VM.J9_ACC_CLASS_ARRAY) != 0;
        }
        long j9Class = this.getJ9ClassFromObject64(obj);
        int flags = (int)this.getClassDepthAndFlagsFromJ9Class64(j9Class);
        return (flags & VM.J9_ACC_CLASS_ARRAY) != 0;
    }

    public long getJ9ClassFromObject64(Object obj) {
        Class<? extends Object> clazz = obj.getClass();
        return this.getJ9ClassFromClass64(clazz);
    }

    public int getJ9ClassFromObject32(Object obj) {
        Class<? extends Object> clazz = obj.getClass();
        return this.getJ9ClassFromClass32(clazz);
    }

    public boolean supportsIntrinsicCaseConversion() {
        return false;
    }

    public boolean toUpperIntrinsicLatin1(byte[] value, byte[] output, int length) {
        return false;
    }

    public boolean toLowerIntrinsicLatin1(byte[] value, byte[] output, int length) {
        return false;
    }

    public boolean toUpperIntrinsicUTF16(byte[] value, byte[] output, int length) {
        return false;
    }

    public boolean toLowerIntrinsicUTF16(byte[] value, byte[] output, int length) {
        return false;
    }

    public boolean toUpperIntrinsicLatin1(char[] value, char[] output, int length) {
        return false;
    }

    public boolean toLowerIntrinsicLatin1(char[] value, char[] output, int length) {
        return false;
    }

    public boolean toUpperIntrinsicUTF16(char[] value, char[] output, int length) {
        return false;
    }

    public boolean toLowerIntrinsicUTF16(char[] value, char[] output, int length) {
        return false;
    }

    public int getIntFromObject(Object obj, long offset) {
        return unsafe.getInt(obj, offset);
    }

    public int getIntFromObjectVolatile(Object obj, long offset) {
        return unsafe.getIntVolatile(obj, offset);
    }

    public long getLongFromObject(Object obj, long offset) {
        return unsafe.getLong(obj, offset);
    }

    public long getLongFromObjectVolatile(Object obj, long offset) {
        return unsafe.getLongVolatile(obj, offset);
    }

    public Object getObjectFromObject(Object obj, long offset) {
        return unsafe.getObject(obj, offset);
    }

    public Object getObjectFromObjectVolatile(Object obj, long offset) {
        return unsafe.getObjectVolatile(obj, offset);
    }

    public void putIntInObject(Object obj, long offset, int value) {
        unsafe.putInt(obj, offset, value);
    }

    public void putIntInObjectVolatile(Object obj, long offset, int value) {
        unsafe.putIntVolatile(obj, offset, value);
    }

    public void putLongInObject(Object obj, long offset, long value) {
        unsafe.putLong(obj, offset, value);
    }

    public void putLongInObjectVolatile(Object obj, long offset, long value) {
        unsafe.putLongVolatile(obj, offset, value);
    }

    public void putObjectInObject(Object obj, long offset, Object value) {
        unsafe.putObject(obj, offset, value);
    }

    public void putObjectInObjectVolatile(Object obj, long offset, Object value) {
        unsafe.putObjectVolatile(obj, offset, value);
    }

    public boolean compareAndSwapIntInObject(Object obj, long offset, int expected, int value) {
        return unsafe.compareAndSwapInt(obj, offset, expected, value);
    }

    public boolean compareAndSwapLongInObject(Object obj, long offset, long expected, long value) {
        return unsafe.compareAndSwapLong(obj, offset, expected, value);
    }

    public boolean compareAndSwapObjectInObject(Object obj, long offset, Object expected, Object value) {
        return unsafe.compareAndSwapObject(obj, offset, expected, value);
    }

    public byte getByteFromArray(Object obj, long offset) {
        return unsafe.getByte(obj, offset);
    }

    public byte getByteFromArrayVolatile(Object obj, long offset) {
        return unsafe.getByteVolatile(obj, offset);
    }

    public char getCharFromArray(Object obj, long offset) {
        return unsafe.getChar(obj, offset);
    }

    public char getCharFromArrayVolatile(Object obj, long offset) {
        return unsafe.getCharVolatile(obj, offset);
    }

    public int getIntFromArray(Object obj, long offset) {
        return unsafe.getInt(obj, offset);
    }

    public int getIntFromArrayVolatile(Object obj, long offset) {
        return unsafe.getIntVolatile(obj, offset);
    }

    public long getLongFromArray(Object obj, long offset) {
        return unsafe.getLong(obj, offset);
    }

    public long getLongFromArrayVolatile(Object obj, long offset) {
        return unsafe.getLongVolatile(obj, offset);
    }

    public Object getObjectFromArray(Object obj, long offset) {
        return unsafe.getObject(obj, offset);
    }

    public Object getObjectFromArrayVolatile(Object obj, long offset) {
        return unsafe.getObjectVolatile(obj, offset);
    }

    public void putByteInArray(Object obj, long offset, byte value) {
        unsafe.putByte(obj, offset, value);
    }

    public void putByteInArrayVolatile(Object obj, long offset, byte value) {
        unsafe.putByteVolatile(obj, offset, value);
    }

    public void putCharInArray(Object obj, long offset, char value) {
        unsafe.putChar(obj, offset, value);
    }

    public void putCharInArrayVolatile(Object obj, long offset, char value) {
        unsafe.putCharVolatile(obj, offset, value);
    }

    public void putIntInArray(Object obj, long offset, int value) {
        unsafe.putInt(obj, offset, value);
    }

    public void putIntInArrayVolatile(Object obj, long offset, int value) {
        unsafe.putIntVolatile(obj, offset, value);
    }

    public void putLongInArray(Object obj, long offset, long value) {
        unsafe.putLong(obj, offset, value);
    }

    public void putLongInArrayVolatile(Object obj, long offset, long value) {
        unsafe.putLongVolatile(obj, offset, value);
    }

    public void putObjectInArray(Object obj, long offset, Object value) {
        unsafe.putObject(obj, offset, value);
    }

    public void putObjectInArrayVolatile(Object obj, long offset, Object value) {
        unsafe.putObjectVolatile(obj, offset, value);
    }

    public boolean compareAndSwapIntInArray(Object obj, long offset, int expected, int value) {
        return unsafe.compareAndSwapInt(obj, offset, expected, value);
    }

    public boolean compareAndSwapLongInArray(Object obj, long offset, long expected, long value) {
        return unsafe.compareAndSwapLong(obj, offset, expected, value);
    }

    public boolean compareAndSwapObjectInArray(Object obj, long offset, Object expected, Object value) {
        return unsafe.compareAndSwapObject(obj, offset, expected, value);
    }

    public char byteToCharUnsigned(byte b) {
        return (char)((char)b & 0xFF);
    }

    public native boolean acmplt(Object var1, Object var2);

    private static long storeBits(long dest, int width, long value, int vwidth, int offset) {
        int offsetToModify = IS_BIG_ENDIAN ? width - 1 - offset * vwidth % width : offset * vwidth % width;
        long vmask = -1 >>> (8 - vwidth) * 8;
        long dmask = vmask << 8 * offsetToModify ^ 0xFFFFFFFFFFFFFFFFL;
        return dest & dmask | (value & vmask) << 8 * offsetToModify;
    }

    private static long readBits(long src, int width, int vwidth, int offset) {
        int offsetToRead = IS_BIG_ENDIAN ? width - 1 - offset * vwidth % width : offset * vwidth % width;
        long vmask = -1 >>> (8 - vwidth) * 8;
        long smask = vmask << 8 * offsetToRead;
        return (src & smask) >>> 8 * offsetToRead;
    }

    public void putByteInArrayByIndex(Object obj, int index, byte value) {
        Class<? extends Object> clazz = obj.getClass();
        if (clazz == byte[].class) {
            ((byte[])obj)[index] = value;
        } else if (clazz == char[].class) {
            char[] array = (char[])obj;
            int cidx = index >> 1;
            char c = array[cidx];
            array[cidx] = (char)JITHelpers.storeBits(c, 2, value, 1, index);
        } else if (clazz == int[].class) {
            int[] array = (int[])obj;
            int iidx = index >> 2;
            int i = array[iidx];
            array[iidx] = (int)JITHelpers.storeBits(i, 4, value, 1, index);
        } else if (clazz == long[].class) {
            long[] array = (long[])obj;
            int lidx = index >> 3;
            long l = array[lidx];
            array[lidx] = JITHelpers.storeBits(l, 8, value, 1, index);
        }
    }

    public byte getByteFromArrayByIndex(Object obj, int index) {
        Class<? extends Object> clazz = obj.getClass();
        if (clazz == byte[].class) {
            return ((byte[])obj)[index];
        }
        if (clazz == char[].class) {
            return (byte)JITHelpers.readBits(((char[])obj)[index >> 1], 2, 1, index);
        }
        if (clazz == int[].class) {
            return (byte)JITHelpers.readBits(((int[])obj)[index >> 2], 4, 1, index);
        }
        if (clazz == long[].class) {
            return (byte)JITHelpers.readBits(((long[])obj)[index >> 3], 8, 1, index);
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    public void putCharInArrayByIndex(Object obj, int index, char value) {
        Class<? extends Object> clazz = obj.getClass();
        if (clazz == byte[].class) {
            index <<= 1;
            byte[] array = (byte[])obj;
            if (!IS_BIG_ENDIAN) {
                array[index] = (byte)value;
                array[index + 1] = (byte)(value >>> 8);
            } else {
                array[index] = (byte)(value >>> 8);
                array[index + 1] = (byte)value;
            }
        } else if (clazz == char[].class) {
            ((char[])obj)[index] = value;
        } else if (clazz == int[].class) {
            int[] array = (int[])obj;
            int iidx = index >> 1;
            int i = array[iidx];
            array[iidx] = (int)JITHelpers.storeBits(i, 4, value, 2, index);
        } else if (clazz == long[].class) {
            long[] array = (long[])obj;
            int lidx = index >> 2;
            long l = array[lidx];
            array[lidx] = JITHelpers.storeBits(l, 8, value, 2, index);
        }
    }

    public char getCharFromArrayByIndex(Object obj, int index) {
        Class<? extends Object> clazz = obj.getClass();
        if (clazz == byte[].class) {
            index <<= 1;
            byte[] array = (byte[])obj;
            if (!IS_BIG_ENDIAN) {
                return (char)(this.byteToCharUnsigned(array[index + 1]) << 8 | this.byteToCharUnsigned(array[index]));
            }
            return (char)(this.byteToCharUnsigned(array[index + 1]) | this.byteToCharUnsigned(array[index]) << 8);
        }
        if (clazz == char[].class) {
            return ((char[])obj)[index];
        }
        if (clazz == int[].class) {
            return (char)JITHelpers.readBits(((int[])obj)[index >> 1], 4, 2, index);
        }
        if (clazz == long[].class) {
            return (char)JITHelpers.readBits(((long[])obj)[index >> 2], 8, 2, index);
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    public int intrinsicIndexOfStringLatin1(Object s1Value, int s1len, Object s2Value, int s2len, int start) {
        char firstChar = this.byteToCharUnsigned(this.getByteFromArrayByIndex(s2Value, 0));
        int i;
        while ((i = this.intrinsicIndexOfLatin1(s1Value, (byte)firstChar, start, s1len)) != -1 && s2len + i <= s1len) {
            int o1 = i;
            int o2 = 0;
            while (++o2 < s2len && this.getByteFromArrayByIndex(s1Value, ++o1) == this.getByteFromArrayByIndex(s2Value, o2)) {
            }
            if (o2 == s2len) {
                return i;
            }
            start = i + 1;
        }
        return -1;
    }

    public int intrinsicIndexOfStringUTF16(Object s1Value, int s1len, Object s2Value, int s2len, int start) {
        char firstChar = this.getCharFromArrayByIndex(s2Value, 0);
        int i;
        while ((i = this.intrinsicIndexOfUTF16(s1Value, firstChar, start, s1len)) != -1 && s2len + i <= s1len) {
            int o1 = i;
            int o2 = 0;
            while (++o2 < s2len && this.getCharFromArrayByIndex(s1Value, ++o1) == this.getCharFromArrayByIndex(s2Value, o2)) {
            }
            if (o2 == s2len) {
                return i;
            }
            start = i + 1;
        }
        return -1;
    }

    public int intrinsicIndexOfLatin1(Object array, byte ch, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            if (this.getByteFromArrayByIndex(array, i) != ch) continue;
            return i;
        }
        return -1;
    }

    public int intrinsicIndexOfUTF16(Object array, char ch, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            if (this.getCharFromArrayByIndex(array, i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static boolean isDescriptorPointerTagged(int descriptorPtr) {
        return (descriptorPtr & 1) == 1;
    }

    private static boolean isDescriptorPointerTagged(long descriptorPtr) {
        return (descriptorPtr & 1L) == 1L;
    }

    public final void unsafeObjectShallowCopy32(Object srcObj, Object destObj, int j9clazz) {
        int instanceSize = unsafe.getInt(j9clazz + VM.J9CLASS_INSTANCESIZE_OFFSET);
        int descriptorPtr = unsafe.getInt(j9clazz + VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
        int numSlotsInObject = instanceSize / SLOT_SIZE;
        int descriptorWord = descriptorPtr;
        int bitIndex = DESCRIPTION_WORD_BIT_SIZE - 1;
        if ((descriptorWord & 1) == 1) {
            descriptorWord >>= 1;
        } else {
            descriptorWord = unsafe.getInt(descriptorPtr);
            descriptorPtr += DESCRIPTION_WORD_SIZE;
        }
        for (int slot = 0; slot < numSlotsInObject; ++slot) {
            if ((descriptorWord & 1) == 1) {
                Object fieldValue = this.getObjectFromObject(srcObj, VM.OBJECT_HEADER_SIZE + slot * SLOT_SIZE);
                this.putObjectInObject(destObj, VM.OBJECT_HEADER_SIZE + slot * SLOT_SIZE, fieldValue);
            } else {
                int fieldValue = this.getIntFromObject(srcObj, VM.OBJECT_HEADER_SIZE + slot * SLOT_SIZE);
                this.putIntInObject(destObj, VM.OBJECT_HEADER_SIZE + slot * SLOT_SIZE, fieldValue);
            }
            descriptorWord >>= 1;
            if (bitIndex-- != 0) continue;
            descriptorWord = unsafe.getInt(descriptorPtr);
            descriptorPtr += DESCRIPTION_WORD_SIZE;
            bitIndex = DESCRIPTION_WORD_BIT_SIZE - 1;
        }
        int lockOffset = unsafe.getInt(j9clazz + VM.J9CLASS_LOCK_OFFSET_OFFSET);
        if (lockOffset != 0) {
            int lwValue = this.getInitialLockword32(j9clazz);
            this.putIntInObject(destObj, lockOffset, lwValue);
        }
        unsafe.storeFence();
    }

    public final void unsafeObjectShallowCopy64(Object srcObj, Object destObj, long j9clazz) {
        long instanceSize = unsafe.getLong(j9clazz + (long)VM.J9CLASS_INSTANCESIZE_OFFSET);
        long descriptorPtr = unsafe.getLong(j9clazz + (long)VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
        int header = VM.OBJECT_HEADER_SIZE;
        int numSlotsInObject = (int)(instanceSize / (long)SLOT_SIZE);
        long descriptorWord = descriptorPtr;
        int bitIndex = DESCRIPTION_WORD_BIT_SIZE - 1;
        if ((descriptorWord & 1L) == 1L) {
            descriptorWord >>= 1;
        } else {
            descriptorWord = unsafe.getLong(descriptorPtr);
            descriptorPtr += (long)DESCRIPTION_WORD_SIZE;
        }
        for (int slot = 0; slot < numSlotsInObject; ++slot) {
            if ((descriptorWord & 1L) == 1L) {
                Object fieldValue = this.getObjectFromObject(srcObj, header + slot * SLOT_SIZE);
                this.putObjectInObject(destObj, header + slot * SLOT_SIZE, fieldValue);
            } else if (SLOT_SIZE == 4) {
                int fieldValue = this.getIntFromObject(srcObj, header + slot * SLOT_SIZE);
                this.putIntInObject(destObj, header + slot * SLOT_SIZE, fieldValue);
            } else {
                long fieldValue = this.getLongFromObject(srcObj, header + slot * SLOT_SIZE);
                this.putLongInObject(destObj, header + slot * SLOT_SIZE, fieldValue);
            }
            descriptorWord >>= 1;
            if (bitIndex-- != 0) continue;
            descriptorWord = unsafe.getLong(descriptorPtr);
            descriptorPtr += (long)DESCRIPTION_WORD_SIZE;
            bitIndex = DESCRIPTION_WORD_BIT_SIZE - 1;
        }
        long lockOffset = unsafe.getLong(j9clazz + (long)VM.J9CLASS_LOCK_OFFSET_OFFSET);
        if (lockOffset != 0L) {
            int lwValue = this.getInitialLockword64(j9clazz);
            if (SLOT_SIZE == 4) {
                this.putIntInObject(destObj, lockOffset, lwValue);
            } else {
                this.putLongInObject(destObj, lockOffset, lwValue);
            }
        }
        unsafe.storeFence();
    }

    public Object optimizedClone(Object srcObj) throws CloneNotSupportedException {
        Class<? extends Object> clnClass = srcObj.getClass();
        if (clnClass.isArray()) {
            Class<?> eleClass = clnClass.getComponentType();
            int len = Array.getLength(srcObj);
            Object clnObj = Array.newInstance(eleClass, len);
            System.arraycopy(srcObj, 0, clnObj, 0, len);
            return clnObj;
        }
        if (!(srcObj instanceof Cloneable)) {
            throw new CloneNotSupportedException();
        }
        Object clnObj = null;
        try {
            clnObj = unsafe.allocateInstance(clnClass);
        }
        catch (InstantiationException len) {
            // empty catch block
        }
        int bitIndex = 0;
        if (IS_32_BIT) {
            long lockOffset;
            int j9clazz = unsafe.getInt(clnClass, JLCLASS_J9CLASS_OFFSET);
            int instanceSize = unsafe.getInt(j9clazz + VM.J9CLASS_INSTANCESIZE_OFFSET);
            int descriptorPtr = unsafe.getInt(j9clazz + VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
            int numSlotsInObject = instanceSize / SLOT_SIZE;
            int descriptorWord = 0;
            if (JITHelpers.isDescriptorPointerTagged(descriptorPtr)) {
                ++bitIndex;
                descriptorWord = descriptorPtr >>> 1;
            } else {
                descriptorWord = unsafe.getInt(descriptorPtr);
            }
            int countSlots = 0;
            int index = 0;
            while (numSlotsInObject != 0) {
                if (JITHelpers.isDescriptorPointerTagged(descriptorWord)) {
                    Object fieldValue = unsafe.getObject(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putObject(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                } else {
                    int fieldValue = unsafe.getInt(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putInt(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                }
                if (++countSlots >= numSlotsInObject) break;
                if (bitIndex == DESCRIPTION_WORD_BIT_SIZE - 1) {
                    bitIndex = 0;
                    descriptorWord = unsafe.getInt(descriptorPtr += DESCRIPTION_WORD_SIZE);
                } else {
                    descriptorWord >>>= 1;
                    ++bitIndex;
                }
                ++index;
            }
            if ((lockOffset = (long)unsafe.getInt(j9clazz + VM.J9CLASS_LOCK_OFFSET_OFFSET)) != 0L) {
                int lwValue = this.getInitialLockword32(j9clazz);
                unsafe.putInt(clnObj, lockOffset, lwValue);
            }
        } else {
            long lockOffset;
            long j9clazz = unsafe.getLong(clnClass, JLCLASS_J9CLASS_OFFSET);
            long instanceSize = unsafe.getLong(j9clazz + (long)VM.J9CLASS_INSTANCESIZE_OFFSET);
            long descriptorPtr = unsafe.getLong(j9clazz + (long)VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
            int numSlotsInObject = (int)(instanceSize / (long)SLOT_SIZE);
            long descriptorWord = 0L;
            if (JITHelpers.isDescriptorPointerTagged(descriptorPtr)) {
                ++bitIndex;
                descriptorWord = descriptorPtr >>> 1;
            } else {
                descriptorWord = unsafe.getLong(descriptorPtr);
            }
            int countSlots = 0;
            int index = 0;
            while (numSlotsInObject != 0) {
                if (JITHelpers.isDescriptorPointerTagged(descriptorWord)) {
                    Object fieldValue = unsafe.getObject(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putObject(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                } else {
                    long fieldValue = unsafe.getLong(srcObj, VM.OBJECT_HEADER_SIZE + countSlots * SLOT_SIZE);
                    unsafe.putLong(clnObj, VM.OBJECT_HEADER_SIZE + index * SLOT_SIZE, fieldValue);
                }
                if (++countSlots >= numSlotsInObject) break;
                if (bitIndex == DESCRIPTION_WORD_BIT_SIZE - 1) {
                    bitIndex = 0;
                    descriptorWord = unsafe.getLong(descriptorPtr += (long)DESCRIPTION_WORD_SIZE);
                } else {
                    descriptorWord >>>= 1;
                    ++bitIndex;
                }
                ++index;
            }
            if ((lockOffset = unsafe.getLong(j9clazz + (long)VM.J9CLASS_LOCK_OFFSET_OFFSET)) != 0L) {
                int lwValue = this.getInitialLockword64(j9clazz);
                if (SLOT_SIZE == 4) {
                    unsafe.putInt(clnObj, lockOffset, lwValue);
                } else {
                    unsafe.putLong(clnObj, lockOffset, lwValue);
                }
            }
        }
        unsafe.storeFence();
        return clnObj;
    }

    public final int getClassInitializeStatus(Class<?> defc) {
        long defcClass = 0L;
        defcClass = this.is32Bit() ? (long)this.getJ9ClassFromClass32(defc) : this.getJ9ClassFromClass64(defc);
        int initStatus = 0;
        initStatus = 4 == VM.ADDRESS_SIZE ? unsafe.getInt(defcClass + (long)VM.J9CLASS_INITIALIZE_STATUS_OFFSET) : (int)unsafe.getLong(defcClass + (long)VM.J9CLASS_INITIALIZE_STATUS_OFFSET);
        return initStatus;
    }

    public int getInitialLockword32(int j9clazz) {
        int flags = this.getClassFlagsFromJ9Class32(j9clazz);
        int reservedCounter = unsafe.getShort(j9clazz + VM.J9CLASS_LOCK_RESERVATION_HISTORY_RESERVED_COUNTER_OFFSET) & 0xFFFF;
        int cancelCounter = unsafe.getShort(j9clazz + VM.J9CLASS_LOCK_RESERVATION_HISTORY_CANCEL_COUNTER_OFFSET) & 0xFFFF;
        return this.getInitialLockword(flags, reservedCounter, cancelCounter);
    }

    public int getInitialLockword64(long j9clazz) {
        int flags = this.getClassFlagsFromJ9Class64(j9clazz);
        int reservedCounter = unsafe.getShort(j9clazz + (long)VM.J9CLASS_LOCK_RESERVATION_HISTORY_RESERVED_COUNTER_OFFSET) & 0xFFFF;
        int cancelCounter = unsafe.getShort(j9clazz + (long)VM.J9CLASS_LOCK_RESERVATION_HISTORY_CANCEL_COUNTER_OFFSET) & 0xFFFF;
        return this.getInitialLockword(flags, reservedCounter, cancelCounter);
    }

    public int getInitialLockword(int flags, int reservedCounter, int cancelCounter) {
        int lwValue = 0;
        if (1 == VM.GLR_ENABLE_GLOBAL_LOCK_RESERVATION) {
            int reservedAbsoluteThreshold = VM.GLR_RESERVED_ABSOLUTE_THRESHOLD;
            int minimumReservedRatio = VM.GLR_MINIMUM_RESERVED_RATIO;
            int cancelAbsoluteThreshold = VM.GLR_CANCEL_ABSOLUTE_THRESHOLD;
            int minimumLearningRatio = VM.GLR_MINIMUM_LEARNING_RATIO;
            if (reservedCounter >= reservedAbsoluteThreshold && (long)reservedCounter > (long)cancelCounter * (long)minimumReservedRatio) {
                lwValue = VM.OBJECT_HEADER_LOCK_RESERVED;
            } else if (cancelCounter < cancelAbsoluteThreshold || (long)reservedCounter > (long)cancelCounter * (long)minimumLearningRatio) {
                lwValue = VM.OBJECT_HEADER_LOCK_LEARNING;
            }
        } else if ((flags & VM.J9CLASS_RESERVABLE_LOCK_WORD_INIT) != 0) {
            lwValue = VM.OBJECT_HEADER_LOCK_RESERVED;
        }
        return lwValue;
    }

    private static final native boolean isBigEndian();

    public final native void GPUHelper();

    public native boolean is32Bit();

    public native int getNumBitsInReferenceField();

    public native int getNumBytesInReferenceField();

    public native int getNumBitsInDescriptionWord();

    public native int getNumBytesInDescriptionWord();

    public native int getNumBytesInJ9ObjectHeader();

    public native int getJ9ClassFromClass32(Class var1);

    public native Class getClassFromJ9Class32(int var1);

    public native int getTotalInstanceSizeFromJ9Class32(int var1);

    public native int getInstanceDescriptionFromJ9Class32(int var1);

    public native int getDescriptionWordFromPtr32(int var1);

    public native long getJ9ClassFromClass64(Class var1);

    public native Class getClassFromJ9Class64(long var1);

    public native long getTotalInstanceSizeFromJ9Class64(long var1);

    public native long getInstanceDescriptionFromJ9Class64(long var1);

    public native long getDescriptionWordFromPtr64(long var1);

    public native int getNumSlotsInObject(Class var1);

    public native int getSlotIndex(Field var1);

    public native boolean isDescriptorPointerTagged(int var1, long var2);

    public native int getRomClassFromJ9Class32(int var1);

    public native int getSuperClassesFromJ9Class32(int var1);

    public native int getClassDepthAndFlagsFromJ9Class32(int var1);

    public native int getBackfillOffsetFromJ9Class32(int var1);

    public native int getArrayShapeFromRomClass32(int var1);

    public native int getModifiersFromRomClass32(int var1);

    public native long getRomClassFromJ9Class64(long var1);

    public native long getSuperClassesFromJ9Class64(long var1);

    public native long getClassDepthAndFlagsFromJ9Class64(long var1);

    public native long getBackfillOffsetFromJ9Class64(long var1);

    public native int getArrayShapeFromRomClass64(long var1);

    public native int getModifiersFromRomClass64(long var1);

    public native int getClassFlagsFromJ9Class32(int var1);

    public native int getClassFlagsFromJ9Class64(long var1);

    public static native void dispatchComputedStaticCall();

    public static native void dispatchVirtual();

    static {
        CLASS_IS_INTERFACE_OR_PRIMITIVE = JITHelpers.classIsInterfaceFlag() | VM.J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE;
        JLCLASS_J9CLASS_OFFSET = JITHelpers.javaLangClassJ9ClassOffset();
        POINTER_SIZE = VM.ADDRESS_SIZE;
        IS_32_BIT = POINTER_SIZE == 4;
        IS_BIG_ENDIAN = JITHelpers.isBigEndian();
        helpers = new JITHelpers();
        unsafe = Unsafe.getUnsafe();
        DESCRIPTION_WORD_SIZE = VM.ADDRESS_SIZE;
        DESCRIPTION_WORD_BIT_SIZE = DESCRIPTION_WORD_SIZE * 8;
        SLOT_SIZE = VM.FJ9OBJECT_SIZE;
    }
}

