/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ThreadMXBeanImpl;
import com.ibm.lang.management.ExtendedThreadInfo;
import com.ibm.lang.management.ThreadMXBean;
import com.ibm.lang.management.internal.ExtendedThreadInfoImpl;
import com.ibm.oti.util.Msg;
import java.lang.management.ThreadInfo;

public final class ExtendedThreadMXBeanImpl
extends ThreadMXBeanImpl
implements ThreadMXBean {
    private static final ThreadMXBean instance = new ExtendedThreadMXBeanImpl();

    public static ThreadMXBean getInstance() {
        return instance;
    }

    private ExtendedThreadMXBeanImpl() {
    }

    @Override
    public ExtendedThreadInfo[] dumpAllExtendedThreads(boolean lockedMonitors, boolean lockedSynchronizers) throws InternalError, SecurityException, UnsupportedOperationException {
        ThreadInfo[] threadInfos = this.dumpAllThreads(lockedMonitors, lockedSynchronizers);
        int infoCount = threadInfos.length;
        ExtendedThreadInfo[] resultArray = new ExtendedThreadInfo[infoCount];
        for (int index = 0; index < infoCount; ++index) {
            resultArray[index] = new ExtendedThreadInfoImpl(threadInfos[index]);
        }
        return resultArray;
    }

    @Override
    public long getThreadAllocatedBytes(long threadId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] threadIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getThreadCpuTime(long[] threadIds) {
        int i;
        long[] result = new long[threadIds.length];
        for (i = 0; i < threadIds.length; ++i) {
            if (threadIds[i] <= 0L) {
                throw new IllegalArgumentException(Msg.getString("K05F7"));
            }
            result[i] = -1L;
        }
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                for (i = 0; i < threadIds.length; ++i) {
                    result[i] = this.getThreadCpuTime(threadIds[i]);
                }
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public long[] getThreadUserTime(long[] threadIds) {
        int i;
        long[] result = new long[threadIds.length];
        for (i = 0; i < threadIds.length; ++i) {
            if (threadIds[i] <= 0L) {
                throw new IllegalArgumentException(Msg.getString("K05F7"));
            }
            result[i] = -1L;
        }
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                for (i = 0; i < threadIds.length; ++i) {
                    result[i] = this.getThreadUserTime(threadIds[i]);
                }
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return false;
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setThreadAllocatedMemoryEnabled(boolean value) {
        throw new UnsupportedOperationException();
    }
}

