/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermissionCollection;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public class SharedClassPermission
extends BasicPermission {
    private static final long serialVersionUID = -3867544018716468265L;
    private transient boolean read;
    private transient boolean write;

    public SharedClassPermission(ClassLoader loader, String actions) {
        this(loader.getClass().getName(), actions);
    }

    public SharedClassPermission(String classLoaderClassName, String actions) {
        super(classLoaderClassName);
        this.decodeActions(actions);
    }

    private void decodeActions(String actions) {
        StringTokenizer tokenizer = new StringTokenizer(actions.toLowerCase(), " \t\n\r,");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("read")) {
                this.read = true;
                continue;
            }
            if (token.equals("write")) {
                this.write = true;
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (!this.read && !this.write) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            SharedClassPermission pp = (SharedClassPermission)o;
            return this.read == pp.read && this.write == pp.write;
        }
        return false;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SharedClassPermissionCollection();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getActions() {
        return this.read ? (this.write ? "read,write" : "read") : "write";
    }

    @Override
    public boolean implies(Permission permission) {
        if (super.implies(permission)) {
            SharedClassPermission pp = (SharedClassPermission)permission;
            boolean result = this.read && this.write || this.write && !pp.read || this.read && !pp.write;
            return result;
        }
        return false;
    }
}

