/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.Comparator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleCache;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.WrongMethodTypeException;
import java.util.concurrent.ConcurrentHashMap;

abstract class ConvertHandle
extends MethodHandle {
    final MethodHandle next;
    boolean requiresBoxing = false;

    ConvertHandle(MethodHandle handle, MethodType type, byte kind, Object thunkArg) {
        super(type, kind, thunkArg);
        if (handle == null || type == null) {
            throw new IllegalArgumentException();
        }
        this.next = handle;
    }

    ConvertHandle(ConvertHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.requiresBoxing = originalHandle.requiresBoxing;
    }

    final void checkConversion(MethodType toType, MethodType fromType) {
        Class<?>[] fromArgs;
        Class<?>[] toArgs = toType.ptypes();
        if (toArgs.length != (fromArgs = fromType.ptypes()).length) {
            ConvertHandle.throwWrongMethodTypeException(fromType, toType, toArgs.length);
        }
        boolean isExplicitCast = this.kind == 16;
        for (int i = 0; i < toArgs.length; ++i) {
            Class<?> fromClass = fromArgs[i];
            Class<?> toClass = toArgs[i];
            if (fromClass == toClass) continue;
            boolean toIsPrimitive = toClass.isPrimitive();
            boolean fromIsPrimitive = fromClass.isPrimitive();
            if (!toIsPrimitive && !fromIsPrimitive) continue;
            if (toIsPrimitive && fromIsPrimitive) {
                if (isExplicitCast || FilterHelpers.checkIfWideningPrimitiveConversion(fromClass, toClass)) continue;
                ConvertHandle.throwWrongMethodTypeException(fromType, toType, i);
            }
            if (toIsPrimitive) {
                Class<?> unwrappedFromClass;
                if (isExplicitCast || toClass == (unwrappedFromClass = MethodTypeHelper.unwrapPrimitive(fromClass)) || fromClass.isAssignableFrom(MethodTypeHelper.wrapPrimitive(toClass)) || FilterHelpers.checkIfWideningPrimitiveConversion(unwrappedFromClass, toClass)) continue;
                ConvertHandle.throwWrongMethodTypeException(fromType, toType, i);
            }
            if (toClass.isAssignableFrom(MethodTypeHelper.wrapPrimitive(fromClass))) {
                this.requiresBoxing = true;
                continue;
            }
            ConvertHandle.throwWrongMethodTypeException(fromType, toType, i);
        }
    }

    static final void throwWrongMethodTypeException(MethodType fromType, MethodType toType, int index) throws WrongMethodTypeException {
        throw new WrongMethodTypeException(Msg.getString("K05cb", fromType.toString(), toType.toString(), Integer.toString(index)));
    }

    final void compareWithConvert(ConvertHandle left, Comparator c) {
        c.compareChildHandle(left.next, this.next);
    }

    static {
        FilterHelpers.load();
    }

    static final class FilterHelpers {
        static MethodHandles.Lookup privilegedLookup = MethodHandles.Lookup.internalPrivilegedLookup;
        static final ConcurrentHashMap<MethodType, MethodHandle> cachedReturnFilters = new ConcurrentHashMap();

        FilterHelpers() {
        }

        static MethodHandle getReturnFilter(Class<?> fromReturn, Class<?> toReturn, boolean isExplicitCast) {
            assert (fromReturn != toReturn);
            try {
                if (fromReturn == Void.TYPE) {
                    Comparable<Boolean> constantValue = null;
                    if (toReturn.isPrimitive()) {
                        constantValue = toReturn == Boolean.TYPE ? Boolean.valueOf(false) : (toReturn == Character.TYPE ? (Comparable<Character>)Character.valueOf('\u0000') : (Comparable<Character>)Byte.valueOf((byte)0));
                    }
                    return MethodHandles.constant(toReturn, constantValue);
                }
                MethodType filterType = MethodType.methodType(toReturn, fromReturn);
                if (fromReturn.isPrimitive()) {
                    if (toReturn.isPrimitive()) {
                        return FilterHelpers.getPrimitiveReturnFilter(filterType, isExplicitCast);
                    }
                    return FilterHelpers.getBoxingReturnFilter(filterType);
                }
                if (!toReturn.isPrimitive()) {
                    return FilterHelpers.getCastFilter(filterType, isExplicitCast);
                }
                if (toReturn == Void.TYPE) {
                    MethodHandle filter = privilegedLookup.findStatic(FilterHelpers.class, "popObject", MethodType.methodType(Void.TYPE, Object.class));
                    return filter.cloneWithNewType(filterType);
                }
                return FilterHelpers.getUnboxingReturnFilter(filterType, isExplicitCast);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        }

        static boolean checkIfWideningPrimitiveConversion(Class<?> from, Class<?> to) {
            if (!from.isPrimitive() || !to.isPrimitive()) {
                return false;
            }
            if (from == Boolean.TYPE || to == Boolean.TYPE || from == Double.TYPE || to == Character.TYPE) {
                return false;
            }
            return FilterHelpers.primitiveIndex1(to) > FilterHelpers.primitiveIndex1(from);
        }

        private static int primitiveIndex1(Class<?> c) {
            char ch = c.getName().charAt(0);
            int shift = (ch ^ ch >> 3) & 7;
            return 4534630 >> 3 * shift & 7;
        }

        static MethodHandle getPrimitiveReturnFilter(MethodType type, boolean isExplicitCast) throws IllegalAccessException, NoSuchMethodException {
            Class<?> fromClass = type.parameterType(0);
            Class<?> toClass = type.returnType();
            if (!isExplicitCast && type.returnType() != Void.TYPE && !FilterHelpers.checkIfWideningPrimitiveConversion(fromClass, toClass)) {
                throw new WrongMethodTypeException();
            }
            MethodHandle filter = cachedReturnFilters.get(type);
            if (filter == null) {
                String to = MethodTypeHelper.getBytecodeStringName(toClass);
                String from = MethodTypeHelper.getBytecodeStringName(type.parameterType(0));
                filter = privilegedLookup.findStatic(FilterHelpers.class, from + "2" + to, type);
                MethodHandle previous = cachedReturnFilters.putIfAbsent(type, filter);
                if (previous != null) {
                    filter = previous;
                }
            }
            return filter;
        }

        static MethodHandle getBoxingReturnFilter(MethodType type) throws IllegalAccessException, NoSuchMethodException {
            MethodHandle previous;
            Class<?> wrapper = MethodTypeHelper.wrapPrimitive(type.parameterType(0));
            if (!type.returnType().isAssignableFrom(wrapper)) {
                throw new WrongMethodTypeException();
            }
            MethodHandle filter = cachedReturnFilters.get(type);
            if (filter == null && (previous = cachedReturnFilters.putIfAbsent(type, filter = privilegedLookup.findStatic(wrapper, "valueOf", MethodType.methodType(wrapper, type.parameterType(0))))) != null) {
                filter = previous;
            }
            if (type.returnType() != wrapper) {
                filter = filter.cloneWithNewType(type);
            }
            return filter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static MethodHandle getUnboxingReturnFilter(MethodType type, boolean isExplicitCast) throws IllegalAccessException, NoSuchMethodException {
            Class<?> unwrapped;
            boolean justUnwrap;
            Class<?> toUnbox = type.parameterType(0);
            Class<?> returnType = type.returnType();
            if (toUnbox.equals(Object.class)) {
                String methodName = isExplicitCast ? "explicitObject2" : "object2";
                methodName = methodName + MethodTypeHelper.getBytecodeStringName(returnType);
                return privilegedLookup.findStatic(FilterHelpers.class, methodName, MethodType.methodType(returnType, Object.class));
            }
            if (toUnbox.equals(Number.class)) {
                if (!isExplicitCast) {
                    if (returnType == Boolean.TYPE && returnType == Character.TYPE) throw new WrongMethodTypeException();
                    return privilegedLookup.findStatic(FilterHelpers.class, "number2" + MethodTypeHelper.getBytecodeStringName(returnType), MethodType.methodType(returnType, Number.class));
                }
                if (returnType == Boolean.TYPE || returnType == Character.TYPE) {
                    String methodName = "explicitNumber2" + MethodTypeHelper.getBytecodeStringName(returnType);
                    return privilegedLookup.findStatic(FilterHelpers.class, methodName, MethodType.methodType(returnType, Number.class));
                }
                String methodName = MethodTypeHelper.getBytecodeStringName(returnType) + "Value";
                return privilegedLookup.findVirtual(Number.class, methodName, MethodType.methodType(returnType));
            }
            if (toUnbox.equals(Boolean.class)) {
                MethodHandle filter = privilegedLookup.findVirtual(Boolean.class, "booleanValue", MethodType.methodType(Boolean.TYPE));
                if (returnType.equals(Boolean.TYPE)) {
                    return filter;
                }
                if (!isExplicitCast) throw new WrongMethodTypeException();
                return MethodHandles.filterReturnValue(filter, FilterHelpers.getPrimitiveReturnFilter(MethodType.methodType(returnType, Boolean.TYPE), isExplicitCast));
            }
            if (toUnbox.equals(Character.class)) {
                MethodHandle filter = privilegedLookup.findVirtual(Character.class, "charValue", MethodType.methodType(Character.TYPE));
                if (!returnType.equals(Character.TYPE)) return MethodHandles.filterReturnValue(filter, FilterHelpers.getPrimitiveReturnFilter(MethodType.methodType(returnType, Character.TYPE), isExplicitCast));
                return filter;
            }
            if (!MethodTypeHelper.WRAPPER_SET.contains(toUnbox) || !(justUnwrap = returnType.equals(unwrapped = MethodTypeHelper.unwrapPrimitive(toUnbox))) && !isExplicitCast && !FilterHelpers.checkIfWideningPrimitiveConversion(unwrapped, returnType)) throw new WrongMethodTypeException();
            if (!isExplicitCast || justUnwrap || returnType != Character.TYPE && returnType != Boolean.TYPE) return privilegedLookup.findVirtual(toUnbox, returnType.getName() + "Value", MethodType.methodType(returnType));
            MethodHandle unbox = privilegedLookup.findVirtual(toUnbox, unwrapped.getName() + "Value", MethodType.methodType(unwrapped));
            MethodHandle filter = FilterHelpers.getPrimitiveReturnFilter(MethodType.methodType(returnType, unwrapped), isExplicitCast);
            return MethodHandles.filterReturnValue(unbox, filter);
        }

        static MethodHandle getCastFilter(MethodType type, boolean isExplicitCast) throws IllegalAccessException, NoSuchMethodException {
            Class<?> returnClass = type.returnType();
            if (isExplicitCast && returnClass.isInterface()) {
                MethodType filterType = MethodType.methodType(Object.class, Object.class);
                return privilegedLookup.findStatic(FilterHelpers.class, "explicitCastInterfaceUnchecked", filterType);
            }
            MethodHandleCache methodHandleCache = MethodHandleCache.getCache(returnClass);
            return methodHandleCache.getClassCastHandle();
        }

        public static Object explicitCastInterfaceUnchecked(Object o) {
            return o;
        }

        public static boolean explicitObject2Z(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Character) {
                return ((byte)((Character)o).charValue() & 1) == 1;
            }
            return (((Number)o).byteValue() & 1) == 1;
        }

        public static byte explicitObject2B(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof Boolean) {
                return (byte)((Boolean)o != false ? 1 : 0);
            }
            if (o instanceof Character) {
                return (byte)((Character)o).charValue();
            }
            return ((Number)o).byteValue();
        }

        public static short explicitObject2S(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof Boolean) {
                return (short)((Boolean)o != false ? 1 : 0);
            }
            if (o instanceof Character) {
                return (short)((Character)o).charValue();
            }
            return ((Number)o).shortValue();
        }

        public static char explicitObject2C(Object o) {
            if (o == null) {
                return '\u0000';
            }
            if (o instanceof Boolean) {
                return (char)((Boolean)o != false ? 1 : 0);
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return (char)((Number)o).intValue();
        }

        public static int explicitObject2I(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1 : 0;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return ((Number)o).intValue();
        }

        public static long explicitObject2J(Object o) {
            if (o == null) {
                return 0L;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1L : 0L;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return ((Number)o).longValue();
        }

        public static float explicitObject2F(Object o) {
            if (o == null) {
                return 0.0f;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1.0f : 0.0f;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return ((Number)o).floatValue();
        }

        public static double explicitObject2D(Object o) {
            if (o == null) {
                return 0.0;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1.0 : 0.0;
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return ((Number)o).doubleValue();
        }

        public static boolean explicitNumber2Z(Number n) {
            if (n == null) {
                return false;
            }
            return (n.byteValue() & 1) == 1;
        }

        public static char explicitNumber2C(Number n) {
            if (n == null) {
                return '\u0000';
            }
            return (char)n.intValue();
        }

        private static final ClassCastException newClassCastException() {
            return new ClassCastException();
        }

        public static boolean object2Z(Object o) {
            return (Boolean)o;
        }

        public static char object2C(Object o) {
            return ((Character)o).charValue();
        }

        public static byte object2B(Object o) {
            return FilterHelpers.number2B((Number)o);
        }

        public static short object2S(Object o) {
            return FilterHelpers.number2S((Number)o);
        }

        public static int object2I(Object o) {
            o.getClass();
            if (o instanceof Number) {
                return FilterHelpers.number2I((Number)o);
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static float object2F(Object o) {
            o.getClass();
            if (o instanceof Number) {
                return FilterHelpers.number2F((Number)o);
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static double object2D(Object o) {
            o.getClass();
            if (o instanceof Number) {
                return FilterHelpers.number2D((Number)o);
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static long object2J(Object o) {
            o.getClass();
            if (o instanceof Number) {
                return FilterHelpers.number2J((Number)o);
            }
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            throw FilterHelpers.newClassCastException();
        }

        public static byte number2B(Number n) {
            return (Byte)n;
        }

        public static short number2S(Number n) {
            if (n instanceof Short || n instanceof Byte) {
                return n.shortValue();
            }
            n.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static int number2I(Number n) {
            if (n instanceof Integer || n instanceof Byte || n instanceof Short) {
                return n.intValue();
            }
            n.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static long number2J(Number n) {
            if (n instanceof Long || n instanceof Integer || n instanceof Byte || n instanceof Short) {
                return n.longValue();
            }
            n.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static float number2F(Number n) {
            if (n instanceof Float || n instanceof Integer || n instanceof Long || n instanceof Byte || n instanceof Short) {
                return n.floatValue();
            }
            n.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static double number2D(Number n) {
            if (n instanceof Double || n instanceof Float || n instanceof Integer || n instanceof Long || n instanceof Byte || n instanceof Short) {
                return n.doubleValue();
            }
            n.getClass();
            throw FilterHelpers.newClassCastException();
        }

        public static void popObject(Object o) {
        }

        public static double V2D() {
            return 0.0;
        }

        public static long V2J() {
            return 0L;
        }

        public static float V2F() {
            return 0.0f;
        }

        public static int V2I() {
            return 0;
        }

        public static char V2C() {
            return '\u0000';
        }

        public static short V2S() {
            return 0;
        }

        public static byte V2B() {
            return 0;
        }

        public static boolean V2Z() {
            return false;
        }

        public static Object V2object() {
            return null;
        }

        public static double Z2D(boolean j) {
            return j ? 1.0 : 0.0;
        }

        public static long Z2J(boolean j) {
            return j ? 1L : 0L;
        }

        public static float Z2F(boolean j) {
            return j ? 1.0f : 0.0f;
        }

        public static int Z2I(boolean j) {
            return j ? 1 : 0;
        }

        public static char Z2C(boolean j) {
            return (char)(j ? 1 : 0);
        }

        public static short Z2S(boolean j) {
            return (short)(j ? 1 : 0);
        }

        public static byte Z2B(boolean j) {
            return (byte)(j ? 1 : 0);
        }

        public static void Z2V(boolean j) {
        }

        public static Object Z2object(boolean j) {
            return j;
        }

        public static double B2D(byte j) {
            return j;
        }

        public static long B2J(byte j) {
            return j;
        }

        public static float B2F(byte j) {
            return j;
        }

        public static int B2I(byte j) {
            return j;
        }

        public static char B2C(byte j) {
            return (char)j;
        }

        public static short B2S(byte j) {
            return j;
        }

        public static boolean B2Z(byte j) {
            return (byte)(j & 1) == 1;
        }

        public static void B2V(byte j) {
        }

        public static Object B2object(byte j) {
            return j;
        }

        public static double S2D(short j) {
            return j;
        }

        public static long S2J(short j) {
            return j;
        }

        public static float S2F(short j) {
            return j;
        }

        public static int S2I(short j) {
            return j;
        }

        public static char S2C(short j) {
            return (char)j;
        }

        public static byte S2B(short j) {
            return (byte)j;
        }

        public static boolean S2Z(short j) {
            return ((byte)j & 1) == 1;
        }

        public static void S2V(short j) {
        }

        public static Object S2object(short j) {
            return j;
        }

        public static double C2D(char j) {
            return j;
        }

        public static long C2J(char j) {
            return j;
        }

        public static float C2F(char j) {
            return j;
        }

        public static int C2I(char j) {
            return j;
        }

        public static short C2S(char j) {
            return (short)j;
        }

        public static byte C2B(char j) {
            return (byte)j;
        }

        public static boolean C2Z(char j) {
            return ((byte)j & 1) == 1;
        }

        public static void C2V(char j) {
        }

        public static Object C2object(char j) {
            return Character.valueOf(j);
        }

        public static boolean I2Z(int i) {
            return ((byte)i & 1) == 1;
        }

        public static byte I2B(int i) {
            return (byte)i;
        }

        public static short I2S(int i) {
            return (short)i;
        }

        public static char I2C(int i) {
            return (char)i;
        }

        public static float I2F(int i) {
            return i;
        }

        public static long I2J(int i) {
            return i;
        }

        public static double I2D(int i) {
            return i;
        }

        public static void I2V(int j) {
        }

        public static Object I2object(int j) {
            return j;
        }

        public static float J2F(long j) {
            return j;
        }

        public static double J2D(long j) {
            return j;
        }

        public static int J2I(long j) {
            return (int)j;
        }

        public static char J2C(long j) {
            return (char)j;
        }

        public static short J2S(long j) {
            return (short)j;
        }

        public static byte J2B(long j) {
            return (byte)j;
        }

        public static boolean J2Z(long j) {
            return ((byte)j & 1) == 1;
        }

        public static void J2V(long j) {
        }

        public static Object J2object(long j) {
            return j;
        }

        public static long F2J(float j) {
            return (long)j;
        }

        public static double F2D(float j) {
            return j;
        }

        public static int F2I(float j) {
            return (int)j;
        }

        public static char F2C(float j) {
            return (char)j;
        }

        public static short F2S(float j) {
            return (short)j;
        }

        public static byte F2B(float j) {
            return (byte)j;
        }

        public static boolean F2Z(float j) {
            return ((byte)j & 1) == 1;
        }

        public static void F2V(float j) {
        }

        public static Object F2object(float j) {
            return Float.valueOf(j);
        }

        public static float D2F(double j) {
            return (float)j;
        }

        public static long D2J(double j) {
            return (long)j;
        }

        public static int D2I(double j) {
            return (int)j;
        }

        public static char D2C(double j) {
            return (char)j;
        }

        public static short D2S(double j) {
            return (short)j;
        }

        public static byte D2B(double j) {
            return (byte)j;
        }

        public static boolean D2Z(double j) {
            return ((byte)j & 1) == 1;
        }

        public static void D2V(double j) {
        }

        public static Object D2object(double j) {
            return j;
        }

        static void load() {
        }
    }
}

