/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.lang.ArgumentHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.ReflectPermissions;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.invoke.CacheKey;
import java.lang.invoke.CatchHandle;
import java.lang.invoke.ConstantHandle;
import java.lang.invoke.ConstructorHandle;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DefaultMethodConflictException;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ExplicitCastHandle;
import java.lang.invoke.FieldGetterHandle;
import java.lang.invoke.FieldSetterHandle;
import java.lang.invoke.FilterArgumentsHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.FoldHandle;
import java.lang.invoke.GuardWithTestHandle;
import java.lang.invoke.HandleCache;
import java.lang.invoke.Insert1Handle;
import java.lang.invoke.Insert1IntHandle;
import java.lang.invoke.Insert2Handle;
import java.lang.invoke.Insert3Handle;
import java.lang.invoke.InsertHandle;
import java.lang.invoke.InterfaceHandle;
import java.lang.invoke.InvokeGenericHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleInfoImpl;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.SecurityFrameInjector;
import java.lang.invoke.StaticFieldGetterHandle;
import java.lang.invoke.StaticFieldSetterHandle;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    static final int[] EMPTY_ARG_POSITIONS = new int[0];

    @CallerSensitive
    static final native Class<?> getStackClass(int var0);

    MethodHandles() {
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        return MethodHandles.filterArguments(target, pos, filter);
    }

    @CallerSensitive
    public static Lookup lookup() {
        Class<?> c = MethodHandles.getStackClass(1);
        return new Lookup(c);
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static <T extends Member> T reflectAs(Class<T> expected, MethodHandle target) throws SecurityException, NullPointerException, IllegalArgumentException, ClassCastException {
        if (null == expected || null == target) {
            throw new NullPointerException();
        }
        SecurityManager secmgr = System.getSecurityManager();
        if (null != secmgr) {
            secmgr.checkPermission(ReflectPermissions.permissionSuppressAccessChecks);
        }
        MethodHandleInfo mhi = Lookup.IMPL_LOOKUP.revealDirect(target);
        T result = mhi.reflectAs(expected, Lookup.IMPL_LOOKUP);
        return result;
    }

    public static MethodHandle exactInvoker(MethodType type) throws IllegalArgumentException {
        return type.getInvokeExactHandle();
    }

    public static MethodHandle invoker(MethodType type) throws IllegalArgumentException {
        type.getClass();
        return new InvokeGenericHandle(type);
    }

    public static MethodHandle spreadInvoker(MethodType type, int fixedArgCount) throws IllegalArgumentException, NullPointerException {
        int typeParameterCount = type.parameterCount();
        if (fixedArgCount < 0 || fixedArgCount > typeParameterCount) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodHandle invoker = MethodHandles.invoker(type);
        int spreadArgCount = typeParameterCount - fixedArgCount;
        return invoker.asSpreader(Object[].class, spreadArgCount);
    }

    public static MethodHandle guardWithTest(MethodHandle guard, MethodHandle trueTarget, MethodHandle falseTarget) throws NullPointerException, IllegalArgumentException {
        MethodType guardType = guard.type;
        MethodType trueType = trueTarget.type;
        MethodType falseType = falseTarget.type;
        if (trueType != falseType) {
            throw new IllegalArgumentException();
        }
        int testArgCount = guardType.parameterCount();
        if (guardType.returnType() != Boolean.TYPE || testArgCount > trueType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < testArgCount; ++i) {
            if (guardType.parameterType(i) == trueType.parameterType(i)) continue;
            throw new IllegalArgumentException();
        }
        MethodHandle result = GuardWithTestHandle.get(guard, trueTarget, falseTarget);
        return result;
    }

    public static MethodHandle catchException(MethodHandle tryHandle, Class<? extends Throwable> throwableClass, MethodHandle catchHandle) throws NullPointerException, IllegalArgumentException {
        if (tryHandle == null || throwableClass == null || catchHandle == null) {
            throw new NullPointerException();
        }
        if (!Throwable.class.isAssignableFrom(throwableClass)) {
            throw new ClassCastException(throwableClass.getName());
        }
        MethodType tryType = tryHandle.type;
        MethodType catchType = catchHandle.type;
        if (tryType.returnType() != catchType.returnType()) {
            throw new IllegalArgumentException();
        }
        if (catchType.parameterType(0) != throwableClass) {
            throw new IllegalArgumentException();
        }
        int catchArgCount = catchType.parameterCount();
        if (catchArgCount - 1 > tryType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        Class<?>[] tryParams = tryType.ptypes();
        Class<?>[] catchParams = catchType.ptypes();
        for (int i = 1; i < catchArgCount; ++i) {
            if (catchParams[i] == tryParams[i - 1]) continue;
            throw new IllegalArgumentException();
        }
        MethodHandle result = MethodHandles.buildTransformHandle(new CatchHelper(tryHandle.asFixedArity(), catchHandle.asFixedArity(), throwableClass), tryType);
        CatchHandle thunkable = CatchHandle.get(tryHandle, throwableClass, catchHandle, result);
        assert (thunkable.type() == result.type());
        result = thunkable;
        return result;
    }

    public static MethodHandle identity(Class<?> classType) throws NullPointerException, IllegalArgumentException {
        if (classType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        try {
            MethodType methodType = MethodType.methodType(classType, classType);
            if (classType.isPrimitive()) {
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "identity", methodType);
            }
            MethodHandle handle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "identity", MethodType.methodType(Object.class, Object.class));
            return handle.cloneWithNewType(methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static boolean identity(boolean x) {
        return x;
    }

    private static byte identity(byte x) {
        return x;
    }

    private static short identity(short x) {
        return x;
    }

    private static char identity(char x) {
        return x;
    }

    private static int identity(int x) {
        return x;
    }

    private static float identity(float x) {
        return x;
    }

    private static double identity(double x) {
        return x;
    }

    private static long identity(long x) {
        return x;
    }

    private static Object identity(Object x) {
        return x;
    }

    public static MethodHandle constant(Class<?> returnType, Object constantValue) throws NullPointerException, ClassCastException, IllegalArgumentException {
        returnType.getClass();
        if (returnType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        if (returnType.isPrimitive()) {
            if (constantValue == null) {
                throw new IllegalArgumentException();
            }
            Class<?> unwrapped = MethodTypeHelper.unwrapPrimitive(constantValue.getClass());
            if (returnType != unwrapped && !ConvertHandle.FilterHelpers.checkIfWideningPrimitiveConversion(unwrapped, returnType)) {
                throw new ClassCastException();
            }
        } else {
            returnType.cast(constantValue);
        }
        return ConstantHandle.get(returnType, constantValue);
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayType) throws IllegalArgumentException {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> componentType = arrayType.getComponentType();
            if (componentType.isPrimitive()) {
                String name = componentType.getCanonicalName();
                MethodType type = MethodType.methodType(componentType, arrayType, Integer.TYPE);
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, name + "ArrayGetter", type);
            }
            MethodType type = MethodType.methodType(Object.class, Object[].class, Integer.TYPE);
            MethodHandle mh = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectArrayGetter", type);
            MethodType realType = MethodType.methodType(componentType, arrayType, Integer.TYPE);
            return mh.cloneWithNewType(realType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayType) throws IllegalArgumentException {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> componentType = arrayType.getComponentType();
            if (componentType.isPrimitive()) {
                String name = componentType.getCanonicalName();
                MethodType type = MethodType.methodType(Void.TYPE, arrayType, Integer.TYPE, componentType);
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, name + "ArraySetter", type);
            }
            MethodType type = MethodType.methodType(Void.TYPE, Object[].class, Integer.TYPE, Object.class);
            MethodHandle mh = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectArraySetter", type);
            MethodType realType = MethodType.methodType(Void.TYPE, arrayType, Integer.TYPE, componentType);
            return mh.cloneWithNewType(realType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exception) {
        MethodType realType = MethodType.methodType(returnType, exception);
        try {
            MethodHandle handle;
            if (returnType.isPrimitive() || returnType.equals(Void.TYPE)) {
                MethodType type = MethodType.methodType(returnType, Throwable.class);
                String name = returnType.getCanonicalName();
                handle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, name + "ExceptionThrower", type);
            } else {
                MethodType type = MethodType.methodType(Object.class, Throwable.class);
                handle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectExceptionThrower", type);
            }
            return handle.cloneWithNewType(realType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle filterReturnValue(MethodHandle handle, MethodHandle filter) throws NullPointerException, IllegalArgumentException {
        MethodType filterType = filter.type;
        int filterArgCount = filterType.parameterCount();
        Class<?> handleReturnType = handle.type.returnType();
        if (handleReturnType == Void.TYPE && filterArgCount == 0) {
            return new FilterReturnHandle(handle, filter);
        }
        if (filterArgCount == 1 && filterType.parameterType(0) == handle.type.returnType()) {
            return new FilterReturnHandle(handle, filter);
        }
        throw new IllegalArgumentException();
    }

    private static void voidExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static int intExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static char charExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static byte byteExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static boolean booleanExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static short shortExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static long longExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static double doubleExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static float floatExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static Object objectExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static int intArrayGetter(int[] array, int index) {
        return array[index];
    }

    private static char charArrayGetter(char[] array, int index) {
        return array[index];
    }

    private static short shortArrayGetter(short[] array, int index) {
        return array[index];
    }

    private static byte byteArrayGetter(byte[] array, int index) {
        return array[index];
    }

    private static long longArrayGetter(long[] array, int index) {
        return array[index];
    }

    private static double doubleArrayGetter(double[] array, int index) {
        return array[index];
    }

    private static float floatArrayGetter(float[] array, int index) {
        return array[index];
    }

    private static boolean booleanArrayGetter(boolean[] array, int index) {
        return array[index];
    }

    private static Object objectArrayGetter(Object[] array, int index) {
        return array[index];
    }

    private static void intArraySetter(int[] array, int index, int value) {
        array[index] = value;
    }

    private static void charArraySetter(char[] array, int index, char value) {
        array[index] = value;
    }

    private static void shortArraySetter(short[] array, int index, short value) {
        array[index] = value;
    }

    private static void byteArraySetter(byte[] array, int index, byte value) {
        array[index] = value;
    }

    private static void longArraySetter(long[] array, int index, long value) {
        array[index] = value;
    }

    private static void doubleArraySetter(double[] array, int index, double value) {
        array[index] = value;
    }

    private static void floatArraySetter(float[] array, int index, float value) {
        array[index] = value;
    }

    private static void booleanArraySetter(boolean[] array, int index, boolean value) {
        array[index] = value;
    }

    private static void objectArraySetter(Object[] array, int index, Object value) {
        array[index] = value;
    }

    public static MethodHandle filterArguments(MethodHandle handle, int startPosition, MethodHandle ... filters) throws NullPointerException, IllegalArgumentException {
        MethodHandle filter;
        int i;
        filters.getClass();
        MethodType handleType = handle.type;
        if (startPosition < 0 || startPosition + filters.length > handleType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (filters.length == 0) {
            return handle;
        }
        filters = (MethodHandle[])filters.clone();
        Class<?>[] newArgTypes = handleType.parameterArray();
        boolean containsNonNullFilters = false;
        for (i = 0; i < filters.length; ++i) {
            filter = filters[i];
            if (filter == null) continue;
            containsNonNullFilters = true;
            MethodType filterType = filter.type;
            if (newArgTypes[startPosition + i] != filterType.returnType()) {
                throw new IllegalArgumentException();
            }
            if (filterType.parameterCount() != 1) {
                throw new IllegalArgumentException();
            }
            newArgTypes[startPosition + i] = filterType.parameterType(0);
        }
        if (!containsNonNullFilters) {
            return handle;
        }
        for (i = 0; i < filters.length; ++i) {
            filter = filters[i];
            if (filter != null) {
                if (i == 0) break;
                filters = Arrays.copyOfRange(filters, i, filters.length);
                break;
            }
            ++startPosition;
        }
        MethodType newType = MethodType.methodType(handleType.returnType(), newArgTypes);
        FilterArgumentsHandle result = FilterArgumentsHandle.get(handle, startPosition, filters, newType);
        return result;
    }

    public static MethodHandle foldArguments(MethodHandle handle, MethodHandle preprocessor) throws NullPointerException, IllegalArgumentException {
        return MethodHandles.foldArgumentsCommon(handle, 0, preprocessor, EMPTY_ARG_POSITIONS);
    }

    private static final MethodHandle foldArgumentsCommon(MethodHandle handle, int foldPosition, MethodHandle preprocessor, int ... argumentIndices) throws NullPointerException, IllegalArgumentException {
        MethodType handleType = handle.type;
        MethodType preprocessorType = preprocessor.type;
        Class<?> preprocessorReturnClass = preprocessorType.returnType();
        int handleTypeParamCount = handleType.parameterCount();
        int preprocessorTypeParamCount = preprocessorType.parameterCount();
        int argIndexCount = argumentIndices.length;
        int[] passedInArgumentIndices = EMPTY_ARG_POSITIONS;
        if (foldPosition < 0 || foldPosition > handleTypeParamCount || foldPosition == handleTypeParamCount && handleTypeParamCount != 0) {
            throw new IllegalArgumentException(Msg.getString("K0637", new Object[]{"the fold position", Integer.toString(foldPosition), Integer.toString(handleTypeParamCount)}));
        }
        if (argIndexCount > 0 && preprocessorTypeParamCount != argIndexCount) {
            throw new IllegalArgumentException(Msg.getString("K0638", new Object[]{Integer.toString(argIndexCount), Integer.toString(preprocessorTypeParamCount)}));
        }
        for (int i = 0; i < argIndexCount; ++i) {
            if (argumentIndices[i] < 0 || argumentIndices[i] >= handleTypeParamCount) {
                throw new IllegalArgumentException(Msg.getString("K0637", new Object[]{"argument index", Integer.toString(argumentIndices[i]), Integer.toString(handleTypeParamCount)}));
            }
            if (foldPosition + i + 1 == argumentIndices[i]) continue;
            passedInArgumentIndices = argumentIndices;
            break;
        }
        if (Void.TYPE == preprocessorReturnClass) {
            if (handleTypeParamCount < preprocessorTypeParamCount) {
                throw new IllegalArgumentException(Msg.getString("K0650", new Object[]{Integer.toString(preprocessorTypeParamCount), "<=", Integer.toString(handleTypeParamCount)}));
            }
            MethodHandles.validateParametersOfCombiner(argIndexCount, preprocessorTypeParamCount, preprocessorType, handleType, argumentIndices, foldPosition, 0);
            FoldHandle result = FoldHandle.get(handle, preprocessor, handleType, foldPosition, passedInArgumentIndices);
            return result;
        }
        if (handleTypeParamCount <= preprocessorTypeParamCount) {
            throw new IllegalArgumentException(Msg.getString("K0650", new Object[]{Integer.toString(preprocessorTypeParamCount), "<", Integer.toString(handleTypeParamCount)}));
        }
        if (preprocessorReturnClass != handleType.parameterType(foldPosition)) {
            throw new IllegalArgumentException(Msg.getString("K063A1", new Object[]{preprocessorReturnClass.getSimpleName(), "filter", handleType.parameterType(foldPosition).getSimpleName(), "filter", Integer.toString(foldPosition)}));
        }
        MethodHandles.validateParametersOfCombiner(argIndexCount, preprocessorTypeParamCount, preprocessorType, handleType, argumentIndices, foldPosition, 1);
        MethodType newType = handleType.dropParameterTypes(foldPosition, foldPosition + 1);
        FoldHandle result = FoldHandle.get(handle, preprocessor, newType, foldPosition, passedInArgumentIndices);
        return result;
    }

    private static void validateParametersOfCombiner(int argIndexCount, int preprocessorTypeParamCount, MethodType preprocessorType, MethodType handleType, int[] argumentIndices, int foldPosition, int foldPlaceHolder) {
        if (0 == argIndexCount) {
            for (int i = 0; i < preprocessorTypeParamCount; ++i) {
                if (preprocessorType.parameterType(i) == handleType.parameterType(foldPosition + i + foldPlaceHolder)) continue;
                throw new IllegalArgumentException(Msg.getString("K05d0", preprocessorType.toString(), handleType.toString(), Integer.toString(foldPosition)));
            }
        } else {
            for (int i = 0; i < argIndexCount; ++i) {
                if (preprocessorType.parameterType(i) == handleType.parameterType(argumentIndices[i])) continue;
                throw new IllegalArgumentException(Msg.getString("K05d0", preprocessorType.toString(), handleType.toString(), Integer.toString(foldPosition)));
            }
        }
    }

    public static MethodHandle permuteArguments(MethodHandle handle, MethodType permuteType, int ... permute) throws NullPointerException, IllegalArgumentException {
        MethodType handleType = handle.type;
        Class<?> permuteReturnType = permuteType.returnType();
        if (permute.length != handleType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (permuteReturnType != handleType.returnType()) {
            throw new IllegalArgumentException();
        }
        permute = (int[])permute.clone();
        MethodHandles.validatePermutationArray(permuteType, handleType, permute);
        return handle.permuteArguments(permuteType, permute);
    }

    public static MethodHandle collectArguments(MethodHandle target, int pos, MethodHandle filter) throws NullPointerException, IllegalArgumentException {
        MethodType targetType = target.type;
        MethodType filterType = filter.type;
        Class<?> filterReturnClass = filterType.returnType();
        if (filterReturnClass == Void.TYPE) {
            if (pos < 0 || pos > targetType.argSlots) {
                throw new IllegalArgumentException(Msg.getString("K0580", targetType.argSlots));
            }
            MethodType resultType = targetType.insertParameterTypes(pos, filterType.ptypes());
            MethodHandle result = MethodHandles.buildTransformHandle(new VoidCollectHelper(target, pos, filter), resultType);
            return result;
        }
        if (pos < 0 || pos >= targetType.argSlots) {
            throw new IllegalArgumentException(Msg.getString("K0580", targetType.argSlots));
        }
        if (filterReturnClass != targetType.parameterType(pos)) {
            throw new IllegalArgumentException(Msg.getString("K0581", pos));
        }
        MethodType resultType = targetType.dropParameterTypes(pos, pos + 1).insertParameterTypes(pos, filterType.ptypes());
        MethodHandle result = MethodHandles.buildTransformHandle(new CollectHelper(target, pos, filter), resultType);
        return result;
    }

    private static boolean validatePermutationArray(MethodType permuteType, MethodType handleType, int[] permute) throws IllegalArgumentException {
        Class<?>[] permuteArgs = permuteType.ptypes();
        Class<?>[] handleArgs = handleType.ptypes();
        for (int i = 0; i < permute.length; ++i) {
            int permuteIndex = permute[i];
            if (permuteIndex < 0 || permuteIndex >= permuteArgs.length) {
                throw new IllegalArgumentException();
            }
            if (handleArgs[i] == permuteArgs[permuteIndex]) continue;
            throw new IllegalArgumentException();
        }
        return true;
    }

    private static MethodHandle dropArgumentsUnsafe(MethodHandle originalHandle, int location, Class<?> ... valueTypes) {
        int valueTypeLength = valueTypes.length;
        MethodType originalType = originalHandle.type;
        if (location < 0 || location > originalType.parameterCount()) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodType permuteType = originalType.insertParameterTypes(location, valueTypes);
        int[] permute = new int[originalType.parameterCount()];
        int originalIndex = 0;
        for (int i = 0; i < permute.length; ++i) {
            if (originalIndex == location) {
                originalIndex += valueTypeLength;
            }
            permute[i] = originalIndex++;
        }
        assert (MethodHandles.validatePermutationArray(permuteType, originalType, permute));
        return originalHandle.permuteArguments(permuteType, permute);
    }

    public static MethodHandle dropArguments(MethodHandle originalHandle, int location, Class<?> ... valueTypes) {
        valueTypes = (Class[])valueTypes.clone();
        return MethodHandles.dropArgumentsUnsafe(originalHandle, location, valueTypes);
    }

    public static MethodHandle dropArguments(MethodHandle originalHandle, int location, List<Class<?>> valueTypes) {
        valueTypes.getClass();
        Class[] valueTypesCopy = new Class[valueTypes.size()];
        for (int i = 0; i < valueTypes.size(); ++i) {
            valueTypesCopy[i] = valueTypes.get(i);
        }
        return MethodHandles.dropArgumentsUnsafe(originalHandle, location, valueTypesCopy);
    }

    private static MethodHandle buildTransformHandle(ArgumentHelper helper, MethodType mtype) {
        MethodType helperType = MethodType.methodType(Object.class, Object[].class);
        try {
            return Lookup.internalPrivilegedLookup.bind(helper, "helper", helperType).asCollector(Object[].class, mtype.parameterCount()).asType(mtype);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle explicitCastArguments(MethodHandle handle, MethodType type) throws NullPointerException, WrongMethodTypeException {
        MethodType handleType = handle.type;
        Class<?> newReturnType = type.returnType();
        if (handleType == type) {
            return handle;
        }
        MethodHandle mh = handle;
        if (handleType.returnType() != newReturnType) {
            MethodHandle filter = ConvertHandle.FilterHelpers.getReturnFilter(handleType.returnType(), newReturnType, true);
            mh = new FilterReturnHandle(handle, filter);
            if (mh.type == type) {
                return mh;
            }
        }
        return new ExplicitCastHandle(mh, type);
    }

    public static MethodHandle insertArguments(MethodHandle originalHandle, int location, Object ... values) {
        InsertHandle insertHandle;
        boolean noValuesToInsert;
        MethodType originalType = originalHandle.type;
        Class<?>[] arguments = originalType.parameterArray();
        boolean bl = noValuesToInsert = values.length == 0;
        if (location < 0 || location > originalType.parameterCount() - values.length) {
            throw new IllegalArgumentException();
        }
        if (noValuesToInsert) {
            return originalHandle;
        }
        values = (Object[])values.clone();
        for (int i = 0; i < values.length; ++i) {
            Class<?> clazz = arguments[location + i];
            Object value = values[i];
            Class<Object> valueClazz = clazz;
            if (value != null) {
                valueClazz = value.getClass();
            }
            if (clazz.isPrimitive()) {
                Objects.requireNonNull(value);
                Class<?> unwrapped = MethodTypeHelper.unwrapPrimitive(valueClazz);
                if (clazz != unwrapped && !ConvertHandle.FilterHelpers.checkIfWideningPrimitiveConversion(unwrapped, clazz)) {
                    clazz.cast(value);
                }
            } else {
                clazz.cast(value);
            }
            arguments[location + i] = valueClazz;
        }
        MethodHandle asTypedOriginalHandle = originalHandle.asType(MethodType.methodType(originalType.returnType(), arguments));
        MethodType mtype = originalType.dropParameterTypes(location, location + values.length);
        switch (values.length) {
            case 1: {
                if (originalType.parameterType(location) == Integer.TYPE) {
                    insertHandle = new Insert1IntHandle(mtype, asTypedOriginalHandle, location, values, originalHandle);
                    break;
                }
                insertHandle = new Insert1Handle(mtype, asTypedOriginalHandle, location, values);
                break;
            }
            case 2: {
                insertHandle = new Insert2Handle(mtype, asTypedOriginalHandle, location, values);
                break;
            }
            case 3: {
                insertHandle = new Insert3Handle(mtype, asTypedOriginalHandle, location, values);
                break;
            }
            default: {
                insertHandle = new InsertHandle(mtype, asTypedOriginalHandle, location, values);
            }
        }
        return originalHandle.insertArguments(insertHandle, asTypedOriginalHandle, location, values);
    }

    private static final class VoidCollectHelper
    implements ArgumentHelper {
        private final MethodHandle target;
        private final MethodHandle filter;
        private final int pos;

        VoidCollectHelper(MethodHandle target, int pos, MethodHandle filter) {
            this.target = target;
            this.filter = filter;
            this.pos = pos;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            int filterArity = this.filter.type.parameterCount();
            this.filter.invokeWithArguments(Arrays.copyOfRange(arguments, this.pos, this.pos + filterArity));
            Object[] newArguments = new Object[arguments.length - filterArity];
            System.arraycopy((Object)arguments, 0, (Object)newArguments, 0, this.pos);
            int resumeTargetArgs = this.pos + filterArity;
            System.arraycopy((Object)arguments, resumeTargetArgs, (Object)newArguments, this.pos, arguments.length - resumeTargetArgs);
            return this.target.invokeWithArguments(newArguments);
        }
    }

    private static final class CollectHelper
    implements ArgumentHelper {
        private final MethodHandle target;
        private final MethodHandle filter;
        private final int pos;

        CollectHelper(MethodHandle target, int pos, MethodHandle filter) {
            this.target = target;
            this.filter = filter;
            this.pos = pos;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            int filterArity = this.filter.type.parameterCount();
            Object filterReturn = this.filter.invokeWithArguments(Arrays.copyOfRange(arguments, this.pos, this.pos + filterArity));
            Object[] newArguments = new Object[arguments.length - filterArity + 1];
            System.arraycopy((Object)arguments, 0, (Object)newArguments, 0, this.pos);
            int resumeTargetArgs = this.pos + filterArity;
            newArguments[this.pos] = filterReturn;
            System.arraycopy((Object)arguments, resumeTargetArgs, (Object)newArguments, this.pos + 1, arguments.length - resumeTargetArgs);
            return this.target.invokeWithArguments(newArguments);
        }
    }

    private static final class CatchHelper
    implements ArgumentHelper {
        private final MethodHandle tryTarget;
        private final MethodHandle catchTarget;
        private final Class<? extends Throwable> exceptionClass;

        CatchHelper(MethodHandle tryTarget, MethodHandle catchTarget, Class<? extends Throwable> exceptionClass) {
            this.tryTarget = tryTarget;
            this.catchTarget = catchTarget;
            this.exceptionClass = exceptionClass;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            try {
                return this.tryTarget.invokeWithArguments(arguments);
            }
            catch (Throwable t) {
                if (this.exceptionClass.isInstance(t)) {
                    int catchArgCount = this.catchTarget.type.parameterCount();
                    Object[] amendedArgs = new Object[catchArgCount];
                    amendedArgs[0] = t;
                    System.arraycopy((Object)arguments, 0, (Object)amendedArgs, 1, catchArgCount - 1);
                    return this.catchTarget.invokeWithArguments(amendedArgs);
                }
                throw t;
            }
        }
    }

    public static final class Lookup {
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        static final int INTERNAL_PRIVILEGED = 128;
        private static final int FULL_ACCESS_MASK = 15;
        private static final int NO_ACCESS = 0;
        private static final String INVOKE_EXACT = "invokeExact";
        private static final String INVOKE = "invoke";
        static final int VARARGS = 128;
        static final int mhMask = 1;
        static Lookup PUBLIC_LOOKUP = new Lookup(Object.class, 1);
        static Lookup internalPrivilegedLookup;
        static Lookup IMPL_LOOKUP;
        final Class<?> prevAccessClass;
        final Class<?> accessClass;
        final int accessMode;
        private final boolean performSecurityCheck;

        Lookup(Class<?> lookupClass, Class<?> prevLookupClass, int lookupMode, boolean doCheck) {
            this.performSecurityCheck = doCheck;
            if (doCheck && 128 != lookupMode && lookupClass.getName().startsWith("java.lang.invoke.")) {
                throw new IllegalArgumentException(Msg.getString("K0588", lookupClass.getName()));
            }
            this.accessClass = lookupClass;
            this.prevAccessClass = prevLookupClass;
            this.accessMode = lookupMode;
        }

        private static boolean lookupJLIPackageCheckDefault() {
            return true;
        }

        Lookup(Class<?> lookupClass, Class<?> prevLookupClass, int lookupMode) {
            this(lookupClass, prevLookupClass, lookupMode, Lookup.lookupJLIPackageCheckDefault());
        }

        Lookup(Class<?> lookupClass, int lookupMode) {
            this(lookupClass, null, lookupMode, Lookup.lookupJLIPackageCheckDefault());
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, null, 15, Lookup.lookupJLIPackageCheckDefault());
        }

        Lookup(Class<?> lookupClass, boolean performSecurityCheck) {
            this(lookupClass, null, 15, performSecurityCheck);
        }

        public int lookupModes() {
            return this.accessMode;
        }

        static boolean isVarargs(int modifiers) {
            return (modifiers & 0x80) != 0;
        }

        private static MethodHandle convertToVarargsIfRequired(MethodHandle handle) {
            if (Lookup.isVarargs(handle.getModifiers())) {
                Class<?> lastClass = handle.type.lastParameterType();
                return handle.asVarargsCollector(lastClass);
            }
            return handle;
        }

        public MethodHandle bind(Object receiver, String methodName, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(receiver, methodName, type);
            Class<? extends Object> receiverClass = receiver.getClass();
            MethodHandle handle = this.handleForMHInvokeMethods(receiverClass, methodName, type);
            if (handle == null) {
                try {
                    handle = this.findSpecialImpl(receiverClass, methodName, type, receiverClass);
                    handle = handle.asFixedArity();
                    handle = Lookup.convertToVarargsIfRequired(handle.bindTo(receiver));
                }
                catch (ClassCastException e) {
                    throw new IllegalAccessException(e.getMessage());
                }
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), receiverClass, handle.getModifiers());
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle);
            return handle;
        }

        private static void nullCheck(Object a, Object b) {
            a.getClass();
            b.getClass();
        }

        private static void nullCheck(Object a, Object b, Object c) {
            a.getClass();
            b.getClass();
            c.getClass();
        }

        private static void nullCheck(Object a, Object b, Object c, Object d) {
            a.getClass();
            b.getClass();
            c.getClass();
            d.getClass();
        }

        private static void initCheck(String methodName) throws NoSuchMethodException {
            if ("<init>".equals(methodName) || "<clinit>".equals(methodName)) {
                throw new NoSuchMethodException(Msg.getString("K05ce", methodName));
            }
        }

        static final VMLangAccess getVMLangAccess() {
            return VMLangAccessGetter.vma;
        }

        private static int getClassModifiers(Class<?> cls) {
            int modifiers = 0;
            modifiers = cls.isPrimitive() || cls.isArray() ? cls.getModifiers() : Reflection.getClassAccessFlags(cls);
            return modifiers;
        }

        private static boolean isSamePackage(Class<?> a, Class<?> b) {
            ClassLoader clb;
            if (a == b) {
                return true;
            }
            while (a.isArray()) {
                a = a.getComponentType();
            }
            while (b.isArray()) {
                b = b.getComponentType();
            }
            VMLangAccess vma = Lookup.getVMLangAccess();
            String packageName1 = vma.getPackageName(a);
            String packageName2 = vma.getPackageName(b);
            if (packageName1 == null || packageName2 == null || !packageName1.equals(packageName2)) {
                return false;
            }
            ClassLoader cla = vma.getClassloader(a);
            if (cla == (clb = vma.getClassloader(b))) {
                return true;
            }
            return vma.isAncestor(cla, clb) || vma.isAncestor(clb, cla);
        }

        void checkAccess(MethodHandle handle, boolean skipAccessCheckPara) throws IllegalAccessException {
            if (128 == this.accessMode) {
                return;
            }
            if (0 == this.accessMode) {
                throw new IllegalAccessException(this.toString());
            }
            this.checkAccess(handle.getDefc(), handle.getReferenceClass(), handle.getMethodName(), handle.getModifiers(), handle, skipAccessCheckPara);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkAccess(Class<?> definingClass, Class<?> referenceClass, String name, int memberModifiers, MethodHandle handle, boolean skipAccessCheckPara) throws IllegalAccessException {
            if (null == referenceClass) {
                referenceClass = definingClass;
            }
            this.checkClassAccess(referenceClass);
            if (Modifier.isPublic(memberModifiers)) {
                return;
            }
            if (Modifier.isPrivate(memberModifiers)) {
                if (Modifier.isPrivate(this.accessMode) && definingClass == this.accessClass) {
                    return;
                }
            } else if (Modifier.isProtected(memberModifiers)) {
                if (this.accessMode != 1) {
                    if (definingClass.isArray()) {
                        return;
                    }
                    if (Lookup.isSamePackage(this.accessClass, referenceClass)) {
                        return;
                    }
                    if (!this.accessClass.isInterface() && Modifier.isProtected(this.accessMode) && definingClass.isAssignableFrom(this.accessClass)) {
                        if (null == handle) return;
                        byte kind = handle.kind;
                        if (8 != kind && (7 != kind || handle.directHandleOriginatedInFindVirtual())) return;
                        Class<?> protectedTargetClass = handle.getReferenceClass();
                        if (7 == kind) {
                            protectedTargetClass = handle.getSpecialCaller();
                        }
                        if (this.accessClass.isAssignableFrom(protectedTargetClass)) {
                            return;
                        }
                    }
                }
            } else if (8 == (this.accessMode & 8) && Lookup.isSamePackage(this.accessClass, referenceClass)) {
                return;
            }
            String extraInfo = "";
            extraInfo = null != handle ? name + ":" + handle.type + "/" + handle.mapKindToBytecode() : "." + name;
            String errorMessage = Msg.getString("K0587", (Object)this.toString(), definingClass.getName() + extraInfo);
            throw new IllegalAccessException(errorMessage);
        }

        private void checkClassAccess(Class<?> targetClass) throws IllegalAccessException {
            if (0 != this.accessMode) {
                int targetClassModifiers = Lookup.getClassModifiers(targetClass);
                boolean targetClassIsPublic = Modifier.isPublic(targetClassModifiers);
                if (this.accessClass == targetClass) {
                    return;
                }
                if (targetClassIsPublic) {
                    return;
                }
                if ((8 == (this.accessMode & 8) || Modifier.isPrivate(this.accessMode)) && Lookup.isSamePackage(this.accessClass, targetClass)) {
                    return;
                }
            }
            throw new IllegalAccessException(Msg.getString("K0680", (Object)this.accessClass.getName(), targetClass.getName()));
        }

        private void checkSpecialAccess(Class<?> declaringClass, Class<?> callerClass) throws IllegalAccessException {
            if (128 == this.accessMode) {
                return;
            }
            if (this.isWeakenedLookup() || this.accessClass != callerClass && (!declaringClass.isInterface() || !declaringClass.isAssignableFrom(callerClass))) {
                throw new IllegalAccessException(Msg.getString("K0585", (Object)this.accessClass.getName(), callerClass.getName()));
            }
        }

        public MethodHandle findSpecial(Class<?> clazz, String methodName, MethodType type, Class<?> specialToken) throws IllegalAccessException, NoSuchMethodException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, methodName, type, specialToken);
            this.checkSpecialAccess(clazz, specialToken);
            MethodHandle handle = null;
            try {
                handle = this.findSpecialImpl(clazz, methodName, type, specialToken);
                Class<?> handleDefc = handle.getDefc();
                if (this.accessClass.isAssignableFrom(specialToken) && !handleDefc.isAssignableFrom(this.accessClass)) {
                    throw new IllegalAccessException(Msg.getString("K0586", this.accessClass, handleDefc));
                }
                this.checkAccess(handle, false);
                this.checkSecurity(handleDefc, clazz, handle.getModifiers());
                handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle);
            }
            catch (DefaultMethodConflictException e) {
                handle = Lookup.throwExceptionWithMethodTypeAndMessage(IncompatibleClassChangeError.class, type.insertParameterTypes(0, specialToken), e.getCause().getMessage());
            }
            return handle;
        }

        private MethodHandle findSpecialImpl(Class<?> clazz, String methodName, MethodType type, Class<?> specialToken) throws IllegalAccessException, NoSuchMethodException, SecurityException, NullPointerException {
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getSpecialCache(clazz);
            MethodHandle handle = HandleCache.getMethodWithSpecialCallerFromPerClassCache(cache, methodName, type, specialToken);
            if (handle == null) {
                Lookup.initCheck(methodName);
                handle = new DirectHandle(clazz, methodName, type, 7, specialToken);
                if (internalPrivilegedLookup != this) {
                    handle = this.restrictReceiver(handle);
                }
                handle = Lookup.convertToVarargsIfRequired(handle);
                HandleCache.putMethodWithSpecialCallerInPerClassCache(cache, methodName, type, handle, specialToken);
            }
            return handle;
        }

        public MethodHandle findStatic(Class<?> clazz, String methodName, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(clazz, methodName, type);
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getStaticCache(clazz);
            MethodHandle handle = HandleCache.getMethodFromPerClassCache(cache, methodName, type);
            if (handle == null) {
                Lookup.initCheck(methodName);
                handle = new DirectHandle(clazz, methodName, type, 6, null);
                handle = HandleCache.putMethodInPerClassCache(cache, methodName, type, Lookup.convertToVarargsIfRequired(handle));
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), clazz, handle.getModifiers());
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle);
            return handle;
        }

        public MethodHandle findVirtual(Class<?> clazz, String methodName, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(clazz, methodName, type);
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getVirtualCache(clazz);
            MethodHandle handle = HandleCache.getMethodFromPerClassCache(cache, methodName, type);
            if (handle == null) {
                handle = this.handleForMHInvokeMethods(clazz, methodName, type);
            }
            if (handle == null) {
                Lookup.initCheck(methodName);
                if (clazz.isInterface()) {
                    handle = Lookup.findInterface(clazz, methodName, type);
                } else {
                    int handleModifiers;
                    handle = new DirectHandle(clazz, methodName, type, 5, clazz, true);
                    if (!(Modifier.isFinal(clazz.getModifiers()) || Modifier.isPrivate(handleModifiers = handle.getModifiers()) || Modifier.isFinal(handleModifiers))) {
                        handle = new VirtualHandle((DirectHandle)handle);
                    }
                }
                handle = Lookup.convertToVarargsIfRequired(handle);
                HandleCache.putMethodInPerClassCache(cache, methodName, type, handle);
            }
            handle = this.restrictReceiver(handle);
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), clazz, handle.getModifiers());
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle);
            return handle;
        }

        private MethodHandle restrictReceiver(MethodHandle handle) {
            int handleModifiers = handle.getModifiers();
            Class<?> handleDefc = handle.getDefc();
            if (!Modifier.isStatic(handleModifiers) && Modifier.isProtected(handleModifiers) && handleDefc != this.accessClass && handleDefc.isAssignableFrom(this.accessClass) && !Lookup.isSamePackage(handleDefc, this.accessClass)) {
                handle = handle.cloneWithNewType(handle.type.changeParameterType(0, this.accessClass));
            }
            return handle;
        }

        private static MethodHandle findInterface(Class<?> clazz, String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle handle = new DirectHandle(clazz, methodName, type, 5, clazz, true);
            Class<?> handleClass = ((MethodHandle)handle).getDefc();
            if (Object.class == handleClass) {
                if (!Modifier.isPublic(((MethodHandle)handle).getModifiers())) {
                    throw new NoSuchMethodException(clazz + "." + methodName + type);
                }
                handle = new DirectHandle(Object.class, methodName, type, 7, Object.class);
                if (!Modifier.isFinal(((MethodHandle)handle).getModifiers())) {
                    handle = new VirtualHandle((DirectHandle)handle);
                }
                handle = ((MethodHandle)handle).cloneWithNewType(handle.type.changeParameterType(0, clazz));
            } else {
                if (!Modifier.isPublic(((MethodHandle)handle).getModifiers())) {
                    throw new IllegalAccessException();
                }
                handle = new InterfaceHandle(clazz, methodName, type);
            }
            return handle;
        }

        final void accessCheckArgRetTypes(MethodType type) throws IllegalAccessException {
            if (128 != this.accessMode) {
                for (Class<?> para : type.ptypes()) {
                    if (para.isPrimitive()) continue;
                    while (para.isArray()) {
                        para = para.getComponentType();
                    }
                    this.checkClassAccess(para);
                }
                Class<?> rType = type.returnType();
                if (!rType.isPrimitive()) {
                    while (rType.isArray()) {
                        rType = rType.getComponentType();
                    }
                    this.checkClassAccess(rType);
                }
            }
        }

        MethodHandle handleForMHInvokeMethods(Class<?> clazz, String methodName, MethodType type) throws IllegalAccessException {
            if (MethodHandle.class.isAssignableFrom(clazz)) {
                if (INVOKE_EXACT.equals(methodName)) {
                    this.accessCheckArgRetTypes(type);
                    return type.getInvokeExactHandle();
                }
                if (INVOKE.equals(methodName)) {
                    this.accessCheckArgRetTypes(type);
                    return new InvokeGenericHandle(type);
                }
            }
            return null;
        }

        public MethodHandle findGetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, fieldName, fieldType);
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getFieldGetterCache(clazz);
            MethodHandle handle = HandleCache.getFieldFromPerClassCache(cache, fieldName, fieldType);
            if (handle == null) {
                handle = new FieldGetterHandle(clazz, fieldName, fieldType, this.accessClass);
                HandleCache.putFieldInPerClassCache(cache, fieldName, fieldType, handle);
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), clazz, handle.getModifiers());
            return handle;
        }

        public MethodHandle findStaticGetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, fieldName, fieldType);
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getStaticFieldGetterCache(clazz);
            MethodHandle handle = HandleCache.getFieldFromPerClassCache(cache, fieldName, fieldType);
            if (handle == null) {
                handle = new StaticFieldGetterHandle(clazz, fieldName, fieldType, this.accessClass);
                HandleCache.putFieldInPerClassCache(cache, fieldName, fieldType, handle);
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), clazz, handle.getModifiers());
            return handle;
        }

        public MethodHandle findSetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, fieldName, fieldType);
            if (fieldType == Void.TYPE) {
                throw new NoSuchFieldException();
            }
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getFieldSetterCache(clazz);
            MethodHandle handle = HandleCache.getFieldFromPerClassCache(cache, fieldName, fieldType);
            if (handle == null) {
                handle = new FieldSetterHandle(clazz, fieldName, fieldType, this.accessClass);
                HandleCache.putFieldInPerClassCache(cache, fieldName, fieldType, handle);
            }
            if (Modifier.isFinal(handle.getModifiers())) {
                throw new IllegalAccessException(Msg.getString("K05cf"));
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), clazz, handle.getModifiers());
            return handle;
        }

        public MethodHandle findStaticSetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            Lookup.nullCheck(clazz, fieldName, fieldType);
            if (fieldType == Void.TYPE) {
                throw new NoSuchFieldException();
            }
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getStaticFieldSetterCache(clazz);
            MethodHandle handle = HandleCache.getFieldFromPerClassCache(cache, fieldName, fieldType);
            if (handle == null) {
                handle = new StaticFieldSetterHandle(clazz, fieldName, fieldType, this.accessClass);
                HandleCache.putFieldInPerClassCache(cache, fieldName, fieldType, handle);
            }
            if (Modifier.isFinal(handle.getModifiers())) {
                throw new IllegalAccessException(Msg.getString("K05cf"));
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), clazz, handle.getModifiers());
            return handle;
        }

        public Lookup in(Class<?> lookupClass) {
            int lookupClassModifiers;
            Class<?> l;
            Class<?> a;
            Objects.requireNonNull(lookupClass);
            if (lookupClass == this.accessClass) {
                return this;
            }
            int newAccessMode = this.accessMode;
            newAccessMode &= 0xFFFFFFFB;
            if (!Lookup.isSamePackage(this.accessClass, lookupClass)) {
                newAccessMode &= 0xFFFFFFF3;
            }
            if (2 == (newAccessMode & 2) && (a = Lookup.getUltimateEnclosingClassOrSelf(this.accessClass)) != (l = Lookup.getUltimateEnclosingClassOrSelf(lookupClass))) {
                newAccessMode &= 0xFFFFFFFD;
            }
            if (!Modifier.isPublic(lookupClassModifiers = Lookup.getClassModifiers(lookupClass))) {
                if (Lookup.isSamePackage(this.accessClass, lookupClass)) {
                    if (0 == (this.accessMode & 8)) {
                        newAccessMode = 0;
                    }
                } else {
                    newAccessMode = 0;
                }
            } else {
                VMLangAccess vma = Lookup.getVMLangAccess();
                if (vma.getClassloader(this.accessClass) != vma.getClassloader(lookupClass)) {
                    newAccessMode &= 0xFFFFFFF1;
                }
            }
            return new Lookup(lookupClass, newAccessMode);
        }

        private static Class<?> getUltimateEnclosingClassOrSelf(Class<?> c) {
            Class<?> previous = c;
            for (Class<?> enclosing = c.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                previous = enclosing;
            }
            return previous;
        }

        public Class<?> lookupClass() {
            return this.accessClass;
        }

        public MethodHandle unreflect(Method method) throws IllegalAccessException {
            MethodType type;
            String methodName;
            int methodModifiers = method.getModifiers();
            Class<?> declaringClass = method.getDeclaringClass();
            Map<CacheKey, WeakReference<MethodHandle>> cache = Modifier.isStatic(methodModifiers) ? HandleCache.getStaticCache(declaringClass) : HandleCache.getVirtualCache(declaringClass);
            MethodHandle handle = HandleCache.getMethodFromPerClassCache(cache, methodName = method.getName(), type = MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
            if (handle == null) {
                if (Modifier.isStatic(methodModifiers)) {
                    handle = new DirectHandle(method, 6, null);
                } else if (declaringClass.isInterface()) {
                    if (Modifier.isPrivate(methodModifiers)) {
                        MethodHandle constructor;
                        if (!method.isAccessible()) {
                            if (this.accessMode == 0) {
                                throw new IllegalAccessException(this.toString());
                            }
                            if (declaringClass != this.accessClass || !Modifier.isPrivate(this.accessMode)) {
                                String message = Msg.getString("K0678", (Object)this.toString(), declaringClass + "." + method.getName() + ":" + 9 + "/invokeinterface");
                                throw new IllegalAccessException(message);
                            }
                        }
                        type = type.insertParameterTypes(0, declaringClass);
                        MethodHandle thrower = MethodHandles.throwException(type.returnType(), AbstractMethodError.class);
                        try {
                            constructor = IMPL_LOOKUP.findConstructor(AbstractMethodError.class, MethodType.methodType(Void.TYPE));
                        }
                        catch (IllegalAccessException | NoSuchMethodException e) {
                            throw new InternalError("Unable to find AbstractMethodError.<init>()");
                        }
                        handle = MethodHandles.foldArguments(thrower, constructor);
                        handle = MethodHandles.dropArguments(handle, 0, type.parameterList());
                        if (Lookup.isVarargs(methodModifiers)) {
                            Class<?> lastClass = handle.type.lastParameterType();
                            handle = handle.asVarargsCollector(lastClass);
                        }
                        return handle;
                    }
                    handle = new InterfaceHandle(method);
                } else {
                    handle = !Modifier.isPrivate(methodModifiers) && !Modifier.isFinal(methodModifiers) ? new VirtualHandle(method) : new DirectHandle(method, 7, declaringClass, true);
                }
                handle = Lookup.convertToVarargsIfRequired(handle);
                HandleCache.putMethodInPerClassCache(cache, methodName, type, handle);
            }
            if (!method.isAccessible()) {
                handle = this.restrictReceiver(handle);
                this.checkAccess(handle, true);
            }
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle);
            return handle;
        }

        public MethodHandle unreflectConstructor(Constructor<?> method) throws IllegalAccessException {
            MethodType type;
            String methodName = method.getName();
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getConstructorCache(method.getDeclaringClass());
            MethodHandle handle = HandleCache.getMethodFromPerClassCache(cache, methodName, type = MethodType.methodType(Void.TYPE, method.getParameterTypes()));
            if (handle == null) {
                handle = new ConstructorHandle(method);
                handle = Lookup.convertToVarargsIfRequired(handle);
                HandleCache.putMethodInPerClassCache(cache, methodName, type, handle);
            }
            if (!method.isAccessible()) {
                this.checkAccess(handle, true);
            }
            return handle;
        }

        public MethodHandle findConstructor(Class<?> declaringClass, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            Lookup.nullCheck(declaringClass, type);
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getConstructorCache(declaringClass);
            MethodHandle handle = HandleCache.getMethodFromPerClassCache(cache, "<init>", type);
            if (handle == null) {
                handle = new ConstructorHandle(declaringClass, type);
                if (type.returnType() != Void.TYPE) {
                    throw new NoSuchMethodException();
                }
                handle = HandleCache.putMethodInPerClassCache(cache, "<init>", type, Lookup.convertToVarargsIfRequired(handle));
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.getDefc(), declaringClass, handle.getModifiers());
            return handle;
        }

        public MethodHandle unreflectSpecial(Method method, Class<?> specialToken) throws IllegalAccessException {
            Lookup.nullCheck(method, specialToken);
            Class<?> clazz = method.getDeclaringClass();
            this.checkSpecialAccess(clazz, specialToken);
            String methodName = method.getName();
            Map<CacheKey, WeakReference<MethodHandle>> cache = HandleCache.getSpecialCache(clazz);
            MethodType type = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            MethodHandle handle = HandleCache.getMethodWithSpecialCallerFromPerClassCache(cache, methodName, type, specialToken);
            if (handle == null) {
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalAccessException();
                }
                handle = Lookup.convertToVarargsIfRequired(new DirectHandle(method, 7, specialToken));
                HandleCache.putMethodWithSpecialCallerInPerClassCache(cache, methodName, type, handle, specialToken);
            }
            if (!method.isAccessible()) {
                this.checkAccess(handle, true);
            }
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle);
            return handle;
        }

        public MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
            int modifiers = field.getModifiers();
            String fieldName = field.getName();
            Class<?> declaringClass = field.getDeclaringClass();
            Class<?> fieldType = field.getType();
            Map<CacheKey, WeakReference<MethodHandle>> cache = Modifier.isStatic(modifiers) ? HandleCache.getStaticFieldGetterCache(declaringClass) : HandleCache.getFieldGetterCache(declaringClass);
            MethodHandle handle = HandleCache.getFieldFromPerClassCache(cache, fieldName, fieldType);
            if (handle == null) {
                handle = Modifier.isStatic(modifiers) ? new StaticFieldGetterHandle(field) : new FieldGetterHandle(field);
                HandleCache.putFieldInPerClassCache(cache, fieldName, fieldType, handle);
            }
            if (!field.isAccessible()) {
                this.checkAccess(handle, true);
            }
            return handle;
        }

        public MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
            int modifiers = field.getModifiers();
            Class<?> declaringClass = field.getDeclaringClass();
            Class<?> fieldType = field.getType();
            String fieldName = field.getName();
            if (Modifier.isFinal(modifiers) && (!field.isAccessible() || Modifier.isStatic(modifiers))) {
                throw new IllegalAccessException(Msg.getString("K05cf"));
            }
            Map<CacheKey, WeakReference<MethodHandle>> cache = Modifier.isStatic(modifiers) ? HandleCache.getStaticFieldSetterCache(declaringClass) : HandleCache.getFieldSetterCache(declaringClass);
            MethodHandle handle = HandleCache.getFieldFromPerClassCache(cache, fieldName, fieldType);
            if (handle == null) {
                handle = Modifier.isStatic(modifiers) ? new StaticFieldSetterHandle(field) : new FieldSetterHandle(field);
                HandleCache.putFieldInPerClassCache(cache, fieldName, fieldType, handle);
            }
            if (!field.isAccessible()) {
                this.checkAccess(handle, true);
            }
            return handle;
        }

        public MethodHandleInfo revealDirect(MethodHandle target) throws IllegalArgumentException, NullPointerException, SecurityException {
            if (!(target.canRevealDirect() || (target = SecurityFrameInjector.penetrateSecurityFrame(target, this)) != null && target.canRevealDirect())) {
                throw new IllegalArgumentException(Msg.getString("K0584"));
            }
            try {
                this.checkAccess(target, false);
                this.checkSecurity(target.getDefc(), target.getReferenceClass(), target.getModifiers());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            if (target instanceof VarargsCollectorHandle) {
                target = ((VarargsCollectorHandle)target).next;
            }
            return new MethodHandleInfoImpl((PrimitiveHandle)target);
        }

        public String toString() {
            String toString = this.accessClass.getName();
            switch (this.accessMode) {
                case 0: {
                    toString = toString + "/noaccess";
                    break;
                }
                case 1: {
                    toString = toString + "/public";
                    break;
                }
                case 9: {
                    toString = toString + "/package";
                    break;
                }
                case 11: {
                    toString = toString + "/private";
                }
            }
            return toString;
        }

        boolean isWeakenedLookup() {
            return 2 != (this.accessMode & 2);
        }

        void checkSecurity(Class<?> definingClass, Class<?> referenceClass, int modifiers) throws IllegalAccessException {
            SecurityManager secmgr;
            if (this.accessMode == 128) {
                return;
            }
            if (null == definingClass) {
                throw new IllegalAccessException();
            }
            if (this.performSecurityCheck && (secmgr = System.getSecurityManager()) != null) {
                while (definingClass.isArray()) {
                    definingClass = definingClass.getComponentType();
                }
                while (referenceClass.isArray()) {
                    referenceClass = referenceClass.getComponentType();
                }
                VMLangAccess vma = Lookup.getVMLangAccess();
                ClassLoader referenceClassLoader = referenceClass.getClassLoader();
                if (this.isWeakenedLookup() || !Util.doesClassLoaderDescendFrom(referenceClassLoader, this.accessClass.getClassLoader())) {
                    String packageName = vma.getPackageName(referenceClass);
                    secmgr.checkPackageAccess(packageName);
                }
                if (!Modifier.isPublic(modifiers)) {
                    if (vma.getClassloader(definingClass) != vma.getClassloader(this.accessClass)) {
                        secmgr.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
                    }
                    if (definingClass.getClassLoader() != referenceClassLoader && !Util.doesClassLoaderDescendFrom(definingClass.getClassLoader(), this.accessClass.getClassLoader())) {
                        secmgr.checkPackageAccess(vma.getPackageName(definingClass));
                    }
                }
            }
        }

        private static MethodHandle throwExceptionWithMethodTypeAndMessage(Class<? extends Throwable> exceptionClass, MethodType type, String msg) throws IllegalAccessException, NoSuchMethodException {
            MethodHandle thrower = MethodHandles.throwException(type.returnType(), exceptionClass);
            MethodHandle constructor = IMPL_LOOKUP.findConstructor(exceptionClass, MethodType.methodType(Void.TYPE, String.class));
            MethodHandle result = MethodHandles.foldArguments(thrower, constructor.bindTo(msg));
            result = result.asType(MethodType.methodType(type.returnType()));
            result = MethodHandles.dropArguments(result, 0, type.parameterList());
            return result;
        }

        static {
            IMPL_LOOKUP = internalPrivilegedLookup = new Lookup(MethodHandle.class, 128);
        }

        private static final class VMLangAccessGetter {
            public static final VMLangAccess vma = VM.getVMLangAccess();

            private VMLangAccessGetter() {
            }
        }
    }
}

