/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;

public class Util {
    private static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final String SUN_JVM_ARGS = "sun.jvm.args";
    private static final String[] HELP_OPTIONS = new String[]{"-h", "help", "-help", "--help"};

    public static List<String> inStreamToStringList(InputStream inStream) {
        List<String> stdinList;
        try (BufferedReader jpsOutReader = new BufferedReader(new InputStreamReader(inStream));){
            stdinList = jpsOutReader.lines().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        catch (IOException e) {
            stdinList = Collections.emptyList();
        }
        return stdinList;
    }

    static void runCommandAndPrintResult(AttacherDiagnosticsProvider diagProvider, String cmd, String commandName) throws IOException {
        Properties props = diagProvider.executeDiagnosticCommand(cmd);
        DiagnosticProperties.dumpPropertiesIfDebug(commandName + " result:", props);
        String responseString = new DiagnosticProperties(props).printStringResult();
        System.out.print(responseString);
    }

    static void handleCommandException(String vmid, Exception e) {
        String format = "Error getting data from %s";
        String msg = e.getMessage();
        format = null != msg ? (msg.matches("OPENJ9_INCOMPATIBLE_JAVA_VERSION") ? format + ": incompatible target JVM%n" : format + ": %s%n") : format + "%n";
        System.err.printf(format, vmid, msg);
        if (DiagnosticProperties.isDebug) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getTargetInformation(AttachProvider theProvider, VirtualMachineDescriptor vmd, boolean printJvmArguments, boolean noPackageName, boolean printApplicationArguments, StringBuilder outputBuffer) {
        try {
            VirtualMachine theVm = theProvider.attachVirtualMachine(vmd);
            try {
                String jvmArguments;
                Properties vmProperties = theVm.getSystemProperties();
                String theCommand = vmProperties.getProperty(SUN_JAVA_COMMAND, "");
                String[] parts = theCommand.split("\\s+", 2);
                if (noPackageName) {
                    String[] commandString = parts[0];
                    int finalSeparatorPosition = -1;
                    finalSeparatorPosition = commandString.toLowerCase().endsWith(".jar") ? commandString.lastIndexOf(File.pathSeparatorChar) : commandString.lastIndexOf(46);
                    parts[0] = commandString.substring(finalSeparatorPosition + 1);
                }
                if (printApplicationArguments) {
                    for (String p : parts) {
                        outputBuffer.append(' ');
                        outputBuffer.append(p);
                    }
                } else if (parts.length > 0) {
                    outputBuffer.append(' ');
                    outputBuffer.append(parts[0]);
                }
                if (printJvmArguments && null != (jvmArguments = vmProperties.getProperty(SUN_JVM_ARGS)) && !jvmArguments.isEmpty()) {
                    outputBuffer.append(' ').append(jvmArguments);
                }
            }
            finally {
                theVm.detach();
            }
        }
        catch (AttachNotSupportedException | IOException e) {
            outputBuffer.append(" <no information available>");
        }
    }

    static void printProperties(PrintStream out, Properties props) {
        for (Map.Entry<Object, Object> theEntry : props.entrySet()) {
            out.printf("%s=%s%n", theEntry.getKey(), theEntry.getValue());
        }
    }

    static void exitJVMWithReasonAndHelp(String error, String help) {
        if (error != null && !error.isEmpty()) {
            System.out.println(error);
        }
        System.out.printf(help, new Object[0]);
        System.exit(1);
    }

    static boolean checkHelpOption(String option) {
        return Arrays.stream(HELP_OPTIONS).anyMatch(option::equalsIgnoreCase);
    }
}

