/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ffdc;

import com.ibm.nws.ffdc.FFDCConstants;
import com.ibm.nws.ffdc.FFDCHelper;
import com.ibm.nws.ffdc.FFDCSelfIntrospectable;
import com.ibm.nws.ffdc.IncidentStreamImpl;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Vector;

final class IntrospectionLevelMember {
    private static final byte[] svEmptyArrayValue = "{}".getBytes();
    private static final byte[] svPeriodArrayValue = ".".getBytes();
    private static final byte[] svThisArrayValue = "this".getBytes();
    private static final int svPrimitiveArrayMaxOutputLength = 1024;
    private static byte[] svObjectType;
    private static int svSizeOfObjectType;
    private static IntrospectionLevelMember[] svZeroChildrenArray;
    private static HashMap primitiveNames;
    private int ivNumOfBytesWithChildren;
    private int ivNumOfBytesWithoutChildren;
    private byte[] ivObjectDescription;
    private byte[] ivObjectValue;
    private boolean ivIsSelfIntrospectable = false;
    private int ivObjectHashCode;
    private byte[] ivObjectHierarchy;
    protected Object ivMemberObject;
    private IntrospectionLevelMember ivParentMember;
    private IntrospectionLevelMember[] ivChildrenMembers;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.ivMemberObject == null) {
            return false;
        }
        if (object.getClass() != IntrospectionLevelMember.class) {
            return false;
        }
        IntrospectionLevelMember introspectionLevelMember = (IntrospectionLevelMember)object;
        return this.ivMemberObject == introspectionLevelMember.ivMemberObject;
    }

    public int hashCode() {
        return this.ivObjectHashCode;
    }

    IntrospectionLevelMember(IntrospectionLevelMember introspectionLevelMember, Object object, String string) {
        this.ivParentMember = introspectionLevelMember;
        this.ivMemberObject = object;
        if (string != null) {
            this.ivObjectDescription = string.getBytes();
            if (this.ivParentMember != null) {
                boolean bl = string.startsWith("[");
                int n = this.ivObjectDescription.length + introspectionLevelMember.ivObjectHierarchy.length;
                if (!bl) {
                    n += svPeriodArrayValue.length;
                }
                this.ivObjectHierarchy = new byte[n];
                System.arraycopy(this.ivParentMember.ivObjectHierarchy, 0, this.ivObjectHierarchy, 0, this.ivParentMember.ivObjectHierarchy.length);
                if (!bl) {
                    System.arraycopy(svPeriodArrayValue, 0, this.ivObjectHierarchy, this.ivParentMember.ivObjectHierarchy.length, svPeriodArrayValue.length);
                }
                System.arraycopy(this.ivObjectDescription, 0, this.ivObjectHierarchy, this.ivObjectHierarchy.length - this.ivObjectDescription.length, this.ivObjectDescription.length);
            }
        } else if (this.ivParentMember == null) {
            this.ivObjectHierarchy = svThisArrayValue;
            Class<?> clazz = this.ivMemberObject.getClass();
            if (!clazz.isArray()) {
                this.ivObjectDescription = clazz.getName().getBytes();
            } else {
                int n;
                String string2 = clazz.getName();
                String string3 = string2.substring((n = string2.lastIndexOf("[")) + 1);
                string3 = string3.length() > 1 ? string3.substring(1, string3.length() - 1) : (String)primitiveNames.get(string3);
                StringBuffer stringBuffer = new StringBuffer(string3);
                for (int i = 0; i <= n; ++i) {
                    stringBuffer.append("[]");
                }
                this.ivObjectDescription = new String(stringBuffer).getBytes();
            }
        }
        if (this.ivMemberObject == null) {
            this.ivObjectValue = FFDCConstants.svNullValue;
            this.ivChildrenMembers = svZeroChildrenArray;
            this.computeNumberOfBytes();
        } else {
            try {
                this.ivObjectHashCode = System.identityHashCode(this.ivMemberObject);
            }
            catch (Throwable throwable) {
                this.ivObjectHashCode = 0;
            }
            if (this.ivMemberObject instanceof FFDCSelfIntrospectable) {
                this.ivIsSelfIntrospectable = true;
                this.ivObjectValue = null;
            } else {
                try {
                    if (this.ivMemberObject instanceof String || this.ivMemberObject instanceof Number || this.ivMemberObject instanceof Boolean || this.ivMemberObject instanceof Character || this.ivMemberObject instanceof Void) {
                        this.ivObjectValue = this.ivMemberObject.toString().getBytes();
                        this.ivChildrenMembers = svZeroChildrenArray;
                        this.computeNumberOfBytes();
                    } else {
                        this.ivObjectValue = this.identityToString().getBytes();
                    }
                }
                catch (Throwable throwable) {
                    this.ivObjectValue = null;
                }
            }
        }
    }

    private final String identityToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ivMemberObject.getClass().getName());
        stringBuffer.append('@');
        stringBuffer.append(Integer.toHexString(this.ivObjectHashCode));
        return new String(stringBuffer);
    }

    final int getNumberOfSelfIntrospectableMembers() {
        if (!this.ivIsSelfIntrospectable) {
            return 0;
        }
        if (this.ivChildrenMembers == null) {
            return 0;
        }
        return this.ivChildrenMembers.length;
    }

    final int getNumberOfBytes(boolean bl) {
        if (bl) {
            return this.ivNumOfBytesWithChildren;
        }
        return this.ivNumOfBytesWithoutChildren;
    }

    final IntrospectionLevelMember[] getNextMembers(HashMap hashMap) {
        if (this.ivChildrenMembers == null) {
            try {
                Object v = hashMap.get(this);
                if (v != null) {
                    this.ivObjectValue = (byte[])v;
                    this.ivChildrenMembers = svZeroChildrenArray;
                } else if (this.ivMemberObject instanceof Throwable) {
                    this.ivObjectValue = FFDCHelper.throwableToString((Throwable)this.ivMemberObject).getBytes();
                    this.ivChildrenMembers = svZeroChildrenArray;
                    hashMap.put(this, this.ivObjectHierarchy);
                } else if (this.ivIsSelfIntrospectable) {
                    try {
                        String[] stringArray = ((FFDCSelfIntrospectable)this.ivMemberObject).introspectSelf();
                        if (stringArray == null || stringArray.length == 0) {
                            this.ivChildrenMembers = svZeroChildrenArray;
                        } else {
                            int n = stringArray.length;
                            this.ivChildrenMembers = new IntrospectionLevelMember[n];
                            for (int i = n - 1; i >= 0; --i) {
                                this.ivChildrenMembers[i] = new IntrospectionLevelMember(this, stringArray[i], null);
                                this.ivChildrenMembers[i].ivChildrenMembers = svZeroChildrenArray;
                            }
                        }
                        hashMap.put(this, this.ivObjectHierarchy);
                    }
                    catch (Throwable throwable) {
                        this.ivChildrenMembers = svZeroChildrenArray;
                    }
                } else {
                    Class<?> clazz = this.ivMemberObject.getClass();
                    if (clazz.isArray()) {
                        int n = Array.getLength(this.ivMemberObject);
                        if (n == 0) {
                            this.ivObjectValue = svEmptyArrayValue;
                            this.ivChildrenMembers = svZeroChildrenArray;
                        } else if (clazz.getComponentType().isArray()) {
                            Vector vector = this.getArrayMembers(this.ivMemberObject, new StringBuffer());
                            this.ivChildrenMembers = new IntrospectionLevelMember[vector.size()];
                            vector.copyInto(this.ivChildrenMembers);
                        } else if (clazz.getComponentType().isPrimitive()) {
                            int n2;
                            this.ivChildrenMembers = svZeroChildrenArray;
                            String string = clazz.getComponentType().getName();
                            boolean bl = Character.TYPE.getName().equalsIgnoreCase(string);
                            StringBuffer stringBuffer = new StringBuffer(2048);
                            stringBuffer.append('{');
                            Object object = null;
                            for (n2 = 0; n2 < n && n2 < 1024; ++n2) {
                                object = Array.get(this.ivMemberObject, n2);
                                if (!bl && n2 > 0) {
                                    stringBuffer.append(',');
                                }
                                stringBuffer.append(object.toString());
                            }
                            if (n2 < n) {
                                if (!bl) {
                                    stringBuffer.append(',');
                                }
                                stringBuffer.append("...");
                            }
                            StringBuffer stringBuffer2 = new StringBuffer(this.ivObjectDescription.length + 35);
                            stringBuffer2.append(new String(this.ivObjectDescription));
                            stringBuffer2.append('[');
                            stringBuffer2.append(n);
                            stringBuffer2.append(']');
                            this.ivObjectDescription = new String(stringBuffer2).getBytes();
                            this.ivObjectValue = new String(stringBuffer.append('}')).getBytes();
                        } else {
                            this.ivChildrenMembers = new IntrospectionLevelMember[n];
                            for (int i = 0; i < n; ++i) {
                                this.ivChildrenMembers[i] = new IntrospectionLevelMember(this, Array.get(this.ivMemberObject, i), "[" + i + "]");
                            }
                        }
                    } else {
                        Object object;
                        Vector<Field> vector = new Vector<Field>();
                        int n = 0;
                        Class<?> clazz2 = clazz;
                        Field[] fieldArray = null;
                        do {
                            int n3;
                            Class<?> clazz3;
                            if ((n = ((Field[])(object = (Field[])AccessController.doPrivileged(new PrivilegedExceptionAction(clazz3 = clazz2){
                                private final /* synthetic */ Class val$tempClass;
                                {
                                    this.val$tempClass = clazz;
                                }

                                public Object run() throws Exception {
                                    AccessibleObject[] accessibleObjectArray = this.val$tempClass.getDeclaredFields();
                                    if (accessibleObjectArray.length != 0) {
                                        AccessibleObject.setAccessible(accessibleObjectArray, true);
                                    }
                                    return accessibleObjectArray;
                                }
                            }))).length) == 0 || n >= 25) continue;
                            if (vector.isEmpty()) {
                                for (n3 = 0; n3 < n; ++n3) {
                                    vector.add(object[n3]);
                                }
                            } else {
                                fieldArray = new Field[vector.size()];
                                vector.toArray(fieldArray);
                                n3 = fieldArray.length;
                                boolean bl = false;
                                for (int i = 0; i < n; ++i) {
                                    for (int j = 0; j < n3; ++j) {
                                        if (!object[i].getName().equals(fieldArray[j].getName()) || !object[i].getType().equals(fieldArray[j].getType())) continue;
                                        bl = true;
                                    }
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    vector.add(object[i]);
                                }
                            }
                        } while ((clazz2 = clazz2.getSuperclass()) != null);
                        n = vector.size();
                        fieldArray = new Field[n];
                        vector.toArray(fieldArray);
                        this.ivChildrenMembers = new IntrospectionLevelMember[n];
                        for (int i = 0; i < n; ++i) {
                            object = fieldArray[i];
                            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction((Field)object){
                                private final /* synthetic */ Field val$f;
                                {
                                    this.val$f = field;
                                }

                                public Object run() throws Exception {
                                    return this.val$f.get(IntrospectionLevelMember.this.ivMemberObject);
                                }
                            });
                            this.ivChildrenMembers[i] = new IntrospectionLevelMember(this, t, ((Field)object).getName());
                        }
                    }
                    hashMap.put(this, this.ivObjectHierarchy);
                }
                this.computeNumberOfBytes();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.ivIsSelfIntrospectable) {
            return svZeroChildrenArray;
        }
        return this.ivChildrenMembers;
    }

    private void computeNumberOfBytes() {
        if (this.ivParentMember == null) {
            this.ivNumOfBytesWithChildren = svSizeOfObjectType + FFDCConstants.svSizeOfEqualsSign + this.ivObjectDescription.length + FFDCConstants.svSizeOfLineSeparator;
            if (this.ivObjectValue == null) {
                if (!this.ivIsSelfIntrospectable) {
                    this.ivNumOfBytesWithoutChildren = 0;
                } else {
                    this.ivNumOfBytesWithoutChildren = this.ivNumOfBytesWithChildren;
                    int n = this.ivChildrenMembers.length;
                    if (n != 0) {
                        this.ivNumOfBytesWithoutChildren += FFDCConstants.svSizeOfLineSeparator * n;
                        for (int i = 0; i < n; ++i) {
                            this.ivNumOfBytesWithoutChildren += this.ivChildrenMembers[i].ivObjectValue.length;
                        }
                    }
                }
            } else {
                this.ivNumOfBytesWithoutChildren = this.ivNumOfBytesWithChildren + this.ivObjectValue.length + FFDCConstants.svSizeOfLineSeparator;
            }
        } else {
            int n = this.ivNumOfBytesWithChildren = this.ivObjectDescription == null ? 0 : this.ivObjectDescription.length + FFDCConstants.svSizeOfEqualsSign + FFDCConstants.svSizeOfLineSeparator;
            if (this.ivObjectValue == null) {
                if (!this.ivIsSelfIntrospectable) {
                    this.ivNumOfBytesWithoutChildren = 0;
                } else {
                    this.ivNumOfBytesWithoutChildren = this.ivNumOfBytesWithChildren;
                    int n2 = this.ivChildrenMembers.length;
                    if (n2 != 0) {
                        this.ivNumOfBytesWithoutChildren += FFDCConstants.svSizeOfLineSeparator * n2;
                        for (int i = 0; i < n2; ++i) {
                            this.ivNumOfBytesWithoutChildren += this.ivChildrenMembers[i].ivObjectValue.length;
                        }
                    }
                }
            } else {
                this.ivNumOfBytesWithoutChildren = this.ivNumOfBytesWithChildren + this.ivObjectValue.length;
            }
        }
        if (this.ivChildrenMembers.length == 0 || this.ivIsSelfIntrospectable) {
            this.ivNumOfBytesWithChildren = this.ivNumOfBytesWithoutChildren;
        }
    }

    final void printObject(int n, IncidentStreamImpl incidentStreamImpl, int n2) {
        block8: {
            byte[] byArray;
            int n3;
            block9: {
                block6: {
                    block7: {
                        n3 = this.ivChildrenMembers.length;
                        if (n != 0) break block6;
                        incidentStreamImpl.writeLine(svObjectType, this.ivObjectDescription);
                        if ((n2 != 0 || this.ivIsSelfIntrospectable) && n3 != 0) break block7;
                        if (this.ivObjectValue == null) break block8;
                        incidentStreamImpl.writeLine(this.ivObjectValue);
                        break block8;
                    }
                    for (int i = 0; i < n3; ++i) {
                        this.ivChildrenMembers[i].printObject(n + 1, incidentStreamImpl, n2 - 1);
                    }
                    break block8;
                }
                byArray = this.addSpaces(n);
                if ((n2 != 0 || this.ivIsSelfIntrospectable) && n3 != 0) break block9;
                if (this.ivObjectValue == null) break block8;
                if (this.ivObjectDescription != null) {
                    incidentStreamImpl.writeLine(byArray, this.ivObjectValue);
                } else {
                    incidentStreamImpl.writeLine(byArray);
                }
                break block8;
            }
            if (this.ivObjectDescription != null) {
                incidentStreamImpl.writeLine(byArray, FFDCConstants.svZeroSizeByteArray);
            } else {
                incidentStreamImpl.writeLine(byArray);
            }
            for (int i = 0; i < n3; ++i) {
                this.ivChildrenMembers[i].printObject(n + 1, incidentStreamImpl, n2 - 1);
            }
        }
    }

    private byte[] addSpaces(int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        byte[] byArray = new String(stringBuffer).getBytes();
        byte[] byArray2 = null;
        if (this.ivObjectDescription == null) {
            byArray2 = new byte[byArray.length + this.ivObjectValue.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(this.ivObjectValue, 0, byArray2, byArray.length, this.ivObjectValue.length);
        } else {
            byArray2 = new byte[byArray.length + this.ivObjectDescription.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(this.ivObjectDescription, 0, byArray2, byArray.length, this.ivObjectDescription.length);
        }
        return byArray2;
    }

    private Vector getArrayMembers(Object object, StringBuffer stringBuffer) {
        int n = Array.getLength(object);
        Vector<IntrospectionLevelMember> vector = new Vector<IntrospectionLevelMember>();
        if (n == 0) {
            vector.add(new IntrospectionLevelMember(this, "{}", new String(stringBuffer)));
        } else {
            int n2 = stringBuffer.length();
            Object object2 = null;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(i);
                stringBuffer.append(']');
                object2 = Array.get(object, i);
                if (object2 == null || !object2.getClass().isArray()) {
                    vector.add(new IntrospectionLevelMember(this, object2, new String(stringBuffer)));
                } else {
                    vector.addAll(this.getArrayMembers(object2, stringBuffer));
                }
                stringBuffer.setLength(n2);
            }
        }
        return vector;
    }

    static {
        svZeroChildrenArray = new IntrospectionLevelMember[0];
        primitiveNames = new HashMap();
        primitiveNames.put("B", "byte");
        primitiveNames.put("C", "char");
        primitiveNames.put("D", "double");
        primitiveNames.put("F", "float");
        primitiveNames.put("I", "int");
        primitiveNames.put("J", "long");
        primitiveNames.put("S", "short");
        primitiveNames.put("Z", "boolean");
        svObjectType = "Object type".getBytes();
        svSizeOfObjectType = svObjectType.length;
    }
}

