/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.compression;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.compression.WsInflater;
import com.ibm.ws.util.objectpool.CircularObjectPool;
import com.ibm.ws.util.objectpool.ObjectFactory;

public class InflaterPool {
    private static final TraceComponent tc = Tr.register(InflaterPool.class, "Compression", "com.ibm.ws.compression");
    protected static int intUniqueCounter = 0;
    protected static Object oCounterSemaphore = new Object();
    private static InflaterPool instance;
    private CircularObjectPool pool;

    private InflaterPool(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Creating InflaterPool - poolDepth=" + n);
        }
        this.pool = new CircularObjectPool(n, new InflaterFactory());
    }

    private static synchronized void createSingleton() {
        if (null == instance) {
            instance = new InflaterPool(100);
        }
    }

    public static InflaterPool getInstance() {
        if (null == instance) {
            InflaterPool.createSingleton();
        }
        return instance;
    }

    public WsInflater getEntry() {
        return (WsInflater)this.pool.get();
    }

    public void release(Object object) {
        this.pool.put(object);
    }

    private class InflaterFactory
    implements ObjectFactory {
        private InflaterFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create() {
            int n;
            Object object = oCounterSemaphore;
            synchronized (object) {
                n = intUniqueCounter++;
            }
            return new WsInflater(new Integer(n));
        }
    }
}

