/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.FCWsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public abstract class TCPWriteRequestContextImpl
extends TCPBaseRequestContext
implements TCPWriteRequestContext {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl";
    protected static final int SYNC_WRITE = 0;
    protected static final int ASYNC_WRITE = 1;
    private static final long FILE_CHANNEL_SEGMENT_SIZE = 4096000L;
    private TCPWriteCompletedCallback callback;
    private static final TraceComponent tc = Tr.register(TCPWriteRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected TCPWriteRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
        this.setRequestTypeRead(false);
    }

    public long write(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write(" + l + "," + n + ")");
        }
        this.oTCPConnLink.incrementNumWrites();
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.oTCPConnLink.getTCPChannel().totalSyncWrites;
        }
        this.checkForErrors(l, 0, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.oTCPConnLink.getSocketIOChannel().getSocket();
            Tr.event(tc, "write (sync) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
        }
        long l2 = 0L;
        if (n == 0) {
            n = this.config.getInactivityTimeout();
        }
        if (n == -2) {
            this.immediateTimeout();
            return 0L;
        }
        if (this.config.getBlockingChannel() == 1) {
            long l3 = this.writeRegularSocket(l, n);
            return l3;
        }
        l2 = this.isFileChannelWriteToBeDone() ? this.fileChannelWrite(l, n) : this.processSyncWriteRequest(l, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "blocking write returned " + String.valueOf(l2));
        }
        return l2;
    }

    private boolean isFileChannelWriteToBeDone() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isFileChannelWriteToBeDone()");
        }
        if ((this.getBuffer().getStatus() & 2) != 0) {
            if (this.oTCPConnLink.getVirtualConnection().getFileChannelCapable() == 2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "buffer status is STATUS_TRANSFER_TO, and VC is FILE_CHANNEL_CAPABLE_ENABLED");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "isFileChannelWriteToBeDone() returning true");
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "buffer status is STATUS_TRANSFER_TO, but VC is NOT FILE_CHANNEL_CAPABLE_ENABLED");
                Tr.debug(tc, "change buffer status to STATUS_BUFFER");
            }
            int n = this.getBuffer().getStatus();
            n &= 0xFFFFFFFD;
            this.getBuffer().setStatus(n |= 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isFileChannelWriteToBeDone() returning false.  Buffer status: " + this.getBuffer().getStatus());
        }
        return false;
    }

    private long fileChannelWrite(long l, long l2) throws IOException {
        FileChannel fileChannel;
        boolean bl;
        long l3;
        long l4;
        long l5;
        block19: {
            long l6 = 0L;
            l5 = 0L;
            long l7 = 0L;
            long l8 = 0L;
            l4 = 0L;
            l3 = 0L;
            long l9 = 0L;
            long l10 = 0L;
            bl = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "fileChannelWrite(" + l + ", " + l2 + ")");
            }
            SocketChannel socketChannel = this.oTCPConnLink.getSocketIOChannel().getChannel();
            FCWsByteBufferImpl fCWsByteBufferImpl = (FCWsByteBufferImpl)this.getBuffer();
            fileChannel = fCWsByteBufferImpl.getFileChannel();
            l9 = QuickApproxTime.getRef().getApproxTime();
            try {
                l8 = fileChannel.size();
                l4 = fileChannel.position();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "size of FileChannel:" + l8);
                    Tr.debug(tc, "startPosition of FileChannel:" + l4);
                }
                l3 = l == -1L ? l8 - l4 : l;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "minumum data to write:" + l3);
                }
                while (l5 < l3) {
                    l6 = l8 - l5 - l4;
                    if (l6 > 4096000L) {
                        l6 = 4096000L;
                    }
                    l7 = 0L;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "transferTo postion:" + l4 + l5);
                        Tr.debug(tc, "transferTo maxToWrite:" + l6);
                    }
                    if ((l7 = fileChannel.transferTo(l4 + l5, l6, socketChannel)) == 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "yield to avoid looping on 0");
                        }
                        Thread.yield();
                    } else {
                        l5 += l7;
                    }
                    l10 = QuickApproxTime.getRef().getApproxTime();
                    if (l10 - l9 > l2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "ran over timeout time timeout value: " + l2 + " startTime: " + l9 + " currentTime: " + l10);
                        }
                        bl = true;
                        break;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "transferTo bytes Written: " + l7);
                    Tr.debug(tc, "Total Written:" + l5);
                }
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(2) got unexpected IOException doing a FileChannel.transferTo     exception: " + iOException);
                    Tr.debug(tc, "stack trace: " + this.getStackTrace(iOException));
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl.fileChannelWrite", "190", this);
                if (l5 >= l3) break block19;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "fileChannelWrite: IOException Thrown");
                }
                throw iOException;
            }
        }
        fileChannel.position(l4 + l5);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "File Channel Write Complete. Wrote " + l5);
            Tr.debug(tc, "File Channel position set to: " + l4 + l5);
            Tr.debug(tc, "File Channel possibleTimeout set to: " + bl);
        }
        if (bl && l5 < l3) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("Socket operation, used by a File Channel, timed out before it could be completed");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "fileChannelWrite: SocketTimeoutException Thrown");
            }
            throw socketTimeoutException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "fileChannelWrite: TotalWritten: " + l5);
        }
        return l5;
    }

    protected String getStackTrace(Throwable throwable) {
        if (null == throwable) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public abstract long processSyncWriteRequest(long var1, int var3) throws IOException;

    public VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write(" + l + ",..," + bl + "," + n + ")");
        }
        this.oTCPConnLink.incrementNumWrites();
        if (this.config.getDumpStatsInterval() > 0) {
            ++this.oTCPConnLink.getTCPChannel().totalAsyncWrites;
        }
        this.checkForErrors(l, 1, n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Socket socket = this.oTCPConnLink.getSocketIOChannel().getSocket();
            Tr.event(tc, "write (async) requested for local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress());
        }
        return this.writeInternal(l, tCPWriteCompletedCallback, bl, n);
    }

    protected VirtualConnection writeInternal(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "write(" + l + ",..," + bl + "," + n + ")");
        }
        if (n == 0) {
            n = this.config.getInactivityTimeout();
        }
        if (n == -2) {
            this.immediateTimeout();
            return null;
        }
        this.setIOAmount(l);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setWriteCompletedCallback(tCPWriteCompletedCallback);
        this.setForceQueue(bl);
        this.setTimeoutTime(n);
        VirtualConnection virtualConnection = this.processAsyncWriteRequest();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
        return virtualConnection;
    }

    public abstract VirtualConnection processAsyncWriteRequest();

    private long writeRegularSocket(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeRegularSocket(" + l + ")");
        }
        long l2 = 0L;
        int n2 = 0;
        SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
        this.setIOAmount(l);
        socketIOChannel.getSocket().setSoTimeout(n);
        n2 = socketIOChannel.attemptWriteToSocket(this);
        if (n2 == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Throwing IOException, Connection closed: Write failed");
            }
            IOException iOException = new IOException("Connection closed: Write failed");
            throw iOException;
        }
        l2 = this.getIODoneAmount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeRegularSocket returning " + String.valueOf(l2));
        }
        return l2;
    }

    private void checkForErrors(long l, int n, int n2) {
        WsByteBuffer[] wsByteBufferArray;
        String string = null;
        if (this.config.getBlockingChannel() == 1) {
            if (n == 1) {
                string = "Async writes are not valid on blocking (regular socket) channels";
            } else if (n2 == -2) {
                string = "A cancel write,  an immediate timeout of the previous write, can not be done on blocking (regular socket) channels";
            }
        }
        if (n2 == -2) {
            return;
        }
        if (l > maxWriteSize) {
            string = "Number of bytes to requested to write: " + l + " exceeds the maximum allowed for one write";
        }
        if (n == 1 && this.getBuffer() != null && (this.getBuffer().getStatus() & 2) != 0) {
            this.getBuffer().setStatus(1);
        }
        if (this.getBuffers() == null || this.getBuffers().length == 0) {
            string = "No buffer(s) provided for writing data from";
        } else if ((this.getBuffer().getStatus() & 2) == 0) {
            if (this.getBuffers() == null || this.getBuffers().length == 0) {
                string = "No buffer(s) provided for writing data from";
            } else if (l < -1L || l == 0L && n == 1) {
                string = "Number of bytes requested to write: " + l + " is not valid";
            } else {
                wsByteBufferArray = this.getBuffers();
                long l2 = 0L;
                for (int i = 0; i < this.getBuffers().length && wsByteBufferArray[i] != null; ++i) {
                    l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
                }
                if (l > l2 || l2 == 0L) {
                    string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
                }
            }
        } else {
            FCWsByteBufferImpl fCWsByteBufferImpl = (FCWsByteBufferImpl)this.getBuffer();
            try {
                long l3;
                if (fCWsByteBufferImpl.getFileChannel().size() > maxWriteSize) {
                    string = "Number of possible bytes in the File Channel:  " + fCWsByteBufferImpl.getFileChannel().size() + " exceeds maximum allowed: " + maxWriteSize;
                }
                if (l > (long)((int)(l3 = (long)(fCWsByteBufferImpl.limit() - fCWsByteBufferImpl.position())))) {
                    string = "Number of bytes requested: " + l + " exceeds bytes remaining in the FileChannel: " + l3;
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl.checkForErrors", "377", this);
                string = "space remaining in FileChannel cannot be determined.";
            }
        }
        if (string != null) {
            wsByteBufferArray = new IllegalArgumentException(string);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            FFDCFilter.processException((Throwable)wsByteBufferArray, CLASS_NAME, "100", this, this.buildDumpList());
            throw wsByteBufferArray;
        }
    }

    protected void setWriteCompletedCallback(TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        this.callback = tCPWriteCompletedCallback;
    }

    public TCPWriteCompletedCallback getWriteCompletedCallback() {
        return this.callback;
    }

    protected abstract void immediateTimeout();

    public ByteBuffer preProcessOneWriteBuffer() {
        WsByteBufferImpl wsByteBufferImpl = null;
        try {
            wsByteBufferImpl = (WsByteBufferImpl)this.getBuffer();
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing with a buffer which is not a WsByteBufferImpl, may hurt performance");
            }
            return wsByteBufferImpl.getWrappedByteBuffer();
        }
        if (!wsByteBufferImpl.isDirect() && wsByteBufferImpl.hasArray()) {
            wsByteBufferImpl.copyToDirectBuffer();
            return wsByteBufferImpl.oWsBBDirect;
        }
        return wsByteBufferImpl.getWrappedByteBufferNonSafe();
    }

    public ByteBuffer[] preProcessWriteBuffers() {
        int n;
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        boolean bl = false;
        for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
            if (wsByteBufferArray[n].isDirect() || !wsByteBufferArray[n].hasArray()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return this.getByteBufferArray();
        }
        try {
            for (n = 0; n < wsByteBufferArray.length && wsByteBufferArray[n] != null; ++n) {
                ((WsByteBufferImpl)wsByteBufferArray[n]).copyToDirectBuffer();
            }
        }
        catch (ClassCastException classCastException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing with a buffer which is not a WsByteBufferImpl, may hurt performance");
            }
            return this.getByteBufferArray();
        }
        this.setBuffersToDirect(wsByteBufferArray);
        return this.getByteBufferArrayDirect();
    }

    public void postProcessWriteBuffers(long l) {
        if (this.getByteBufferArrayDirect() == null) {
            try {
                if (((WsByteBufferImpl)this.getBuffer()).oWsBBDirect != null) {
                    ((WsByteBufferImpl)this.getBuffer()).setParmsFromDirectBuffer();
                    return;
                }
                return;
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
        WsByteBuffer[] wsByteBufferArray = this.getBuffers();
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            try {
                ((WsByteBufferImpl)wsByteBufferArray[i]).setParmsFromDirectBuffer();
                continue;
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
    }

    public String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("TCPWriteRequestContextImpl FFDC Data");
        String string = super.getFFDCDumpData();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

