/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.ChannelTermination;
import com.ibm.ws.tcp.channel.impl.ConnectChannelSelector;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.NioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.SocketRWChannelSelector;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class WorkQueueManager
implements ChannelTermination {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.WorkQueueManager";
    protected static final TraceComponent tc = Tr.register(WorkQueueManager.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected int maxChannelSelectorsPerFlow = 100;
    protected SocketRWChannelSelector[] readInbound = null;
    protected SocketRWChannelSelector[] readOutbound = null;
    protected SocketRWChannelSelector[] writeInbound = null;
    protected SocketRWChannelSelector[] writeOutbound = null;
    protected ConnectChannelSelector[] connect = null;
    protected int[] readInboundCount = null;
    protected int[] readOutboundCount = null;
    protected int[] writeInboundCount = null;
    protected int[] writeOutboundCount = null;
    protected int[] connectCount = null;
    public static final int CS_READ_INBOUND = 0;
    public static final int CS_READ_OUTBOUND = 1;
    public static final int CS_WRITE_INBOUND = 2;
    public static final int CS_WRITE_OUTBOUND = 3;
    public static final int CS_CONNECTOR = 4;
    protected static int CS_OK = 0;
    protected static int CS_NULL = -1;
    protected static int CS_DELETE_IN_PROGRESS = -2;
    protected Object findOpenIndexSync = new Object();
    protected Object shutdownSync = new Object();
    int maxKeysPerSelector;
    int readInboundSelectorsToStart = 1;
    protected boolean selectorYield;
    protected boolean checkCancel;
    private boolean combineSelectors;
    protected int wakeupOption;
    public static IOException readException = null;
    public static IOException writeException = null;

    protected WorkQueueManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkQueueManager");
        }
        this.maxKeysPerSelector = TCPFactoryConfiguration.getMaxKeysPerSelector();
        this.selectorYield = TCPFactoryConfiguration.getSelectorYield() != 0;
        this.checkCancel = TCPFactoryConfiguration.getCancelKeyOnClose() != 0;
        this.wakeupOption = TCPFactoryConfiguration.getSelectorWakeup();
        this.combineSelectors = TCPFactoryConfiguration.getCombineSelectors() != 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkQueueManager");
        }
    }

    protected void startSelectors(boolean bl) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startSelectors " + bl);
        }
        if (!this.combineSelectors && this.readInbound != null && this.readOutbound != null || this.combineSelectors && this.readInbound != null && this.connect != null) {
            return;
        }
        try {
            if (bl && this.readInbound == null || !bl && this.readInbound == null && this.combineSelectors) {
                int n;
                this.readInbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.writeInbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.readInboundCount = new int[this.maxChannelSelectorsPerFlow];
                this.writeInboundCount = new int[this.maxChannelSelectorsPerFlow];
                for (n = 0; n < this.maxChannelSelectorsPerFlow; ++n) {
                    this.readInboundCount[n] = CS_NULL;
                    this.writeInboundCount[n] = CS_NULL;
                }
                for (n = 0; n < this.readInboundSelectorsToStart; ++n) {
                    this.readInbound[n] = new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, n, 0, this.checkCancel, this.readInboundSelectorsToStart);
                    this.createNewThread(this.readInbound[n], 0, n + 1);
                    this.readInboundCount[n] = CS_OK;
                }
                this.writeInbound[0] = new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, 0, 2, this.checkCancel);
                this.createNewThread(this.writeInbound[0], 2, 1);
                this.writeInboundCount[0] = CS_OK;
                if (!bl) {
                    this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                    this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                    for (n = 0; n < this.maxChannelSelectorsPerFlow; ++n) {
                        this.connectCount[n] = CS_NULL;
                    }
                    this.connect[0] = new ConnectChannelSelector(this.selectorYield, this, 0, 4);
                    this.createNewThread(this.connect[0], 4, 1);
                    this.connectCount[0] = CS_OK;
                }
            } else if (!this.combineSelectors && !bl && this.readOutbound == null) {
                this.readOutbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.writeOutbound = new SocketRWChannelSelector[this.maxChannelSelectorsPerFlow];
                this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                this.readOutboundCount = new int[this.maxChannelSelectorsPerFlow];
                this.writeOutboundCount = new int[this.maxChannelSelectorsPerFlow];
                this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                this.readOutbound[0] = new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, 0, 1, this.checkCancel);
                this.createNewThread(this.readOutbound[0], 1, 1);
                this.writeOutbound[0] = new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, 0, 3, this.checkCancel);
                this.createNewThread(this.writeOutbound[0], 3, 1);
                this.connect[0] = new ConnectChannelSelector(this.selectorYield, this, 0, 4);
                this.createNewThread(this.connect[0], 4, 1);
                for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
                    this.readOutboundCount[i] = CS_NULL;
                    this.writeOutboundCount[i] = CS_NULL;
                    this.connectCount[i] = CS_NULL;
                }
                this.readOutboundCount[0] = CS_OK;
                this.writeOutboundCount[0] = CS_OK;
                this.connectCount[0] = CS_OK;
            } else if (this.combineSelectors && !bl && this.connect == null) {
                this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                this.connect[0] = new ConnectChannelSelector(this.selectorYield, this, 0, 4);
                this.createNewThread(this.connect[0], 4, 1);
                for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
                    this.connectCount[i] = CS_NULL;
                }
                this.connectCount[0] = CS_OK;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "100", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Caught IOException while trying to create selector: " + iOException);
            }
            ChannelException channelException = new ChannelException("Unable to start the TCP Channel", iOException);
            throw channelException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startSelectors");
        }
    }

    protected void updateCount(int n, int n2, int n3) {
        if (n3 == 0) {
            this.readInboundCount[n] = n2;
        } else if (n3 == 1) {
            this.readOutboundCount[n] = n2;
        } else if (n3 == 2) {
            this.writeInboundCount[n] = n2;
        } else if (n3 == 3) {
            this.writeOutboundCount[n] = n2;
        } else if (n3 == 4) {
            this.connectCount[n] = n2;
        }
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("\nWork Queue Manager Data");
        if (this.readInboundCount != null) {
            stringBuffer.append(this.dumpChannelSelectorCounts(this.readInboundCount, "Read Inbound"));
        }
        if (this.readOutboundCount != null) {
            stringBuffer.append(this.dumpChannelSelectorCounts(this.readOutboundCount, "Read Outbound"));
        }
        if (this.writeInboundCount != null) {
            stringBuffer.append(this.dumpChannelSelectorCounts(this.writeInboundCount, "Write Inbound"));
        }
        if (this.writeOutboundCount != null) {
            stringBuffer.append(this.dumpChannelSelectorCounts(this.writeOutboundCount, "Write Outbound"));
        }
        if (this.connectCount != null) {
            stringBuffer.append(this.dumpChannelSelectorCounts(this.connectCount, "Connect"));
        }
        return stringBuffer.toString();
    }

    private String dumpChannelSelectorCounts(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer("Channel Selector Counts for TCP Channel Type:  " + string);
        for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
            if (nArray[i] == CS_NULL) continue;
            stringBuffer.append("channel Index: " + i + " Count: " + nArray[i]);
        }
        return stringBuffer.toString();
    }

    protected VirtualConnection processWork(TCPBaseRequestContext tCPBaseRequestContext, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processWork");
        }
        TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
        VirtualConnection virtualConnection = tCPConnLink.getVirtualConnection();
        if (n != 1 && tCPBaseRequestContext.isRequestTypeRead()) {
            ((TCPReadRequestContextImpl)tCPBaseRequestContext).setJITAllocateAction(false);
        }
        boolean bl = this.attemptIO(tCPBaseRequestContext, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processWork");
        }
        if (bl) {
            return virtualConnection;
        }
        return null;
    }

    public void terminate() {
        this.shutdown();
    }

    protected void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        if (this.readInboundCount != null) {
            this.shutdownFlow(this.readInboundCount, this.readInbound);
        }
        if (this.readOutboundCount != null) {
            this.shutdownFlow(this.readOutboundCount, this.readOutbound);
        }
        if (this.writeInboundCount != null) {
            this.shutdownFlow(this.writeInboundCount, this.writeInbound);
        }
        if (this.writeOutboundCount != null) {
            this.shutdownFlow(this.writeOutboundCount, this.writeOutbound);
        }
        if (this.connectCount != null) {
            this.shutdownFlow(this.connectCount, this.connect);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownFlow(int[] nArray, ChannelSelector[] channelSelectorArray) {
        for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
            Object object = this.shutdownSync;
            synchronized (object) {
                if (nArray[i] != CS_NULL) {
                    channelSelectorArray[i].shutDown();
                }
                continue;
            }
        }
    }

    private void queueIO(TCPBaseRequestContext tCPBaseRequestContext) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "queueIO");
        }
        TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
        SocketIOChannel socketIOChannel = tCPConnLink.getSocketIOChannel();
        ChannelSelector channelSelector = null;
        channelSelector = tCPBaseRequestContext.isRequestTypeRead() ? ((NioSocketIOChannel)socketIOChannel).getChannelSelectorRead() : ((NioSocketIOChannel)socketIOChannel).getChannelSelectorWrite();
        if (channelSelector != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "selector not null, adding work to selector");
            }
            channelSelector.addWork(tCPBaseRequestContext);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "selector null, adding to work queue");
            }
            if (tCPBaseRequestContext.isRequestTypeRead()) {
                if (tCPConnLink.getConfig().isInbound() || this.combineSelectors) {
                    this.moveIntoPosition(this.readInboundCount, this.readInbound, tCPBaseRequestContext, 0);
                } else {
                    this.moveIntoPosition(this.readOutboundCount, this.readOutbound, tCPBaseRequestContext, 1);
                }
            } else if (tCPConnLink.getConfig().isInbound() || this.combineSelectors) {
                this.moveIntoPosition(this.writeInboundCount, this.writeInbound, tCPBaseRequestContext, 2);
            } else {
                this.moveIntoPosition(this.writeOutboundCount, this.writeOutbound, tCPBaseRequestContext, 3);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "queueIO");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveIntoPosition(int[] nArray, ChannelSelector[] channelSelectorArray, Object object, int n) throws IOException {
        int n2;
        for (n2 = 0; n2 < this.maxChannelSelectorsPerFlow; ++n2) {
            if (nArray[n2] < CS_OK || nArray[n2] >= this.maxKeysPerSelector) continue;
            channelSelectorArray[n2].addWork(object);
            return;
        }
        n2 = 0;
        Object object2 = this.findOpenIndexSync;
        synchronized (object2) {
            for (n2 = 0; n2 < this.maxChannelSelectorsPerFlow && nArray[n2] != CS_NULL; ++n2) {
            }
            if (n2 < this.maxChannelSelectorsPerFlow) {
                try {
                    channelSelectorArray[n2] = n == 4 ? new ConnectChannelSelector(this.selectorYield, this, n2, 4) : (n == 0 ? new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, n2, n, this.checkCancel, this.readInboundSelectorsToStart) : new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, n2, n, this.checkCancel));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "120", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught IOException...throwing RuntimeException");
                    }
                    throw new RuntimeException(iOException);
                }
                this.createNewThread(channelSelectorArray[n2], n, n2 + 1);
                nArray[n2] = CS_OK;
                channelSelectorArray[n2].addWork(object);
            } else {
                String string = "";
                if (n == 0) {
                    string = "readInbound";
                } else if (n == 1) {
                    string = "readOutbound";
                } else if (n == 2) {
                    string = "writeInbound";
                } else if (n == 3) {
                    string = "writeOutbound";
                } else if (n == 4) {
                    string = "connect";
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "All selectors full, can not handle new request on TCP Channel type: " + string);
                    IOException iOException = new IOException("All selectors full, can not handle new request on TCP Channel type: " + string);
                    FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "130", this);
                    throw iOException;
                }
            }
        }
    }

    private void requestComplete(TCPBaseRequestContext tCPBaseRequestContext, IOException iOException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requestComplete");
        }
        TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
        if (tCPBaseRequestContext.blockedThread) {
            if (iOException != null) {
                tCPBaseRequestContext.blockingIOError = iOException;
            }
            tCPBaseRequestContext.blockWait.simpleNotify();
        } else if (tCPBaseRequestContext.isRequestTypeRead()) {
            TCPReadCompletedCallback tCPReadCompletedCallback = ((TCPReadRequestContextImpl)tCPBaseRequestContext).getReadCompletedCallback();
            if (tCPReadCompletedCallback != null) {
                if (iOException != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling cc.error callback");
                    }
                    tCPReadCompletedCallback.error(tCPConnLink.getVirtualConnection(), (TCPReadRequestContext)((Object)tCPBaseRequestContext), iOException);
                } else if (!tCPConnLink.getTCPChannel().getStopFlag()) {
                    tCPReadCompletedCallback.complete(tCPConnLink.getVirtualConnection(), (TCPReadRequestContextImpl)tCPBaseRequestContext);
                }
            }
        } else {
            TCPWriteCompletedCallback tCPWriteCompletedCallback = ((TCPWriteRequestContextImpl)tCPBaseRequestContext).getWriteCompletedCallback();
            if (tCPWriteCompletedCallback != null) {
                if (iOException != null) {
                    tCPWriteCompletedCallback.error(tCPConnLink.getVirtualConnection(), (TCPWriteRequestContext)((Object)tCPBaseRequestContext), iOException);
                } else if (!tCPConnLink.getTCPChannel().getStopFlag()) {
                    tCPWriteCompletedCallback.complete(tCPConnLink.getVirtualConnection(), (TCPWriteRequestContext)((Object)tCPBaseRequestContext));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "requestComplete");
        }
    }

    protected boolean attemptIO(TCPBaseRequestContext tCPBaseRequestContext, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptIO");
        }
        int n = 0;
        TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
        try {
            tCPBaseRequestContext.setLastIOAmt(0L);
            if (tCPBaseRequestContext.isRequestTypeRead()) {
                if (!tCPBaseRequestContext.isForceQueue() && (n = tCPConnLink.getSocketIOChannel().attemptReadFromSocket(tCPBaseRequestContext, bl)) == 1 && !bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "attemptIO");
                    }
                    return true;
                }
                if (n == 1) {
                    this.requestComplete(tCPBaseRequestContext, null);
                } else if (n == 0) {
                    if (!tCPBaseRequestContext.isForceQueue() && tCPBaseRequestContext.config.getDumpStatsInterval() > 0) {
                        if (tCPBaseRequestContext.blockedThread) {
                            ++tCPBaseRequestContext.getTCPConnLink().getTCPChannel().totalPartialSyncReads;
                        } else if (!bl && tCPBaseRequestContext.getLastIOAmt() == 0L) {
                            ++tCPBaseRequestContext.getTCPConnLink().getTCPChannel().totalAsyncReadRetries;
                        } else {
                            ++tCPBaseRequestContext.getTCPConnLink().getTCPChannel().totalPartialAsyncReads;
                        }
                    }
                    tCPBaseRequestContext.setForceQueue(false);
                    this.queueIO(tCPBaseRequestContext);
                }
            } else {
                if (!tCPBaseRequestContext.isForceQueue() && (n = tCPConnLink.getSocketIOChannel().attemptWriteToSocket(tCPBaseRequestContext)) == 1 && !bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "attemptIO");
                    }
                    return true;
                }
                if (n == 1) {
                    this.requestComplete(tCPBaseRequestContext, null);
                } else if (n == 0) {
                    if (!tCPBaseRequestContext.isForceQueue() && tCPBaseRequestContext.config.getDumpStatsInterval() > 0) {
                        if (tCPBaseRequestContext.blockedThread) {
                            ++tCPBaseRequestContext.getTCPConnLink().getTCPChannel().totalPartialSyncWrites;
                        } else if (!bl && tCPBaseRequestContext.getLastIOAmt() == 0L) {
                            ++tCPBaseRequestContext.getTCPConnLink().getTCPChannel().totalAsyncWriteRetries;
                        } else {
                            ++tCPBaseRequestContext.getTCPConnLink().getTCPChannel().totalPartialAsyncWrites;
                        }
                    }
                    tCPBaseRequestContext.setForceQueue(false);
                    this.queueIO(tCPBaseRequestContext);
                }
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "IOException while doing IO requested on local: " + tCPConnLink.getSocketIOChannel().getSocket().getLocalSocketAddress() + " remote: " + tCPConnLink.getSocketIOChannel().getSocket().getRemoteSocketAddress());
                Tr.event(tc, "Exception is: " + iOException);
            }
            if (tCPBaseRequestContext.isRequestTypeRead() && ((TCPReadRequestContextImpl)tCPBaseRequestContext).getJITAllocateAction()) {
                tCPBaseRequestContext.getBuffer().release();
                tCPBaseRequestContext.setBuffer(null);
                ((TCPReadRequestContextImpl)tCPBaseRequestContext).setJITAllocateAction(false);
            }
            this.requestComplete(tCPBaseRequestContext, iOException);
        }
        if (n == -1) {
            IOException iOException = null;
            if (tCPBaseRequestContext.isRequestTypeRead()) {
                if (readException == null) {
                    readException = new IOException("Connection close: Read failed.  Possible end of stream encountered. ");
                }
                iOException = readException;
            } else {
                if (writeException == null) {
                    writeException = new IOException("Connection closed: Write failed");
                }
                iOException = writeException;
            }
            this.requestComplete(tCPBaseRequestContext, iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptIO");
        }
        return false;
    }

    protected boolean dispatcher(TCPBaseRequestContext tCPBaseRequestContext, IOException iOException) {
        if (tCPBaseRequestContext.blockedThread) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "dispatcher notifying waiting synch request ");
            }
            if (iOException != null) {
                tCPBaseRequestContext.blockingIOError = iOException;
            }
            tCPBaseRequestContext.blockWait.simpleNotify();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "dispatcher handing off asynch work to thread pool");
            }
            Worker worker = new Worker(tCPBaseRequestContext, iOException);
            int n = tCPBaseRequestContext.oTCPConnLink.getThreadPool().execute(worker);
            if (n != 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "dispatcher could not get thread from ThreadPool " + tCPBaseRequestContext.getTCPConnLink().getConfig().getThreadPoolName() + ", error code: " + n);
                }
                TCPChannel tCPChannel = tCPBaseRequestContext.getTCPConnLink().getTCPChannel();
                long l = QuickApproxTime.getRef().getApproxTime();
                if (l > tCPChannel.getLastThreadPoolErrorTime() + 600000L) {
                    Tr.warning(tc, "THREAD_DISPATCH_FAILED", new Object[]{tCPChannel.getExternalName(), tCPChannel.getConfig().getThreadPoolName(), Integer.toString(n)});
                    tCPChannel.setLastThreadPoolErrorTime(l);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Additional Thread Pool infomation: " + tCPBaseRequestContext.oTCPConnLink.getThreadPool().toString());
                    }
                }
                Thread.yield();
                return false;
            }
        }
        return true;
    }

    protected void queueConnectForSelector(ConnectionManager.ConnectInfo connectInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "queueConnectForSelector");
        }
        try {
            this.moveIntoPosition(this.connectCount, this.connect, connectInfo, 4);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "140", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught IOException...throwing RuntimeException");
            }
            throw new RuntimeException(iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "queueConnectForSelector");
        }
    }

    protected void createNewThread(ChannelSelector channelSelector, int n, int n2) {
        StartPrivilegedThread startPrivilegedThread = new StartPrivilegedThread(channelSelector, n, n2);
        AccessController.doPrivileged(startPrivilegedThread);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean attemptConnectWork(ConnectionManager.ConnectInfo var1_1) {
        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEntryEnabled()) {
            Tr.entry(WorkQueueManager.tc, "attemptConnectWork");
        }
        var2_2 = true;
        switch (var1_1.action) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                    Tr.event(WorkQueueManager.tc, "Finish_connection case for, local: " + var1_1.localAddress + " remote: " + var1_1.remoteAddress);
                }
                if (!var1_1.channel.isConnectionPending()) ** GOTO lbl35
                try {
                    var3_3 = var1_1.channel.finishConnect();
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                        Tr.event(WorkQueueManager.tc, "Finishconnect returned " + var3_3 + " for, local: " + var1_1.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + var1_1.ioSocket.getSocket().getRemoteSocketAddress());
                    }
                    if (!var3_3) {
                        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                            Tr.event(WorkQueueManager.tc, "FinishConnect returned false, retrying");
                        }
                        this.queueConnectForSelector(var1_1);
                        var2_2 = false;
                        break;
                    }
                    if (!var1_1.channel.isConnected()) {
                        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                            Tr.event(WorkQueueManager.tc, "FinishConnect returned true, but not connected");
                        }
                        var4_6 = new IOException("Connection could not be established");
                        var1_1.setError(var4_6);
                        var1_1.tcpConnLink.connectFailed(var4_6);
                    }
                    ** GOTO lbl40
                }
                catch (IOException var3_4) {
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                        Tr.event(WorkQueueManager.tc, "SocketChannel connect failed, local: " + var1_1.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + var1_1.ioSocket.getSocket().getRemoteSocketAddress());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isDebugEnabled()) {
                        Tr.debug(WorkQueueManager.tc, "SocketChannel.finishConnect Exception Caught: " + var3_4);
                    }
                    var1_1.setError(var3_4);
                    var1_1.tcpConnLink.connectFailed(var3_4);
                }
                break;
lbl35:
                // 1 sources

                if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                    Tr.event(WorkQueueManager.tc, "Connection got selected, but isConnectionPending returned false");
                }
                var2_2 = false;
                this.queueConnectForSelector(var1_1);
                break;
lbl40:
                // 1 sources

                if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                    Tr.event(WorkQueueManager.tc, "SocketChannel connected, local: " + var1_1.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + var1_1.ioSocket.getSocket().getRemoteSocketAddress());
                }
                var1_1.setFinishComplete();
                try {
                    var1_1.tcpConnLink.connectComplete(var1_1.ioSocket);
                }
                catch (IOException var3_5) {
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEventEnabled()) {
                        Tr.event(WorkQueueManager.tc, "SocketChannel connect failed, local: " + var1_1.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + var1_1.ioSocket.getSocket().getRemoteSocketAddress());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isDebugEnabled()) {
                        Tr.debug(WorkQueueManager.tc, "SocketChannel.finishConnect Exception Caught: " + var3_5);
                    }
                    var1_1.setError(var3_5);
                    var1_1.tcpConnLink.connectFailed(var3_5);
                }
                break;
            }
            case 2: {
                var1_1.tcpConnLink.connectFailed(var1_1.errorException);
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !WorkQueueManager.tc.isEventEnabled()) break;
                Tr.event(WorkQueueManager.tc, "Should never get here - default.");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && WorkQueueManager.tc.isEntryEnabled()) {
            Tr.exit(WorkQueueManager.tc, "attemptConnectWork returning " + var2_2);
        }
        return var2_2;
    }

    void workerRun(TCPBaseRequestContext tCPBaseRequestContext, IOException iOException) {
        TCPReadRequestContextImpl tCPReadRequestContextImpl = null;
        TCPWriteRequestContextImpl tCPWriteRequestContextImpl = null;
        if (tCPBaseRequestContext != null) {
            if (iOException == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Worker thread processing IO request for channel: " + tCPBaseRequestContext.getTCPConnLink().getSocketIOChannel().getChannel());
                }
                this.attemptIO(tCPBaseRequestContext, true);
            } else if (tCPBaseRequestContext.isRequestTypeRead()) {
                tCPReadRequestContextImpl = (TCPReadRequestContextImpl)tCPBaseRequestContext;
                if (tCPReadRequestContextImpl.getReadCompletedCallback() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Worker thread processing read error: " + iOException + ", for channel: " + tCPBaseRequestContext.getTCPConnLink().getSocketIOChannel().getChannel());
                    }
                    tCPReadRequestContextImpl.getReadCompletedCallback().error(tCPReadRequestContextImpl.getTCPConnLink().getVirtualConnection(), tCPReadRequestContextImpl, iOException);
                }
            } else {
                tCPWriteRequestContextImpl = (TCPWriteRequestContextImpl)tCPBaseRequestContext;
                if (tCPWriteRequestContextImpl.getWriteCompletedCallback() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Worker thread processing write error: " + iOException + ", for channel: " + tCPBaseRequestContext.getTCPConnLink().getSocketIOChannel().getChannel());
                    }
                    tCPWriteRequestContextImpl.getWriteCompletedCallback().error(tCPWriteRequestContextImpl.getTCPConnLink().getVirtualConnection(), tCPWriteRequestContextImpl, iOException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unit of work done");
        }
    }

    void workerRun(ConnectionManager.ConnectInfo connectInfo) {
        if (connectInfo != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Worker thread processing connect request");
            }
            this.attemptConnectWork(connectInfo);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Unit of work done");
        }
    }

    protected boolean connectDispatcher(ConnectionManager.ConnectInfo connectInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectDispatcher");
        }
        if (connectInfo.getSyncObject() != null) {
            connectInfo.getSyncObject().simpleNotify();
        } else {
            Worker worker = new Worker(connectInfo);
            int n = connectInfo.tcpConnLink.getThreadPool().execute(worker);
            if (n != 0) {
                Tr.event(tc, "connectDipatcher could not dispatch a thread from Thread Pool: " + connectInfo.tcpConnLink.getThreadPool() + ", error code: " + n);
                return false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectDispatcher");
        }
        return true;
    }

    class StartPrivilegedThread
    implements PrivilegedAction {
        ChannelSelector sr;
        int threadType;
        int number;

        public StartPrivilegedThread(ChannelSelector channelSelector, int n, int n2) {
            this.sr = channelSelector;
            this.threadType = n;
            this.number = n2;
        }

        public void setParms(ChannelSelector channelSelector, int n, int n2) {
            this.sr = channelSelector;
            this.threadType = n;
            this.number = n2;
        }

        public Object run() {
            String string = null;
            if (this.threadType == 0) {
                string = "Inbound Read Selector";
            } else if (this.threadType == 1) {
                string = "Outbound Read Selector";
            } else if (this.threadType == 2) {
                string = "Inbound Write Selector";
            } else if (this.threadType == 3) {
                string = "Outbound Write Selector";
            } else if (this.threadType == 4) {
                string = "Connect Selector";
            }
            Thread thread = new Thread(this.sr);
            thread.setName(string + "." + this.number);
            thread.setDaemon(true);
            thread.start();
            return null;
        }
    }

    protected class Worker
    implements Runnable {
        TCPBaseRequestContext req = null;
        ConnectionManager.ConnectInfo connInfo = null;
        IOException ioe = null;

        protected Worker(TCPBaseRequestContext tCPBaseRequestContext, IOException iOException) {
            this.req = tCPBaseRequestContext;
            this.ioe = iOException;
        }

        protected Worker(ConnectionManager.ConnectInfo connectInfo) {
            this.connInfo = connectInfo;
        }

        public void run() {
            if (this.req != null) {
                WorkQueueManager.this.workerRun(this.req, this.ioe);
            } else if (this.connInfo != null) {
                WorkQueueManager.this.workerRun(this.connInfo);
            }
        }
    }
}

