/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.Serializable;
import java.lang.invoke.AbstractValidatingLambdaMetafactory;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ProxyClassesDumper;
import java.lang.invoke.TypeConvertingMethodAdapter;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.BytecodeDescriptor;
import sun.misc.Unsafe;
import sun.security.action.GetPropertyAction;

final class InnerClassLambdaMetafactory
extends AbstractValidatingLambdaMetafactory {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final int CLASSFILE_VERSION = 52;
    private static final String METHOD_DESCRIPTOR_VOID = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String NAME_CTOR = "<init>";
    private static final String NAME_FACTORY = "get$Lambda";
    private static final String NAME_SERIALIZED_LAMBDA = "java/lang/invoke/SerializedLambda";
    private static final String NAME_NOT_SERIALIZABLE_EXCEPTION = "java/io/NotSerializableException";
    private static final String DESCR_METHOD_WRITE_REPLACE = "()Ljava/lang/Object;";
    private static final String DESCR_METHOD_WRITE_OBJECT = "(Ljava/io/ObjectOutputStream;)V";
    private static final String DESCR_METHOD_READ_OBJECT = "(Ljava/io/ObjectInputStream;)V";
    private static final String NAME_METHOD_WRITE_REPLACE = "writeReplace";
    private static final String NAME_METHOD_READ_OBJECT = "readObject";
    private static final String NAME_METHOD_WRITE_OBJECT = "writeObject";
    private static final String DESCR_CTOR_SERIALIZED_LAMBDA = MethodType.methodType(Void.TYPE, Class.class, String.class, String.class, String.class, Integer.TYPE, String.class, String.class, String.class, String.class, Object[].class).toMethodDescriptorString();
    private static final String DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION = MethodType.methodType(Void.TYPE, String.class).toMethodDescriptorString();
    private static final String[] SER_HOSTILE_EXCEPTIONS = new String[]{"java/io/NotSerializableException"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ProxyClassesDumper dumper;
    private final String implMethodClassName;
    private final String implMethodName;
    private final String implMethodDesc;
    private final Class<?> implMethodReturnClass;
    private final MethodType constructorType;
    private final ClassWriter cw;
    private final String[] argNames;
    private final String[] argDescs;
    private final String lambdaClassName;

    public InnerClassLambdaMetafactory(MethodHandles.Lookup lookup, MethodType methodType, String string, MethodType methodType2, MethodHandle methodHandle, MethodType methodType3, boolean bl, Class<?>[] classArray, MethodType[] methodTypeArray) throws LambdaConversionException {
        super(lookup, methodType, string, methodType2, methodHandle, methodType3, bl, classArray, methodTypeArray);
        this.implMethodClassName = this.implDefiningClass.getName().replace('.', '/');
        this.implMethodName = this.implInfo.getName();
        this.implMethodDesc = this.implMethodType.toMethodDescriptorString();
        this.implMethodReturnClass = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        this.constructorType = methodType.changeReturnType(Void.TYPE);
        this.lambdaClassName = this.targetClass.getName().replace('.', '/') + "$$Lambda$" + counter.incrementAndGet();
        this.cw = new ClassWriter(1);
        int n = methodType.parameterCount();
        if (n > 0) {
            this.argNames = new String[n];
            this.argDescs = new String[n];
            for (int i = 0; i < n; ++i) {
                this.argNames[i] = "arg$" + (i + 1);
                this.argDescs[i] = BytecodeDescriptor.unparse(methodType.parameterType(i));
            }
        } else {
            this.argDescs = EMPTY_STRING_ARRAY;
            this.argNames = EMPTY_STRING_ARRAY;
        }
    }

    @Override
    CallSite buildCallSite() throws LambdaConversionException {
        final Class<?> clazz = this.spinInnerClass();
        if (this.invokedType.parameterCount() == 0) {
            Constructor<?>[] constructorArray = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

                @Override
                public Constructor<?>[] run() {
                    Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                    if (constructorArray.length == 1) {
                        constructorArray[0].setAccessible(true);
                    }
                    return constructorArray;
                }
            });
            if (constructorArray.length != 1) {
                throw new LambdaConversionException("Expected one lambda constructor for " + clazz.getCanonicalName() + ", got " + constructorArray.length);
            }
            try {
                Object obj = constructorArray[0].newInstance(new Object[0]);
                return new ConstantCallSite(MethodHandles.constant(this.samBase, obj));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new LambdaConversionException("Exception instantiating lambda object", reflectiveOperationException);
            }
        }
        try {
            UNSAFE.ensureClassInitialized(clazz);
            return new ConstantCallSite(MethodHandles.Lookup.IMPL_LOOKUP.findStatic(clazz, NAME_FACTORY, this.invokedType));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new LambdaConversionException("Exception finding constructor", reflectiveOperationException);
        }
    }

    private Class<?> spinInnerClass() throws LambdaConversionException {
        String[] stringArray;
        boolean bl;
        String string = this.samBase.getName().replace('.', '/');
        boolean bl2 = bl = !this.isSerializable && Serializable.class.isAssignableFrom(this.samBase);
        if (this.markerInterfaces.length == 0) {
            stringArray = new String[]{string};
        } else {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.markerInterfaces.length + 1);
            linkedHashSet.add(string);
            for (Class clazz : this.markerInterfaces) {
                linkedHashSet.add(clazz.getName().replace('.', '/'));
                bl |= !this.isSerializable && Serializable.class.isAssignableFrom(clazz);
            }
            stringArray = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
        this.cw.visit(52, 4144, this.lambdaClassName, null, JAVA_LANG_OBJECT, stringArray);
        for (int i = 0; i < this.argDescs.length; ++i) {
            FieldVisitor fieldVisitor = this.cw.visitField(18, this.argNames[i], this.argDescs[i], null, null);
            fieldVisitor.visitEnd();
        }
        this.generateConstructor();
        if (this.invokedType.parameterCount() != 0) {
            this.generateFactory();
        }
        MethodVisitor methodVisitor = this.cw.visitMethod(1, this.samMethodName, this.samMethodType.toMethodDescriptorString(), null, null);
        methodVisitor.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        new ForwardingMethodGenerator(methodVisitor).generate(this.samMethodType);
        if (this.additionalBridges != null) {
            for (MethodType methodType : this.additionalBridges) {
                methodVisitor = this.cw.visitMethod(65, this.samMethodName, methodType.toMethodDescriptorString(), null, null);
                methodVisitor.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
                new ForwardingMethodGenerator(methodVisitor).generate(methodType);
            }
        }
        if (this.isSerializable) {
            this.generateSerializationFriendlyMethods();
        } else if (bl) {
            this.generateSerializationHostileMethods();
        }
        this.cw.visitEnd();
        final byte[] byArray = this.cw.toByteArray();
        if (dumper != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    dumper.dumpClass(InnerClassLambdaMetafactory.this.lambdaClassName, byArray);
                    return null;
                }
            });
        }
        return UNSAFE.defineAnonymousClass(this.targetClass, byArray, null);
    }

    private void generateFactory() {
        MethodVisitor methodVisitor = this.cw.visitMethod(10, NAME_FACTORY, this.invokedType.toMethodDescriptorString(), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, this.lambdaClassName);
        methodVisitor.visitInsn(89);
        int n = this.invokedType.parameterCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TypeDescriptor.OfField ofField = this.invokedType.parameterType(i);
            methodVisitor.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(ofField), n2);
            n2 += InnerClassLambdaMetafactory.getParameterSize(ofField);
        }
        methodVisitor.visitMethodInsn(183, this.lambdaClassName, NAME_CTOR, this.constructorType.toMethodDescriptorString(), false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    private void generateConstructor() {
        MethodVisitor methodVisitor = this.cw.visitMethod(2, NAME_CTOR, this.constructorType.toMethodDescriptorString(), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, JAVA_LANG_OBJECT, NAME_CTOR, METHOD_DESCRIPTOR_VOID, false);
        int n = this.invokedType.parameterCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            methodVisitor.visitVarInsn(25, 0);
            TypeDescriptor.OfField ofField = this.invokedType.parameterType(i);
            methodVisitor.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(ofField), n2 + 1);
            n2 += InnerClassLambdaMetafactory.getParameterSize(ofField);
            methodVisitor.visitFieldInsn(181, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    private void generateSerializationFriendlyMethods() {
        TypeConvertingMethodAdapter typeConvertingMethodAdapter = new TypeConvertingMethodAdapter(this.cw.visitMethod(18, NAME_METHOD_WRITE_REPLACE, DESCR_METHOD_WRITE_REPLACE, null, null));
        typeConvertingMethodAdapter.visitCode();
        typeConvertingMethodAdapter.visitTypeInsn(187, NAME_SERIALIZED_LAMBDA);
        typeConvertingMethodAdapter.visitInsn(89);
        typeConvertingMethodAdapter.visitLdcInsn(Type.getType(this.targetClass));
        typeConvertingMethodAdapter.visitLdcInsn(((Class)this.invokedType.returnType()).getName().replace('.', '/'));
        typeConvertingMethodAdapter.visitLdcInsn(this.samMethodName);
        typeConvertingMethodAdapter.visitLdcInsn(this.samMethodType.toMethodDescriptorString());
        typeConvertingMethodAdapter.visitLdcInsn(this.implInfo.getReferenceKind());
        typeConvertingMethodAdapter.visitLdcInsn(this.implInfo.getDeclaringClass().getName().replace('.', '/'));
        typeConvertingMethodAdapter.visitLdcInsn(this.implInfo.getName());
        typeConvertingMethodAdapter.visitLdcInsn(this.implInfo.getMethodType().toMethodDescriptorString());
        typeConvertingMethodAdapter.visitLdcInsn(this.instantiatedMethodType.toMethodDescriptorString());
        typeConvertingMethodAdapter.iconst(this.argDescs.length);
        typeConvertingMethodAdapter.visitTypeInsn(189, JAVA_LANG_OBJECT);
        for (int i = 0; i < this.argDescs.length; ++i) {
            typeConvertingMethodAdapter.visitInsn(89);
            typeConvertingMethodAdapter.iconst(i);
            typeConvertingMethodAdapter.visitVarInsn(25, 0);
            typeConvertingMethodAdapter.visitFieldInsn(180, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
            typeConvertingMethodAdapter.boxIfTypePrimitive(Type.getType(this.argDescs[i]));
            typeConvertingMethodAdapter.visitInsn(83);
        }
        typeConvertingMethodAdapter.visitMethodInsn(183, NAME_SERIALIZED_LAMBDA, NAME_CTOR, DESCR_CTOR_SERIALIZED_LAMBDA, false);
        typeConvertingMethodAdapter.visitInsn(176);
        typeConvertingMethodAdapter.visitMaxs(-1, -1);
        typeConvertingMethodAdapter.visitEnd();
    }

    private void generateSerializationHostileMethods() {
        MethodVisitor methodVisitor = this.cw.visitMethod(18, NAME_METHOD_WRITE_OBJECT, DESCR_METHOD_WRITE_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Non-serializable lambda");
        methodVisitor.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION, false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        methodVisitor = this.cw.visitMethod(18, NAME_METHOD_READ_OBJECT, DESCR_METHOD_READ_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Non-serializable lambda");
        methodVisitor.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION, false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    static int getParameterSize(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    static int getLoadOpcode(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            throw new InternalError("Unexpected void type of load opcode");
        }
        return 21 + InnerClassLambdaMetafactory.getOpcodeOffset(clazz);
    }

    static int getReturnOpcode(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return 177;
        }
        return 172 + InnerClassLambdaMetafactory.getOpcodeOffset(clazz);
    }

    private static int getOpcodeOffset(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Long.TYPE) {
                return 1;
            }
            if (clazz == Float.TYPE) {
                return 2;
            }
            if (clazz == Double.TYPE) {
                return 3;
            }
            return 0;
        }
        return 4;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.internal.lambda.dumpProxyClasses"));
        dumper = null == string ? null : ProxyClassesDumper.getInstance(string);
    }

    private class ForwardingMethodGenerator
    extends TypeConvertingMethodAdapter {
        ForwardingMethodGenerator(MethodVisitor methodVisitor) {
            super(methodVisitor);
        }

        void generate(MethodType methodType) {
            this.visitCode();
            if (InnerClassLambdaMetafactory.this.implKind == 8) {
                this.visitTypeInsn(187, InnerClassLambdaMetafactory.this.implMethodClassName);
                this.visitInsn(89);
            }
            for (int i = 0; i < InnerClassLambdaMetafactory.this.argNames.length; ++i) {
                this.visitVarInsn(25, 0);
                this.visitFieldInsn(180, InnerClassLambdaMetafactory.this.lambdaClassName, InnerClassLambdaMetafactory.this.argNames[i], InnerClassLambdaMetafactory.this.argDescs[i]);
            }
            this.convertArgumentTypes(methodType);
            this.visitMethodInsn(this.invocationOpcode(), InnerClassLambdaMetafactory.this.implMethodClassName, InnerClassLambdaMetafactory.this.implMethodName, InnerClassLambdaMetafactory.this.implMethodDesc, InnerClassLambdaMetafactory.this.implDefiningClass.isInterface());
            TypeDescriptor.OfField ofField = methodType.returnType();
            this.convertType(InnerClassLambdaMetafactory.this.implMethodReturnClass, (Class<?>)ofField, (Class<?>)ofField);
            this.visitInsn(InnerClassLambdaMetafactory.getReturnOpcode(ofField));
            this.visitMaxs(-1, -1);
            this.visitEnd();
        }

        private void convertArgumentTypes(MethodType methodType) {
            int n;
            int n2 = 0;
            boolean bl = InnerClassLambdaMetafactory.this.implIsInstanceMethod && InnerClassLambdaMetafactory.this.invokedType.parameterCount() == 0;
            int n3 = n = bl ? 1 : 0;
            if (bl) {
                TypeDescriptor.OfField ofField = methodType.parameterType(0);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(ofField), n2 + 1);
                n2 += InnerClassLambdaMetafactory.getParameterSize(ofField);
                this.convertType((Class<?>)ofField, InnerClassLambdaMetafactory.this.implDefiningClass, (Class<?>)InnerClassLambdaMetafactory.this.instantiatedMethodType.parameterType(0));
            }
            int n4 = methodType.parameterCount();
            int n5 = InnerClassLambdaMetafactory.this.implMethodType.parameterCount() - n4;
            for (int i = n; i < n4; ++i) {
                TypeDescriptor.OfField ofField = methodType.parameterType(i);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(ofField), n2 + 1);
                n2 += InnerClassLambdaMetafactory.getParameterSize(ofField);
                this.convertType((Class<?>)ofField, (Class<?>)InnerClassLambdaMetafactory.this.implMethodType.parameterType(n5 + i), (Class<?>)InnerClassLambdaMetafactory.this.instantiatedMethodType.parameterType(i));
            }
        }

        private int invocationOpcode() throws InternalError {
            switch (InnerClassLambdaMetafactory.this.implKind) {
                case 6: {
                    return 184;
                }
                case 8: {
                    return 183;
                }
                case 5: {
                    return 182;
                }
                case 9: {
                    return 185;
                }
                case 7: {
                    return 183;
                }
            }
            throw new InternalError("Unexpected invocation kind: " + InnerClassLambdaMetafactory.this.implKind);
        }
    }
}

