/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import jdk.net.ExtendedSocketOptions;
import jdk.net.SocketFlow;
import sun.net.ExtendedOptionsImpl;

class PlainSocketImpl
extends AbstractPlainSocketImpl {
    PlainSocketImpl() {
    }

    PlainSocketImpl(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    @Override
    protected <T> void setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (!socketOption.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            super.setOption(socketOption, t);
        } else {
            if (this.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            ExtendedOptionsImpl.checkSetOptionPermission(socketOption);
            ExtendedOptionsImpl.checkValueType(t, SocketFlow.class);
            ExtendedOptionsImpl.setFlowOption(this.getFileDescriptor(), (SocketFlow)t);
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (!socketOption.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            return super.getOption(socketOption);
        }
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        ExtendedOptionsImpl.checkGetOptionPermission(socketOption);
        SocketFlow socketFlow = SocketFlow.create();
        ExtendedOptionsImpl.getFlowOption(this.getFileDescriptor(), socketFlow);
        return (T)socketFlow;
    }

    @Override
    protected void socketSetOption(int n, boolean bl, Object object) throws SocketException {
        block2: {
            try {
                this.socketSetOption0(n, bl, object);
            }
            catch (SocketException socketException) {
                if (this.socket != null && this.socket.isConnected()) break block2;
                throw socketException;
            }
        }
    }

    @Override
    native void processNRException(InetAddress var1, int var2, int var3) throws IOException;

    @Override
    native void socketCreate(boolean var1) throws IOException;

    @Override
    native void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    @Override
    native void socketBind(InetAddress var1, int var2) throws IOException;

    @Override
    native void socketListen(int var1) throws IOException;

    @Override
    native void socketAccept(SocketImpl var1) throws IOException;

    @Override
    native int socketAvailable() throws IOException;

    @Override
    native void socketClose0(boolean var1) throws IOException;

    @Override
    native void socketShutdown(int var1) throws IOException;

    static native void initProto();

    native void socketSetOption0(int var1, boolean var2, Object var3) throws SocketException;

    @Override
    native int socketGetOption(int var1, Object var2) throws SocketException;

    @Override
    native void socketSendUrgentData(int var1) throws IOException;

    static {
        PlainSocketImpl.initProto();
    }
}

