/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.RDMASocketImpl;
import java.net.SocketException;
import java.net.SocketInputStream;
import java.security.AccessController;
import sun.net.ConnectionResetException;
import sun.security.action.GetBooleanAction;

class RDMASocketInputStream
extends SocketInputStream {
    private boolean eof;
    private RDMASocketImpl impl = null;
    private static boolean safeSocketOps = false;

    private static native void init();

    private native int socketRead0(long var1, byte[] var3, int var4, int var5, int var6) throws IOException;

    private native int socketRead0Direct(long var1, byte[] var3, int var4, int var5, int var6) throws IOException;

    RDMASocketInputStream(RDMASocketImpl rDMASocketImpl) throws IOException {
        super(rDMASocketImpl);
        this.impl = rDMASocketImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int read(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("RDMA Connection reset");
        }
        if (n2 <= 0 || n < 0 || n + n2 > byArray.length) {
            if (n2 == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            int n4;
            if (this.impl.isZeroCopy() && n2 >= this.impl.getZeroCopyThreshold() * 1024) {
                if (safeSocketOps) {
                    Object object = this.impl.socketDataPtrLock;
                    synchronized (object) {
                        if (this.impl.getSocketDataPtr() == 0L) {
                            throw new SocketException("RDMA socket closed");
                        }
                        n4 = this.socketRead0Direct(this.impl.getSocketDataPtr(), byArray, n, n2, n3);
                    }
                } else {
                    n4 = this.socketRead0Direct(this.impl.getSocketDataPtr(), byArray, n, n2, n3);
                }
            } else if (safeSocketOps) {
                Object object = this.impl.socketDataPtrLock;
                synchronized (object) {
                    if (this.impl.getSocketDataPtr() == 0L) {
                        throw new SocketException("RDMA socket closed");
                    }
                    n4 = this.socketRead0(this.impl.getSocketDataPtr(), byArray, n, n2, n3);
                }
            } else {
                n4 = this.socketRead0(this.impl.getSocketDataPtr(), byArray, n, n2, n3);
            }
            if (n4 > 0) {
                return n4;
            }
        }
        catch (ConnectionResetException connectionResetException) {
            this.impl.setConnectionResetPending();
        }
        if (this.impl.isClosedOrPending()) {
            throw new SocketException("RDMA Socket closed");
        }
        if (this.impl.isConnectionResetPending()) {
            this.impl.setConnectionReset();
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("RDMA Connection reset");
        }
        this.eof = true;
        return -1;
    }

    static {
        safeSocketOps = AccessController.doPrivileged(new GetBooleanAction("com.ibm.net.rdma.threadSafeSocketOperations"));
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
        RDMASocketInputStream.init();
    }
}

