/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.DateTimeException;
import java.time.chrono.Era;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.chrono.ThaiBuddhistDate;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;

public enum ThaiBuddhistEra implements Era
{
    BEFORE_BE,
    BE;


    public static ThaiBuddhistEra of(int n) {
        switch (n) {
            case 0: {
                return BEFORE_BE;
            }
            case 1: {
                return BE;
            }
        }
        throw new DateTimeException("Invalid era: " + n);
    }

    @Override
    public int getValue() {
        return this.ordinal();
    }

    @Override
    public String getDisplayName(TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, textStyle).toFormatter(locale).withChronology(ThaiBuddhistChronology.INSTANCE).format(this == BE ? ThaiBuddhistDate.of(1, 1, 1) : ThaiBuddhistDate.of(0, 1, 1));
    }
}

