/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import javax.management.loading.MLetObjectInputStream;
import javax.management.loading.MLetParser;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private static final long serialVersionUID = 3636148327800330130L;
    private MBeanServer server = null;
    private List<MLetContent> mletList = new ArrayList<MLetContent>();
    private String libraryDirectory;
    private ObjectName mletObjectName = null;
    private URL[] myUrls = null;
    private transient ClassLoaderRepository currentClr;
    private transient boolean delegateToCLR;
    private Map<String, Class<?>> primitiveClasses = new HashMap(8);

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] uRLArray) {
        this(uRLArray, true);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader) {
        this(uRLArray, classLoader, true);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        this(uRLArray, classLoader, uRLStreamHandlerFactory, true);
    }

    public MLet(URL[] uRLArray, boolean bl) {
        super(uRLArray);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(bl);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, boolean bl) {
        super(uRLArray, classLoader);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(bl);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory, boolean bl) {
        super(uRLArray, classLoader, uRLStreamHandlerFactory);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.delegateToCLR = bl;
        try {
            this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
            if (this.libraryDirectory == null) {
                this.libraryDirectory = this.getTmpDir();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void addURL(URL uRL) {
        if (!Arrays.asList(this.getURLs()).contains(uRL)) {
            super.addURL(uRL);
        }
    }

    @Override
    public void addURL(String string) throws ServiceNotFoundException {
        try {
            URL uRL = new URL(string);
            if (!Arrays.asList(this.getURLs()).contains(uRL)) {
                super.addURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "addUrl", "Malformed URL: " + string, malformedURLException);
            }
            throw new ServiceNotFoundException("The specified URL is malformed");
        }
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    @Override
    public Set<Object> getMBeansFromURL(URL uRL) throws ServiceNotFoundException {
        if (uRL == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        return this.getMBeansFromURL(uRL.toString());
    }

    @Override
    public Set<Object> getMBeansFromURL(String string) throws ServiceNotFoundException {
        Object object;
        String string2 = "getMBeansFromURL";
        if (this.server == null) {
            throw new IllegalStateException("This MLet MBean is not registered with an MBeanServer.");
        }
        if (string == null) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "URL is null");
            throw new ServiceNotFoundException("The specified URL is null");
        }
        string = string.replace(File.separatorChar, '/');
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "<URL = " + string + ">");
        }
        try {
            object = new MLetParser();
            this.mletList = ((MLetParser)object).parseURL(string);
        }
        catch (Exception exception) {
            String string3 = "Problems while parsing URL [" + string + "], got exception [" + exception.toString() + "]";
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, string3);
            throw EnvHelp.initCause(new ServiceNotFoundException(string3), exception);
        }
        if (this.mletList.size() == 0) {
            object = "File " + string + " not found or MLET tag not defined in file";
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, (String)object);
            throw new ServiceNotFoundException((String)object);
        }
        object = new HashSet();
        for (MLetContent mLetContent : this.mletList) {
            ObjectInstance objectInstance;
            Object object2;
            Object object3;
            String string4 = mLetContent.getCode();
            if (string4 != null && string4.endsWith(".class")) {
                string4 = string4.substring(0, string4.length() - 6);
            }
            String string5 = mLetContent.getName();
            URL uRL = mLetContent.getCodeBase();
            String string6 = mLetContent.getVersion();
            String string7 = mLetContent.getSerializedObject();
            String string8 = mLetContent.getJarFiles();
            URL uRL2 = mLetContent.getDocumentBase();
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                object3 = new StringBuilder().append("\n\tMLET TAG     = ").append(mLetContent.getAttributes()).append("\n\tCODEBASE     = ").append(uRL).append("\n\tARCHIVE      = ").append(string8).append("\n\tCODE         = ").append(string4).append("\n\tOBJECT       = ").append(string7).append("\n\tNAME         = ").append(string5).append("\n\tVERSION      = ").append(string6).append("\n\tDOCUMENT URL = ").append(uRL2);
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, ((StringBuilder)object3).toString());
            }
            object3 = new StringTokenizer(string8, ",", false);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().trim();
                if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "Load archive for codebase <" + uRL + ">, file <" + (String)object2 + ">");
                }
                try {
                    uRL = this.check(string6, uRL, (String)object2, mLetContent);
                }
                catch (Exception exception) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), string2, "Got unexpected exception", exception);
                    object.add(exception);
                    continue;
                }
                try {
                    if (Arrays.asList(this.getURLs()).contains(new URL(uRL.toString() + (String)object2))) continue;
                    this.addURL(uRL + (String)object2);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (string4 != null && string7 != null) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "CODE and OBJECT parameters cannot be specified at the same time in tag MLET");
                object.add(new Error("CODE and OBJECT parameters cannot be specified at the same time in tag MLET"));
                continue;
            }
            if (string4 == null && string7 == null) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "Either CODE or OBJECT parameter must be specified in tag MLET");
                object.add(new Error("Either CODE or OBJECT parameter must be specified in tag MLET"));
                continue;
            }
            try {
                if (string4 != null) {
                    List<String> list = mLetContent.getParameterTypes();
                    List<String> list2 = mLetContent.getParameterValues();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < list.size(); ++i) {
                        arrayList.add(this.constructParameter(list2.get(i), list.get(i)));
                    }
                    if (list.isEmpty()) {
                        objectInstance = string5 == null ? this.server.createMBean(string4, null, this.mletObjectName) : this.server.createMBean(string4, new ObjectName(string5), this.mletObjectName);
                    } else {
                        Object[] objectArray = arrayList.toArray();
                        String[] stringArray = new String[list.size()];
                        list.toArray(stringArray);
                        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringBuilder.append("\n\tSignature     = ").append(stringArray[i]).append("\t\nParams        = ").append(objectArray[i]);
                            }
                            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), string2, stringBuilder.toString());
                        }
                        objectInstance = string5 == null ? this.server.createMBean(string4, null, this.mletObjectName, objectArray, stringArray) : this.server.createMBean(string4, new ObjectName(string5), this.mletObjectName, objectArray, stringArray);
                    }
                } else {
                    object2 = this.loadSerializedObject(uRL, string7);
                    if (string5 == null) {
                        this.server.registerMBean(object2, null);
                    } else {
                        this.server.registerMBean(object2, new ObjectName(string5));
                    }
                    objectInstance = new ObjectInstance(string5, object2.getClass().getName());
                }
            }
            catch (ReflectionException reflectionException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "ReflectionException", reflectionException);
                object.add(reflectionException);
                continue;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "InstanceAlreadyExistsException", instanceAlreadyExistsException);
                object.add(instanceAlreadyExistsException);
                continue;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "MBeanRegistrationException", mBeanRegistrationException);
                object.add(mBeanRegistrationException);
                continue;
            }
            catch (MBeanException mBeanException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "MBeanException", mBeanException);
                object.add(mBeanException);
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "NotCompliantMBeanException", notCompliantMBeanException);
                object.add(notCompliantMBeanException);
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "InstanceNotFoundException", instanceNotFoundException);
                object.add(instanceNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "IOException", iOException);
                object.add(iOException);
                continue;
            }
            catch (SecurityException securityException) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "SecurityException", securityException);
                object.add(securityException);
                continue;
            }
            catch (Exception exception) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "Exception", exception);
                object.add(exception);
                continue;
            }
            catch (Error error) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string2, "Error", error);
                object.add(error);
                continue;
            }
            object.add(objectInstance);
        }
        return object;
    }

    @Override
    public synchronized String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    @Override
    public synchronized void setLibraryDirectory(String string) {
        this.libraryDirectory = string;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.setMBeanServer(mBeanServer);
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + "type=MLet");
        }
        this.mletObjectName = objectName;
        return this.mletObjectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class<?> loadClass(String string, ClassLoaderRepository classLoaderRepository) throws ClassNotFoundException {
        ClassLoaderRepository classLoaderRepository2 = this.currentClr;
        try {
            this.currentClr = classLoaderRepository;
            Class<?> clazz = this.loadClass(string);
            return clazz;
        }
        finally {
            this.currentClr = classLoaderRepository2;
        }
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, this.currentClr);
    }

    Class<?> findClass(String string, ClassLoaderRepository classLoaderRepository) throws ClassNotFoundException {
        Class<?> clazz;
        block10: {
            block9: {
                clazz = null;
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "findClass", string);
                try {
                    clazz = super.findClass(string);
                    if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "findClass", "Class " + string + " loaded through MLet classloader");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) break block9;
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Class " + string + " not found locally");
                }
            }
            if (clazz == null && this.delegateToCLR && classLoaderRepository != null) {
                try {
                    if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Class " + string + " : looking in CLR");
                    }
                    clazz = classLoaderRepository.loadClassBefore(this, string);
                    if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "findClass", "Class " + string + " loaded through the default classloader repository");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) break block10;
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Class " + string + " not found in CLR");
                }
            }
        }
        if (clazz == null) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "findClass", "Failed to load class " + string);
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    @Override
    protected String findLibrary(String string) {
        String string2;
        String string3 = "findLibrary";
        String string4 = System.mapLibraryName(string);
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, "Search " + string + " in all JAR files");
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, string4 + " loaded, absolute path = " + string2);
            }
            return string2;
        }
        string4 = MLet.removeSpace(System.getProperty("os.name")) + File.separator + MLet.removeSpace(System.getProperty("os.arch")) + File.separator + MLet.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + string4;
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, string4 + " loaded, absolute path = " + string2);
            }
            return string2;
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, string + " not found in any JAR file");
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), string3, "Search " + string + " along the path specified as the java.library.path property");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTmpDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            return string;
        }
        File file = null;
        try {
            file = File.createTempFile("tmp", "jmx");
            if (file == null) {
                String string2 = null;
                return string2;
            }
            File file2 = file.getParentFile();
            if (file2 == null) {
                String string3 = null;
                return string3;
            }
            String string4 = file2.getAbsolutePath();
            return string4;
        }
        catch (Exception exception) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "getTmpDir", "Failed to determine system temporary dir");
            String string5 = null;
            return string5;
        }
        finally {
            if (file != null) {
                try {
                    boolean bl = file.delete();
                    if (!bl) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "getTmpDir", "Failed to delete temp file");
                    }
                }
                catch (Exception exception) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "getTmpDir", "Failed to delete temporary file", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String loadLibraryAsResource(String string) {
        try {
            InputStream inputStream = this.getResourceAsStream(string.replace(File.separatorChar, '/'));
            if (inputStream == null) return null;
            try {
                Object object;
                File file = new File(this.libraryDirectory);
                file.mkdirs();
                File file2 = Files.createTempFile(file.toPath(), string + ".", null, new FileAttribute[0]).toFile();
                file2.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n;
                    object = new byte[4096];
                    while ((n = inputStream.read((byte[])object)) >= 0) {
                        fileOutputStream.write((byte[])object, 0, n);
                    }
                }
                finally {
                    fileOutputStream.close();
                    file2.setExecutable(true);
                }
                if (!file2.exists()) return null;
                object = file2.getAbsolutePath();
                return object;
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadLibraryAsResource", "Failed to load library : " + string, exception);
            return null;
        }
    }

    private static String removeSpace(String string) {
        return string.trim().replace(" ", "");
    }

    protected URL check(String string, URL uRL, String string2, MLetContent mLetContent) throws Exception {
        return uRL;
    }

    private Object loadSerializedObject(URL uRL, String string) throws IOException, ClassNotFoundException {
        InputStream inputStream;
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLet.class.getName(), "loadSerializedObject", uRL.toString() + string);
        }
        if ((inputStream = this.getResourceAsStream(string)) != null) {
            try {
                MLetObjectInputStream mLetObjectInputStream = new MLetObjectInputStream(inputStream, this);
                Object object = mLetObjectInputStream.readObject();
                mLetObjectInputStream.close();
                return object;
            }
            catch (IOException iOException) {
                if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadSerializedObject", "Exception while deserializing " + string, iOException);
                }
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadSerializedObject", "Exception while deserializing " + string, classNotFoundException);
                }
                throw classNotFoundException;
            }
        }
        if (JmxProperties.MLET_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "loadSerializedObject", "Error: File " + string + " containing serialized object not found");
        }
        throw new Error("File " + string + " containing serialized object not found");
    }

    private Object constructParameter(String string, String string2) {
        Class<?> clazz = this.primitiveClasses.get(string2);
        if (clazz != null) {
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Object[] objectArray = new Object[]{string};
                return constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                JmxProperties.MLET_LOGGER.logp(Level.FINEST, MLet.class.getName(), "constructParameter", "Got unexpected exception", exception);
            }
        }
        if (string2.compareTo("java.lang.Boolean") == 0) {
            return Boolean.valueOf(string);
        }
        if (string2.compareTo("java.lang.Byte") == 0) {
            return new Byte(string);
        }
        if (string2.compareTo("java.lang.Short") == 0) {
            return new Short(string);
        }
        if (string2.compareTo("java.lang.Long") == 0) {
            return new Long(string);
        }
        if (string2.compareTo("java.lang.Integer") == 0) {
            return new Integer(string);
        }
        if (string2.compareTo("java.lang.Float") == 0) {
            return new Float(string);
        }
        if (string2.compareTo("java.lang.Double") == 0) {
            return new Double(string);
        }
        if (string2.compareTo("java.lang.String") == 0) {
            return string;
        }
        return string;
    }

    private synchronized void setMBeanServer(final MBeanServer mBeanServer) {
        this.server = mBeanServer;
        PrivilegedAction<ClassLoaderRepository> privilegedAction = new PrivilegedAction<ClassLoaderRepository>(){

            @Override
            public ClassLoaderRepository run() {
                return mBeanServer.getClassLoaderRepository();
            }
        };
        this.currentClr = AccessController.doPrivileged(privilegedAction);
    }
}

