/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.DPathConsumer2D;
import sun.java2d.marlin.MarlinProperties;

final class DPathSimplifier
implements DPathConsumer2D {
    private static final double PIX_THRESHOLD = MarlinProperties.getPathSimplifierPixelTolerance();
    private static final double SQUARE_TOLERANCE = PIX_THRESHOLD * PIX_THRESHOLD;
    private DPathConsumer2D delegate;
    private double cx;
    private double cy;

    DPathSimplifier() {
    }

    DPathSimplifier init(DPathConsumer2D dPathConsumer2D) {
        this.delegate = dPathConsumer2D;
        return this;
    }

    @Override
    public void pathDone() {
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.delegate.closePath();
    }

    @Override
    public long getNativeConsumer() {
        return 0L;
    }

    @Override
    public void quadTo(double d, double d2, double d3, double d4) {
        double d5 = d3 - this.cx;
        double d6 = d4 - this.cy;
        if (d5 * d5 + d6 * d6 <= SQUARE_TOLERANCE && (d5 = d - this.cx) * d5 + (d6 = d2 - this.cy) * d6 <= SQUARE_TOLERANCE) {
            return;
        }
        this.delegate.quadTo(d, d2, d3, d4);
        this.cx = d3;
        this.cy = d4;
    }

    @Override
    public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d5 - this.cx;
        double d8 = d6 - this.cy;
        if (d7 * d7 + d8 * d8 <= SQUARE_TOLERANCE && (d7 = d - this.cx) * d7 + (d8 = d2 - this.cy) * d8 <= SQUARE_TOLERANCE && (d7 = d3 - this.cx) * d7 + (d8 = d4 - this.cy) * d8 <= SQUARE_TOLERANCE) {
            return;
        }
        this.delegate.curveTo(d, d2, d3, d4, d5, d6);
        this.cx = d5;
        this.cy = d6;
    }

    @Override
    public void moveTo(double d, double d2) {
        this.delegate.moveTo(d, d2);
        this.cx = d;
        this.cy = d2;
    }

    @Override
    public void lineTo(double d, double d2) {
        double d3 = d - this.cx;
        double d4 = d2 - this.cy;
        if (d3 * d3 + d4 * d4 <= SQUARE_TOLERANCE) {
            return;
        }
        this.delegate.lineTo(d, d2);
        this.cx = d;
        this.cy = d2;
    }
}

