/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NIONetworkSelector;
import sun.nio.ch.RDMAEPollArrayWrapper;
import sun.nio.ch.RDMANet;
import sun.nio.ch.RDMASelChImpl;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class RDMAEPollSelectorImpl
extends SelectorImpl {
    RDMAEPollArrayWrapper pollWrapper;
    private Map<Long, SelectionKeyImpl> ptrToKey;
    private Map<SelectionKeyImpl, Long> keyToPtr;
    private volatile boolean closed = false;
    private boolean interruptTriggered = false;
    protected int fd0;
    protected int fd1;
    private final Object interruptLock = new Object();

    RDMAEPollSelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        long l = IOUtil.makePipe(false);
        this.fd0 = (int)(l >>> 32);
        this.fd1 = (int)l;
        this.pollWrapper = new RDMAEPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.ptrToKey = new HashMap<Long, SelectionKeyImpl>();
        this.keyToPtr = new HashMap<SelectionKeyImpl, Long>();
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA epoll selector created%n", this.hashCode());
        }
    }

    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        long l;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        SelChImpl selChImpl = selectionKeyImpl.channel;
        if (selChImpl instanceof RDMASelChImpl) {
            int n = ((RDMASelChImpl)selChImpl).getTcpFD();
            l = ((RDMASelChImpl)selChImpl).getRsocketPtr();
            if (n != -1) {
                RDMANet.setTcpFD(l, n);
            }
        } else {
            int n = IOUtil.fdVal(selChImpl.getFD());
            l = RDMANet.createDummyRsocket(n);
        }
        this.ptrToKey.put(l, selectionKeyImpl);
        this.keyToPtr.put(selectionKeyImpl, l);
        this.pollWrapper.add(l);
        this.keys.add(selectionKeyImpl);
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: Registered RDMA channel %X for epolling%n", this.hashCode(), selectionKeyImpl.channel.hashCode());
        }
    }

    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        long l = this.keyToPtr.get(selectionKeyImpl);
        SelChImpl selChImpl = selectionKeyImpl.channel;
        if (!(selChImpl instanceof RDMASelChImpl)) {
            RDMANet.closeDummyRsocket(l);
        }
        this.ptrToKey.remove(l);
        this.keyToPtr.remove(selectionKeyImpl);
        this.pollWrapper.remove(l);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: Deregistered RDMA channel %X for epolling%n", this.hashCode(), selectableChannel.hashCode());
        }
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            object = (SelectionKeyImpl)iterator.next();
            long l = this.keyToPtr.get(object);
            SelChImpl selChImpl = ((SelectionKeyImpl)object).channel;
            if (!(selChImpl instanceof RDMASelChImpl)) {
                RDMANet.closeDummyRsocket(l);
            }
            this.pollWrapper.remove(l);
            this.ptrToKey.remove(l);
            this.keyToPtr.remove(object);
            this.deregister((AbstractSelectionKey)object);
            SelectableChannel selectableChannel = ((SelectionKeyImpl)object).channel();
            if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            iterator.remove();
        }
        object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
        this.fd0 = -1;
        this.fd1 = -1;
        this.pollWrapper.freeInterrupt();
        this.pollWrapper.closeEPollWrapper();
        this.pollWrapper = null;
        this.selectedKeys = null;
        this.ptrToKey = null;
        this.keyToPtr = null;
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA epoll selector closed%n", this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long l) throws IOException {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(l);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        boolean bl = this.pollWrapper.interrupted();
        if (bl) {
            this.pollWrapper.putEventOps(this.pollWrapper.interruptedIndex(), 0);
            Object object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    private int updateSelectedKeys() {
        int n = this.pollWrapper.updated;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = this.pollWrapper.getRsocketPtr(i);
            SelectionKeyImpl selectionKeyImpl = this.ptrToKey.get(l);
            if (selectionKeyImpl == null) continue;
            int n3 = this.pollWrapper.getEventOps(i);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n3, selectionKeyImpl)) continue;
                ++n2;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n3, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n2;
        }
        return n2;
    }

    @Override
    public void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        long l = this.keyToPtr.get(selectionKeyImpl);
        this.pollWrapper.setInterest(l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
    }
}

