/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.RDMASocketDispatcher;
import sun.nio.ch.Util;

final class RDMAIOUtil {
    static final int IOV_MAX;

    private RDMAIOUtil() {
    }

    public static native void configureBlocking(long var0, boolean var2) throws IOException;

    public static void load() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(long l, ByteBuffer byteBuffer, RDMASocketDispatcher rDMASocketDispatcher, boolean bl) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return RDMAIOUtil.readIntoNativeBuffer(l, byteBuffer, rDMASocketDispatcher, bl);
        }
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
        try {
            int n = RDMAIOUtil.readIntoNativeBuffer(l, byteBuffer2, rDMASocketDispatcher, bl);
            byteBuffer2.flip();
            if (n > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int readIntoNativeBuffer(long l, ByteBuffer byteBuffer, RDMASocketDispatcher rDMASocketDispatcher, boolean bl) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        int n5 = 0;
        n5 = rDMASocketDispatcher.read(l, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, bl);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(long l, ByteBuffer[] byteBufferArray, int n, int n2, RDMASocketDispatcher rDMASocketDispatcher, boolean bl) throws IOException {
        int n3;
        IOVecWrapper iOVecWrapper = IOVecWrapper.get(n2);
        boolean bl2 = false;
        int n4 = 0;
        try {
            long l2;
            int n5 = n + n2;
            for (int i = n; i < n5 && n4 < IOV_MAX; ++i) {
                int n6;
                ByteBuffer byteBuffer = byteBufferArray[i];
                if (byteBuffer.isReadOnly()) {
                    throw new IllegalArgumentException("Read-only buffer");
                }
                int n7 = byteBuffer.position();
                n3 = byteBuffer.limit();
                assert (n7 <= n3);
                int n8 = n6 = n7 <= n3 ? n3 - n7 : 0;
                if (n6 <= 0) continue;
                iOVecWrapper.setBuffer(n4, byteBuffer, n7, n6);
                if (!(byteBuffer instanceof DirectBuffer)) {
                    ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
                    iOVecWrapper.setShadow(n4, byteBuffer2);
                    byteBuffer = byteBuffer2;
                    n7 = byteBuffer2.position();
                }
                iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n7);
                iOVecWrapper.putLen(n4, n6);
                ++n4;
            }
            if (n4 == 0) {
                long l3 = 0L;
                return l3;
            }
            long l4 = l2 = rDMASocketDispatcher.readv(l, iOVecWrapper.address, n4, bl);
            for (int i = 0; i < n4; ++i) {
                ByteBuffer byteBuffer = iOVecWrapper.getShadow(i);
                if (l4 > 0L) {
                    int n9;
                    ByteBuffer byteBuffer3 = iOVecWrapper.getBuffer(i);
                    int n10 = iOVecWrapper.getRemaining(i);
                    int n11 = n9 = l4 > (long)n10 ? n10 : (int)l4;
                    if (byteBuffer == null) {
                        int n12 = iOVecWrapper.getPosition(i);
                        byteBuffer3.position(n12 + n9);
                    } else {
                        byteBuffer.limit(byteBuffer.position() + n9);
                        byteBuffer3.put(byteBuffer);
                    }
                    l4 -= (long)n9;
                }
                if (byteBuffer != null) {
                    Util.offerLastTemporaryDirectBuffer(byteBuffer);
                }
                iOVecWrapper.clearRefs(i);
            }
            bl2 = true;
            long l5 = l2;
            return l5;
        }
        finally {
            if (!bl2) {
                for (n3 = 0; n3 < n4; ++n3) {
                    ByteBuffer byteBuffer = iOVecWrapper.getShadow(n3);
                    if (byteBuffer != null) {
                        Util.offerLastTemporaryDirectBuffer(byteBuffer);
                    }
                    iOVecWrapper.clearRefs(n3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(long l, ByteBuffer byteBuffer, RDMASocketDispatcher rDMASocketDispatcher, boolean bl) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return RDMAIOUtil.writeFromNativeBuffer(l, byteBuffer, rDMASocketDispatcher, bl);
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n3);
        try {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n);
            int n4 = RDMAIOUtil.writeFromNativeBuffer(l, byteBuffer2, rDMASocketDispatcher, bl);
            if (n4 > 0) {
                byteBuffer.position(n + n4);
            }
            int n5 = n4;
            return n5;
        }
        finally {
            Util.offerFirstTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int writeFromNativeBuffer(long l, ByteBuffer byteBuffer, RDMASocketDispatcher rDMASocketDispatcher, boolean bl) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        n4 = rDMASocketDispatcher.write(l, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, bl);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(long l, ByteBuffer[] byteBufferArray, int n, int n2, RDMASocketDispatcher rDMASocketDispatcher, boolean bl) throws IOException {
        int n3;
        IOVecWrapper iOVecWrapper = IOVecWrapper.get(n2);
        boolean bl2 = false;
        int n4 = 0;
        try {
            long l2;
            int n5 = n + n2;
            for (int i = n; i < n5 && n4 < IOV_MAX; ++i) {
                int n6;
                ByteBuffer byteBuffer = byteBufferArray[i];
                int n7 = byteBuffer.position();
                n3 = byteBuffer.limit();
                assert (n7 <= n3);
                int n8 = n6 = n7 <= n3 ? n3 - n7 : 0;
                if (n6 <= 0) continue;
                iOVecWrapper.setBuffer(n4, byteBuffer, n7, n6);
                if (!(byteBuffer instanceof DirectBuffer)) {
                    ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer2.flip();
                    iOVecWrapper.setShadow(n4, byteBuffer2);
                    byteBuffer.position(n7);
                    byteBuffer = byteBuffer2;
                    n7 = byteBuffer2.position();
                }
                iOVecWrapper.putBase(n4, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n7);
                iOVecWrapper.putLen(n4, n6);
                ++n4;
            }
            if (n4 == 0) {
                long l3 = 0L;
                return l3;
            }
            long l4 = l2 = rDMASocketDispatcher.writev(l, iOVecWrapper.address, n4, bl);
            for (int i = 0; i < n4; ++i) {
                ByteBuffer byteBuffer;
                if (l4 > 0L) {
                    byteBuffer = iOVecWrapper.getBuffer(i);
                    int n9 = iOVecWrapper.getPosition(i);
                    int n10 = iOVecWrapper.getRemaining(i);
                    int n11 = l4 > (long)n10 ? n10 : (int)l4;
                    byteBuffer.position(n9 + n11);
                    l4 -= (long)n11;
                }
                if ((byteBuffer = iOVecWrapper.getShadow(i)) != null) {
                    Util.offerLastTemporaryDirectBuffer(byteBuffer);
                }
                iOVecWrapper.clearRefs(i);
            }
            bl2 = true;
            long l5 = l2;
            return l5;
        }
        finally {
            if (!bl2) {
                for (n3 = 0; n3 < n4; ++n3) {
                    ByteBuffer byteBuffer = iOVecWrapper.getShadow(n3);
                    if (byteBuffer != null) {
                        Util.offerLastTemporaryDirectBuffer(byteBuffer);
                    }
                    iOVecWrapper.clearRefs(n3);
                }
            }
        }
    }

    static {
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                System.loadLibrary("nio");
                System.loadLibrary("jsor");
                return null;
            }
        });
        IOV_MAX = IOUtil.iovMax();
    }
}

