/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import sun.net.NetworkProvider;
import sun.security.action.GetPropertyAction;

class RDMANIOProvider
implements NetworkProvider {
    private static final String name = "RDMANIO";
    private InetAddress preferredAddress = null;
    private static final boolean debugInterception;

    RDMANIOProvider() {
    }

    private native void initialize0() throws IOException;

    private native void cleanup0();

    @Override
    public void initialize() throws IOException {
        try {
            this.initialize0();
            if (this.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA provider initialized%n", this.hashCode());
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void cleanup() {
        this.cleanup0();
        if (this.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA provider finalized%n", this.hashCode());
        }
    }

    @Override
    public SocketImpl createImpl(SocketImpl socketImpl) {
        return null;
    }

    @Override
    public void setPreferredAddress(List<String> list, List<String> list2) {
        InetAddress inetAddress = null;
        try {
            String string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.nio.rdma.preferredAddress"));
            if (string != null && (!list.isEmpty() && list.contains(string) || !list2.isEmpty() && list2.contains(string))) {
                inetAddress = InetAddress.getByName(string);
            } else if (!list.isEmpty()) {
                inetAddress = InetAddress.getByName(list.get(0));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.preferredAddress = inetAddress;
    }

    @Override
    public InetAddress getPreferredAddress() {
        return this.preferredAddress;
    }

    @Override
    public boolean isDebugOn() {
        return debugInterception;
    }

    static {
        boolean bl = false;
        String string = null;
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("jsor");
                return null;
            }
        });
        string = AccessController.doPrivileged(new GetPropertyAction("com.ibm.nio.rdma.debug"));
        if (string != null) {
            bl = Boolean.parseBoolean(string);
        }
        debugInterception = bl;
    }
}

