/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import sun.nio.ch.Net;
import sun.nio.ch.OptionKey;
import sun.nio.ch.RDMAIOUtil;
import sun.nio.ch.SocketOptionRegistry;

final class RDMANet {
    private RDMANet() {
    }

    static native long socket(boolean var0) throws IOException;

    private static native int localPort(long var0) throws IOException;

    private static native InetAddress localInetAddress(long var0) throws IOException;

    static InetSocketAddress localAddress(long l) throws IOException {
        try {
            return new InetSocketAddress(RDMANet.localInetAddress(l), RDMANet.localPort(l));
        }
        catch (SocketException socketException) {
            return null;
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private static native void setIntOption0(long var0, int var2, int var3, int var4) throws IOException;

    static void setSocketOption(long l, SocketOption<?> socketOption, Object object) throws IOException {
        boolean bl;
        OptionKey optionKey;
        int n;
        if (object == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class<?> clazz = socketOption.type();
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if ((socketOption == StandardSocketOptions.SO_RCVBUF || socketOption == StandardSocketOptions.SO_SNDBUF) && (n = ((Integer)object).intValue()) < 0) {
            throw new IllegalArgumentException("Invalid send/receive buffer size");
        }
        if (socketOption == StandardSocketOptions.SO_LINGER) {
            n = (Integer)object;
            if (n < 0) {
                object = -1;
            }
            if (n > 65535) {
                object = 65535;
            }
        }
        if ((optionKey = SocketOptionRegistry.findOption(socketOption, Net.UNSPEC)) == null) {
            throw new AssertionError((Object)"Option not found");
        }
        int n2 = clazz == Integer.class ? (Integer)object : ((bl = ((Boolean)object).booleanValue()) ? 1 : 0);
        RDMANet.setIntOption0(l, optionKey.level(), optionKey.name(), n2);
    }

    private static native int getIntOption0(long var0, int var2, int var3) throws IOException;

    static Object getSocketOption(long l, SocketOption<?> socketOption) throws IOException {
        Class<?> clazz = socketOption.type();
        if (clazz != Integer.class && clazz != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        OptionKey optionKey = SocketOptionRegistry.findOption(socketOption, Net.UNSPEC);
        if (optionKey == null) {
            throw new AssertionError((Object)"Option not found");
        }
        int n = RDMANet.getIntOption0(l, optionKey.level(), optionKey.name());
        if (clazz == Integer.class) {
            return n;
        }
        return n == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    static native void bind(long var0, InetAddress var2, int var3) throws IOException;

    static native int connect(long var0, InetAddress var2, int var3, boolean var4) throws IOException;

    static native void shutdown(long var0, int var2) throws IOException;

    static native void listen(long var0, int var2) throws IOException;

    static native int poll(long var0, int var2, long var3) throws IOException;

    static native long createDummyRsocket(int var0);

    static native void closeDummyRsocket(long var0);

    static native void setTcpFD(long var0, int var2);

    static native void interrupt(int var0);

    static {
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
        RDMAIOUtil.load();
    }
}

