/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.RDMANet;
import sun.nio.ch.RDMASelChImpl;
import sun.nio.ch.SelChImpl;

class RDMAPollArrayWrapper {
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    static final boolean archDataModel32 = System.getProperty("sun.arch.data.model").equals("32");
    static final short SIZE_RSOCKPTR = (short)(archDataModel32 ? 4 : 8);
    protected AllocatedNativeObject pollArray;
    protected AllocatedNativeObject rsockPtrArray;
    protected int totalChannels = 0;
    protected long pollArrayAddress;
    protected long rsockPtrArrayAddress;
    int interruptFD;
    private int currSize;

    RDMAPollArrayWrapper(int n) {
        int n2 = n + 1;
        int n3 = n2 * 8;
        int n4 = n2 * SIZE_RSOCKPTR;
        this.pollArray = new AllocatedNativeObject(n3, false);
        this.pollArrayAddress = this.pollArray.address();
        this.rsockPtrArray = new AllocatedNativeObject(n4, false);
        this.rsockPtrArrayAddress = this.rsockPtrArray.address();
        this.totalChannels = 1;
        this.currSize = n2;
    }

    void initInterrupt(int n, int n2) {
        this.interruptFD = n2;
        this.putDescriptor(0, n);
        this.putEventOps(0, Net.POLLIN);
        this.putReventOps(0, 0);
        long l = RDMANet.createDummyRsocket(n);
        this.putRsocketPtr(0, l);
    }

    int getEventOps(int n) {
        int n2 = 8 * n + 4;
        return this.pollArray.getShort(n2);
    }

    int getReventOps(int n) {
        int n2 = 8 * n + 6;
        return this.pollArray.getShort(n2);
    }

    int getDescriptor(int n) {
        int n2 = 8 * n + 0;
        return this.pollArray.getInt(n2);
    }

    long getRsocketPtr(int n) {
        int n2 = SIZE_RSOCKPTR * n;
        return archDataModel32 ? (long)this.rsockPtrArray.getInt(n2) : this.rsockPtrArray.getLong(n2);
    }

    void putEventOps(int n, int n2) {
        int n3 = 8 * n + 4;
        this.pollArray.putShort(n3, (short)n2);
    }

    void putReventOps(int n, int n2) {
        int n3 = 8 * n + 6;
        this.pollArray.putShort(n3, (short)n2);
    }

    void putDescriptor(int n, int n2) {
        int n3 = 8 * n + 0;
        this.pollArray.putInt(n3, n2);
    }

    void putRsocketPtr(int n, long l) {
        int n2 = SIZE_RSOCKPTR * n;
        if (archDataModel32) {
            this.rsockPtrArray.putInt(n2, (int)l);
        } else {
            this.rsockPtrArray.putLong(n2, l);
        }
    }

    void release(int n) {
    }

    void release(int n, SelChImpl selChImpl) {
        if (!(selChImpl instanceof RDMASelChImpl)) {
            long l = this.getRsocketPtr(n);
            RDMANet.closeDummyRsocket(l);
            this.putRsocketPtr(n, 0L);
        }
    }

    void free() {
        long l = this.getRsocketPtr(0);
        RDMANet.closeDummyRsocket(l);
        this.pollArray.free();
        this.rsockPtrArray.free();
    }

    void addEntry(SelChImpl selChImpl) {
        long l;
        int n;
        if (selChImpl instanceof RDMASelChImpl) {
            n = ((RDMASelChImpl)selChImpl).getTcpFD();
            l = ((RDMASelChImpl)selChImpl).getRsocketPtr();
            if (n != -1) {
                RDMANet.setTcpFD(l, n);
            }
        } else {
            n = IOUtil.fdVal(selChImpl.getFD());
            l = RDMANet.createDummyRsocket(n);
        }
        this.putDescriptor(this.totalChannels, n);
        this.putEventOps(this.totalChannels, 0);
        this.putReventOps(this.totalChannels, 0);
        this.putRsocketPtr(this.totalChannels, l);
        ++this.totalChannels;
    }

    static void replaceEntry(RDMAPollArrayWrapper rDMAPollArrayWrapper, int n, RDMAPollArrayWrapper rDMAPollArrayWrapper2, int n2) {
        rDMAPollArrayWrapper2.putDescriptor(n2, rDMAPollArrayWrapper.getDescriptor(n));
        rDMAPollArrayWrapper2.putEventOps(n2, rDMAPollArrayWrapper.getEventOps(n));
        rDMAPollArrayWrapper2.putReventOps(n2, rDMAPollArrayWrapper.getReventOps(n));
        rDMAPollArrayWrapper2.putRsocketPtr(n2, rDMAPollArrayWrapper.getRsocketPtr(n));
    }

    void grow(int n) {
        if (n <= this.currSize) {
            return;
        }
        int n2 = n * 8;
        int n3 = n * SIZE_RSOCKPTR;
        AllocatedNativeObject allocatedNativeObject = new AllocatedNativeObject(n2, false);
        AllocatedNativeObject allocatedNativeObject2 = new AllocatedNativeObject(n3, false);
        for (int i = 0; i < this.totalChannels; ++i) {
            int n4 = 8 * i;
            allocatedNativeObject.putInt(n4, this.getDescriptor(i));
            n4 = 8 * i + 4;
            allocatedNativeObject.putShort(n4, (short)this.getEventOps(i));
            n4 = 8 * i + 6;
            allocatedNativeObject.putShort(n4, (short)this.getReventOps(i));
            n4 = SIZE_RSOCKPTR * i;
            if (archDataModel32) {
                allocatedNativeObject2.putInt(n4, (int)this.getRsocketPtr(i));
                continue;
            }
            allocatedNativeObject2.putLong(n4, this.getRsocketPtr(i));
        }
        this.pollArray.free();
        this.pollArray = allocatedNativeObject;
        this.pollArrayAddress = this.pollArray.address();
        this.rsockPtrArray.free();
        this.rsockPtrArray = allocatedNativeObject2;
        this.rsockPtrArrayAddress = this.rsockPtrArray.address();
        this.currSize = n;
    }

    private native int poll0(long var1, long var3, int var5, long var6);

    int poll(int n, int n2, long l) {
        long l2 = this.rsockPtrArrayAddress + (long)(n2 * SIZE_RSOCKPTR);
        long l3 = this.pollArrayAddress + (long)(n2 * 8);
        return this.poll0(l2, l3, n, l);
    }

    public void interrupt() {
        RDMANet.interrupt(this.interruptFD);
    }

    static {
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
    }
}

