/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NIONetworkSelector;
import sun.nio.ch.RDMAPollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class RDMAPollSelectorImpl
extends SelectorImpl {
    RDMAPollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 1;
    protected int totalChannels = 1;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean interruptTriggered = false;
    private int fd0;
    private int fd1;
    private Object interruptLock = new Object();

    RDMAPollSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        long l = IOUtil.makePipe(false);
        this.fd0 = (int)(l >>> 32);
        this.fd1 = (int)l;
        this.pollWrapper = new RDMAPollArrayWrapper(10);
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.channelArray = new SelectionKeyImpl[10];
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA pollselector created%n", this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
                assert (selectionKeyImpl.getIndex() != -1);
                selectionKeyImpl.setIndex(-1);
                this.deregister(selectionKeyImpl);
                this.pollWrapper.release(i, selectionKeyImpl.channel);
                SelectableChannel selectableChannel = this.channelArray[i].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA pollselector closed%n", this.hashCode());
            }
        }
    }

    protected int updateSelectedKeys() {
        int n = 0;
        for (int i = this.channelOffset; i < this.totalChannels; ++i) {
            int n2 = this.pollWrapper.getReventOps(i);
            if (n2 == 0) continue;
            SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
            this.pollWrapper.putReventOps(i, 0);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl)) continue;
                ++n;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n2, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            if (this.channelArray.length == this.totalChannels) {
                int n = this.pollWrapper.totalChannels * 2;
                SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
                for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                    selectionKeyImplArray[i] = this.channelArray[i];
                }
                this.channelArray = selectionKeyImplArray;
                this.pollWrapper.grow(n);
            }
            this.channelArray[this.totalChannels] = selectionKeyImpl;
            selectionKeyImpl.setIndex(this.totalChannels);
            this.pollWrapper.addEntry(selectionKeyImpl.channel);
            ++this.totalChannels;
            this.keys.add(selectionKeyImpl);
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Registered RDMA channel %X for polling%n", this.hashCode(), selectionKeyImpl.channel.hashCode());
            }
        }
    }

    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        Object object;
        int n = selectionKeyImpl.getIndex();
        assert (n >= 0);
        if (n != this.totalChannels - 1) {
            object = this.channelArray[this.totalChannels - 1];
            this.channelArray[n] = object;
            ((SelectionKeyImpl)object).setIndex(n);
            this.pollWrapper.release(n, selectionKeyImpl.channel);
            RDMAPollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n);
        } else {
            this.pollWrapper.release(n, selectionKeyImpl.channel);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        --this.pollWrapper.totalChannels;
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        object = selectionKeyImpl.channel();
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: Deregistered RDMA channel %X for polling%n", this.hashCode(), object.hashCode());
        }
        if (!((AbstractInterruptibleChannel)object).isOpen() && !((SelectableChannel)object).isRegistered()) {
            ((SelChImpl)object).kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long l) throws IOException {
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(this.totalChannels, 0, l);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        if (this.pollWrapper.getReventOps(0) != 0) {
            this.pollWrapper.putReventOps(0, 0);
            Object object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseInterrupt() throws IOException {
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = true;
        }
        FileDispatcherImpl.closeIntFD(this.fd0);
        FileDispatcherImpl.closeIntFD(this.fd1);
        this.fd0 = -1;
        this.fd1 = -1;
        this.pollWrapper.release(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
    }
}

