/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import sun.nio.ch.Net;
import sun.nio.ch.RDMAServerSocketChannelImpl;
import sun.nio.ch.RDMASocketChannelImpl;

class RDMAServerSocketAdaptor
extends ServerSocket {
    private final RDMAServerSocketChannelImpl rssc;
    private volatile int timeout = 0;

    public RDMAServerSocketAdaptor(RDMAServerSocketChannelImpl rDMAServerSocketChannelImpl) throws IOException {
        this.rssc = rDMAServerSocketChannelImpl;
    }

    public static ServerSocket create(RDMAServerSocketChannelImpl rDMAServerSocketChannelImpl) {
        try {
            return new RDMAServerSocketAdaptor(rDMAServerSocketChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    @Override
    public RDMAServerSocketChannelImpl getChannel() {
        return this.rssc;
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    @Override
    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        try {
            this.rssc.bind(socketAddress, n);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.rssc.isBound()) {
            return null;
        }
        return Net.getRevealedLocalAddress(this.rssc.localAddress()).getAddress();
    }

    @Override
    public int getLocalPort() {
        if (!this.rssc.isBound()) {
            return -1;
        }
        return Net.asInetSocketAddress(this.rssc.localAddress()).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this.rssc.blockingLock();
        synchronized (object) {
            if (!this.rssc.isBound()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (this.timeout == 0) {
                    RDMASocketChannelImpl rDMASocketChannelImpl = (RDMASocketChannelImpl)this.rssc.accept();
                    if (rDMASocketChannelImpl == null && !this.rssc.isBlocking()) {
                        throw new IllegalBlockingModeException();
                    }
                    return rDMASocketChannelImpl.socket();
                }
                this.rssc.configureBlocking(false);
                try {
                    long l;
                    RDMASocketChannelImpl rDMASocketChannelImpl = (RDMASocketChannelImpl)this.rssc.accept();
                    if (rDMASocketChannelImpl != null) {
                        Socket socket = rDMASocketChannelImpl.socket();
                        return socket;
                    }
                    long l2 = this.timeout;
                    do {
                        if (!this.rssc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l = System.currentTimeMillis();
                        int n = this.rssc.poll(Net.POLLIN, l2);
                        if (n <= 0 || (rDMASocketChannelImpl = (RDMASocketChannelImpl)this.rssc.accept()) == null) continue;
                        Socket socket = rDMASocketChannelImpl.socket();
                        return socket;
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                finally {
                    if (this.rssc.isOpen()) {
                        this.rssc.configureBlocking(true);
                    }
                }
            }
            catch (Exception exception) {
                Net.translateException(exception);
                assert (false);
                return null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.rssc.close();
    }

    @Override
    public boolean isBound() {
        return this.rssc.isBound();
    }

    @Override
    public boolean isClosed() {
        return !this.rssc.isOpen();
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        try {
            this.rssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        try {
            return this.rssc.getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("size cannot be 0 or negative");
        }
        try {
            this.rssc.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.rssc.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "RDMAServerSocket[unbound]";
        }
        return "RDMAServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    static {
        System.err.println("Warning: RDMA/JSOR is deprecated and will be removed in a future release");
    }
}

