/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;
import sun.nio.cs.UnicodeEncoder;

public abstract class UTF16_Encoder
extends UnicodeEncoder {
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private boolean markWritten = false;
    private int byteOff;
    private int charOff;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected UTF16_Encoder(Charset charset, int n, boolean bl) {
        super(charset, n, bl);
        this.usesMark = this.needsMark = bl;
        this.byteOrder = n;
    }

    private void put(char c, ByteBuffer byteBuffer) {
        if (this.byteOrder == 0) {
            byteBuffer.put((byte)(c >> 8));
            byteBuffer.put((byte)(c & 0xFF));
        } else {
            byteBuffer.put((byte)(c & 0xFF));
            byteBuffer.put((byte)(c >> 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            this.charOff = n;
            this.byteOff = n3;
            int n5 = n;
            int n6 = n3;
            int n7 = n4 - 2;
            try {
                int n8;
                int n9;
                boolean bl;
                if (n2 - n5 > n4 - n6) {
                    bl = true;
                    n9 = n4 - n6;
                } else {
                    bl = false;
                    n9 = n2 - n5;
                }
                if (this.usesMark && !this.markWritten && n9 > 0) {
                    if (n6 > n7) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (this.byteOrder == 0) {
                        byArray[n6++] = -2;
                        byArray[n6++] = -1;
                    } else {
                        byArray[n6++] = -1;
                        byArray[n6++] = -2;
                    }
                    this.markWritten = true;
                }
                int n10 = 0;
                if (this.byteOrder == 0) {
                    while (n5 < n2) {
                        n10 = Math.min(n2 - n5, (n4 - n6) / 2);
                        n8 = n10 > 0 ? this.encodeUTF16Big(cArray, n5, n10, byArray, n6) : 0;
                        n6 += n8 * 2;
                        if ((n5 += n8) != n2) {
                            if (n6 > n7) {
                                this.charOff = n5;
                                this.byteOff = n6;
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            int n11 = this.sgp.parse(cArray[n5], cArray, n5, n2);
                            if (n11 < 0) {
                                this.charOff = n5;
                                this.byteOff = n6;
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (n4 - n6 < 4) {
                                this.charOff = n5;
                                this.byteOff = n6;
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            n5 += 2;
                            byArray[n6++] = (byte)(Surrogate.high(n11) >> 8);
                            byArray[n6++] = (byte)(Surrogate.high(n11) & 0xFF);
                            byArray[n6++] = (byte)(Surrogate.low(n11) >> 8);
                            byArray[n6++] = (byte)(Surrogate.low(n11) & 0xFF);
                            continue;
                        }
                        break;
                    }
                } else {
                    while (n5 < n2) {
                        n10 = Math.min(n2 - n5, (n4 - n6) / 2);
                        n8 = n10 > 0 ? this.encodeUTF16Little(cArray, n5, n10, byArray, n6) : 0;
                        n6 += n8 * 2;
                        if ((n5 += n8) != n2) {
                            if (n6 > n7) {
                                this.charOff = n5;
                                this.byteOff = n6;
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            int n12 = this.sgp.parse(cArray[n5], cArray, n5, n2);
                            if (n12 < 0) {
                                this.charOff = n5;
                                this.byteOff = n6;
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (n4 - n6 < 4) {
                                this.charOff = n5;
                                this.byteOff = n6;
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            n5 += 2;
                            byArray[n6++] = (byte)(Surrogate.high(n12) & 0xFF);
                            byArray[n6++] = (byte)(Surrogate.high(n12) >> 8);
                            byArray[n6++] = (byte)(Surrogate.low(n12) & 0xFF);
                            byArray[n6++] = (byte)(Surrogate.low(n12) >> 8);
                            continue;
                        }
                        break;
                    }
                }
                this.charOff = n5;
                this.byteOff = n6;
                if (bl) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(this.charOff - charBuffer.arrayOffset());
                byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
            }
        }
        int n = charBuffer.position();
        if (this.needsMark) {
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            if (charBuffer.hasRemaining()) {
                this.put('\ufeff', byteBuffer);
                this.needsMark = false;
            }
        }
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (!Surrogate.is(c)) {
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++n;
                    this.put(c, byteBuffer);
                    continue;
                }
                int n13 = this.sgp.parse(c, charBuffer);
                if (n13 < 0) {
                    CoderResult coderResult = this.sgp.error();
                    return coderResult;
                }
                if (byteBuffer.remaining() < 4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += 2;
                this.put(Surrogate.high(n13), byteBuffer);
                this.put(Surrogate.low(n13), byteBuffer);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    @Override
    protected void implReset() {
        this.needsMark = this.usesMark;
        this.charOff = 0;
        this.byteOff = 0;
        this.markWritten = false;
    }

    @Override
    public boolean canEncode(char c) {
        return !Surrogate.is(c);
    }

    protected final int encodeUTF16Big(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        int n4;
        for (n4 = 0; n4 < n2 && !Surrogate.is(cArray[n]); ++n4) {
            char c = cArray[n++];
            byArray[n3++] = (byte)(c >> 8);
            byArray[n3++] = (byte)(c & 0xFF);
        }
        return n4;
    }

    protected final int encodeUTF16Little(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        int n4;
        for (n4 = 0; n4 < n2 && !Surrogate.is(cArray[n]); ++n4) {
            char c = cArray[n++];
            byArray[n3++] = (byte)(c & 0xFF);
            byArray[n3++] = (byte)(c >> 8);
        }
        return n4;
    }
}

