/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.ReferenceQueue;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.GC;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.WeakRef;
import sun.security.action.GetLongAction;

public final class ObjectTable {
    private static final long gcInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.server.gcInterval", 3600000L));
    private static final Object tableLock = new Object();
    private static final Map<ObjectEndpoint, Target> objTable = new HashMap<ObjectEndpoint, Target>();
    private static final Map<WeakRef, Target> implTable = new HashMap<WeakRef, Target>();
    private static final Object keepAliveLock = new Object();
    private static int keepAliveCount = 0;
    private static Thread reaper = null;
    static final ReferenceQueue<Object> reapQueue = new ReferenceQueue();
    private static GC.LatencyRequest gcLatencyRequest = null;

    private ObjectTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Target getTarget(ObjectEndpoint objectEndpoint) {
        Object object = tableLock;
        synchronized (object) {
            return objTable.get(objectEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target getTarget(Remote remote) {
        Object object = tableLock;
        synchronized (object) {
            return implTable.get(new WeakRef(remote));
        }
    }

    public static Remote getStub(Remote remote) throws NoSuchObjectException {
        Target target = ObjectTable.getTarget(remote);
        if (target == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return target.getStub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        Object object = tableLock;
        synchronized (object) {
            Target target = ObjectTable.getTarget(remote);
            if (target == null) {
                throw new NoSuchObjectException("object not exported");
            }
            if (target.unexport(bl)) {
                ObjectTable.removeTarget(target);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putTarget(Target target) throws ExportException {
        ObjectEndpoint objectEndpoint = target.getObjectEndpoint();
        WeakRef weakRef = target.getWeakImpl();
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "add object " + objectEndpoint);
        }
        Object object = tableLock;
        synchronized (object) {
            if (target.getImpl() != null) {
                if (objTable.containsKey(objectEndpoint)) {
                    throw new ExportException("internal error: ObjID already in use");
                }
                if (implTable.containsKey(weakRef)) {
                    throw new ExportException("object already exported");
                }
                objTable.put(objectEndpoint, target);
                implTable.put(weakRef, target);
                if (!target.isPermanent()) {
                    ObjectTable.incrementKeepAliveCount();
                }
            }
            DGCAckHandler dGCAckHandler = new DGCAckHandler(new UID());
            Remote remote = target.getImpl();
            dGCAckHandler.add(remote);
            dGCAckHandler.startTimer();
        }
    }

    private static void removeTarget(Target target) {
        ObjectEndpoint objectEndpoint = target.getObjectEndpoint();
        WeakRef weakRef = target.getWeakImpl();
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "remove object " + objectEndpoint);
        }
        objTable.remove(objectEndpoint);
        implTable.remove(weakRef);
        target.markRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void referenced(ObjID objID, long l, VMID vMID) {
        Object object = tableLock;
        synchronized (object) {
            ObjectEndpoint objectEndpoint = new ObjectEndpoint(objID, Transport.currentTransport());
            Target target = objTable.get(objectEndpoint);
            if (target != null) {
                target.referenced(l, vMID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unreferenced(ObjID objID, long l, VMID vMID, boolean bl) {
        Object object = tableLock;
        synchronized (object) {
            ObjectEndpoint objectEndpoint = new ObjectEndpoint(objID, Transport.currentTransport());
            Target target = objTable.get(objectEndpoint);
            if (target != null) {
                target.unreferenced(l, vMID, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementKeepAliveCount() {
        Object object = keepAliveLock;
        synchronized (object) {
            ++keepAliveCount;
            if (reaper == null) {
                reaper = AccessController.doPrivileged(new NewThreadAction(new Reaper(), "Reaper", false));
                reaper.start();
            }
            if (gcLatencyRequest == null) {
                gcLatencyRequest = GC.requestLatency(gcInterval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void decrementKeepAliveCount() {
        Object object = keepAliveLock;
        synchronized (object) {
            if (--keepAliveCount == 0) {
                if (reaper == null) {
                    throw new AssertionError();
                }
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        reaper.interrupt();
                        return null;
                    }
                });
                reaper = null;
                gcLatencyRequest.cancel();
                gcLatencyRequest = null;
            }
        }
    }

    private static class Reaper
    implements Runnable {
        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    WeakRef weakRef = (WeakRef)reapQueue.remove();
                    Object object = tableLock;
                    synchronized (object) {
                        Target target = (Target)implTable.get(weakRef);
                        if (target != null) {
                            if (!target.isEmpty()) {
                                throw new Error("object with known references collected");
                            }
                            if (target.isPermanent()) {
                                throw new Error("permanent object collected");
                            }
                            ObjectTable.removeTarget(target);
                        }
                    }
                } while (!Thread.interrupted());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

