/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.axes.DataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import java.text.MessageFormat;

public class MinimalDataPointImpl
implements DataPoint {
    private static final int UNSET = -1;
    private static final String COMMENT = Messages.getString("MinimalDataPointImpl.synthetic.point");
    private static final String TO_STRING_TEMPLATE = "({0}, {1})";
    private static final MessageFormat toStringFormatter = new MessageFormat("({0}, {1})");
    private static final String SPACE = " ";
    private double x;
    private double y;
    private DataAxis xconverter;
    private DataAxis yconverter;
    private String comment;

    public MinimalDataPointImpl(double d, double d2, DataAxis dataAxis, DataAxis dataAxis2) {
        this.x = d;
        this.y = d2;
        this.comment = COMMENT;
        this.xconverter = dataAxis;
        this.yconverter = dataAxis2;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public double getX(String string) {
        return Double.NaN;
    }

    public double getY(String string) {
        return Double.NaN;
    }

    @Override
    public String formatX(int n) {
        return this.xconverter.formatUnconverted(this.x, n);
    }

    @Override
    public String formatX() {
        return this.xconverter.formatUnconverted(this.x);
    }

    @Override
    public String formatY() {
        return this.yconverter.formatUnconverted(this.y);
    }

    @Override
    public String formatXWithUnits() {
        if (this.xconverter.shouldFormatWithUnits()) {
            return this.formatX() + SPACE + this.xconverter.getUnits();
        }
        return this.formatX();
    }

    @Override
    public String formatYWithUnits() {
        if (this.yconverter.shouldFormatWithUnits()) {
            return this.formatY() + SPACE + this.yconverter.getUnits();
        }
        return this.formatY();
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    public String toString() {
        if (this.yconverter.getAxis().getType() != 1) {
            Object[] objectArray = new Object[]{this.formatXWithUnits(), this.formatYWithUnits()};
            return toStringFormatter.format(objectArray);
        }
        return this.formatXWithUnits();
    }

    public int getSequenceUID() {
        return -1;
    }

    DataAxis getXAxis() {
        return this.xconverter;
    }

    DataAxis getYAxis() {
        return this.yconverter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MinimalDataPointImpl) {
            MinimalDataPointImpl minimalDataPointImpl = (MinimalDataPointImpl)object;
            return minimalDataPointImpl.x == this.x && minimalDataPointImpl.y == this.y && minimalDataPointImpl.xconverter == this.xconverter && minimalDataPointImpl.yconverter == this.yconverter;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.x * this.y);
    }

    @Override
    public int getDataPointSize() {
        return 168;
    }
}

