/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import java.util.HashMap;
import java.util.Map;

public class MonitoringDataProvider
implements DataProvider {
    private String name;
    private String bucket;
    private String tag;
    private int updateFrequency = 120;
    private int maxSend = -1;
    private boolean available = true;
    private int[] lastGot = new int[1];

    public static native byte[] getData(String var0, int var1, int[] var2);

    public static native void sendMessage(String var0, String var1);

    public static native String getSourceDetails(String var0);

    public MonitoringDataProvider(String string) {
        this.bucket = string;
        this.name = string;
        this.tag = string;
        this.lastGot[0] = 0;
        if (string.equalsIgnoreCase("classhistogram")) {
            this.updateFrequency = 20;
            this.tag = "ClassHistogramSource";
        } else if (string.equalsIgnoreCase("cpu")) {
            this.tag = "CpuSource";
            this.updateFrequency = 2;
        } else if (string.equalsIgnoreCase("environment")) {
            this.updateFrequency = 1200;
            this.tag = "EnvironmentSource";
        } else if (string.equalsIgnoreCase("locking")) {
            this.tag = "JLASource";
        } else if (string.equalsIgnoreCase("logger")) {
            this.available = false;
        } else if (string.equalsIgnoreCase("memory")) {
            this.updateFrequency = 5;
            this.tag = "MemorySource";
        } else if (string.equalsIgnoreCase("memorycounters")) {
            this.updateFrequency = 5;
            this.tag = "MemoryCountersSource";
        } else if (string.equalsIgnoreCase("methoddictionary")) {
            this.tag = "MethodDictionarySource";
            this.updateFrequency = 5;
            this.maxSend = 200000;
        } else if (string.equalsIgnoreCase("rt")) {
            this.available = false;
        } else if (string.equalsIgnoreCase("threads")) {
            this.updateFrequency = 30;
            this.tag = "ThreadsSource";
        } else if (string.equalsIgnoreCase("trace")) {
            this.tag = "TRACESubscriberSource";
            this.maxSend = 100000;
            this.updateFrequency = 5;
        } else if (string.equalsIgnoreCase("tprof")) {
            this.updateFrequency = 2;
        }
    }

    @Override
    public boolean isDataSupported() {
        return this.available;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        String string = MonitoringDataProvider.getSourceDetails(this.bucket);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", this.tag);
        hashMap.put("version", "3.0");
        hashMap.put("suggested_update_frequency", Integer.toString(this.updateFrequency));
        hashMap.put("max_bytes_to_send", Integer.toString(this.maxSend));
        hashMap.put("state", string);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getJMXData() {
        byte[] byArray = null;
        String string = this.bucket;
        synchronized (string) {
            byArray = MonitoringDataProvider.getData(this.bucket, this.maxSend, this.lastGot);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetData() {
        String string = this.bucket;
        synchronized (string) {
            this.lastGot[0] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSession() {
        String string = this.bucket;
        synchronized (string) {
            this.lastGot[0] = 0;
        }
    }

    @Override
    public void modify(String string, String ... stringArray) throws ProviderModificationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (String string2 : stringArray) {
            stringBuffer.append(',');
            stringBuffer.append(string2);
        }
        MonitoringDataProvider.sendMessage(this.name, stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartProvider() {
        String string = this.bucket;
        synchronized (string) {
            this.lastGot[0] = 0;
        }
    }

    @Override
    public void headlessFileInitialise() {
    }
}

