/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.gc;

import com.ibm.java.diagnostics.healthcenter.api.gc.impl.GCDefaultPreferencesImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallingPreferenceInitalizer;
import java.util.prefs.Preferences;

public class GCPreferences {
    public GCPreferences() {
        this.setDefaults();
    }

    public int getLowOccupancyThreshold() {
        return this.getPreferences().getInt("SummarisingPostProcessorPreferenceHelper.classLowOccupancyThreshold", 40);
    }

    public int getHighOccupancyThreshold() {
        return this.getPreferences().getInt("SummarisingPostProcessorPreferenceHelper.classHighOccupancyThreshold", 70);
    }

    public int getPauseLengthThreshold() {
        return this.getPreferences().getInt("SummarisingPostProcessorPreferenceHelper.classPauseThreshold", 5000);
    }

    public int getCompactionPercentageThreshold() {
        return this.getPreferences().getInt("SummarisingPostProcessorPreferenceHelper.classCompactFractionThreshold", 15);
    }

    public int getSystemGCPercentageThreshold() {
        return this.getPreferences().getInt("SummarisingPostProcessorPreferenceHelper.classSystemGCFractionThreshold", 10);
    }

    public void setLowOccupancyThreshold(int n) {
        this.getPreferences().putInt("SummarisingPostProcessorPreferenceHelper.classLowOccupancyThreshold", n);
    }

    public void setHighOccupancyThreshold(int n) {
        this.getPreferences().putInt("SummarisingPostProcessorPreferenceHelper.classHighOccupancyThreshold", n);
    }

    public void setPauseLengthThreshold(int n) {
        this.getPreferences().putInt("SummarisingPostProcessorPreferenceHelper.classPauseThreshold", n);
    }

    public void setCompactionPercentageThreshold(int n) {
        this.getPreferences().putInt("SummarisingPostProcessorPreferenceHelper.classCompactFractionThreshold", n);
    }

    public void setSystemGCPercentageThreshold(int n) {
        this.getPreferences().putInt("SummarisingPostProcessorPreferenceHelper.classSystemGCFractionThreshold", n);
    }

    public void setDefaults() {
        GCDefaultPreferencesImpl gCDefaultPreferencesImpl = new GCDefaultPreferencesImpl();
        this.setLowOccupancyThreshold(gCDefaultPreferencesImpl.getDefaultLowOccupancyThreshold());
        this.setHighOccupancyThreshold(gCDefaultPreferencesImpl.getDefaultHighOccupancyThreshold());
        this.setPauseLengthThreshold(gCDefaultPreferencesImpl.getDefaultPauseLengthThreshold());
        this.setCompactionPercentageThreshold(gCDefaultPreferencesImpl.getDefaultCompactionPercentageThreshold());
        this.setSystemGCPercentageThreshold(gCDefaultPreferencesImpl.getDefaultSystemGCPercentageThreshold());
    }

    private Preferences getPreferences() {
        Preferences preferences = MarshallingPreferenceInitalizer.getInstance().getPreferences();
        return preferences;
    }
}

