/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ControllableSingleConfigurableItemData;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMData;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.gc.Messages;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxEnablementConfigurationSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.LocalNativeEnablementConfigurationSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.MQTTEnablementConfigurationSourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.StackControlDataImpl;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.VmControlLabels;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class GCDataCollection {
    private static final Logger TRACE = LogFactory.getTrace(GCDataCollection.class);
    private static final String EQUALS = "=";
    public static final String VERBOSEGC_ON = "verbose.gc=on";
    public static final String VERBOSEGC_OFF = "verbose.gc=off";
    public static final String SET_STACK_TRACE_DEPTH = "stacktracedepth=";
    public static final String SET_LOW_ALLOCATION_THRESHOLD = "lowallocationthreshold=";
    public static final String SET_HIGH_ALLOCATION_THRESHOLD = "highallocationthreshold=";
    private static final int DEFAULT_MAX_STACK_DEPTH = 5;
    private boolean oaDataAvailable = true;
    private boolean is64bitconnection = false;
    private static final String COM_IBM_VM_BITMODE = "com.ibm.vm.bitmode";
    private static final String BITMODE_64 = "64";
    private static final String INCORRECT_AGENT_VERSION = Messages.getString("agent.version.incorrect");
    private static final int goodAgentDate = 20100701;

    public ConnectionData getConnectionData() {
        Data data;
        Marshaller marshaller = MarshallerImpl.getMarshaller();
        Data data2 = marshaller.getData(null);
        if (data2 != null && (data = data2.getTopLevelData(JVMLabels.CONNECTION)) instanceof ConnectionData) {
            return (ConnectionData)data;
        }
        return null;
    }

    public boolean isLiveConnection() {
        boolean bl = false;
        ConnectionData connectionData = this.getConnectionData();
        if (connectionData != null && connectionData.isConnectionAlive() && (connectionData.getConnectionType().equals((Object)ConnectionType.JMX) || connectionData.getConnectionType().equals((Object)ConnectionType.MQTT) || connectionData.getConnectionType().equals((Object)ConnectionType.BLUEMIX))) {
            bl = true;
        }
        return bl;
    }

    public int getCurrentStackDepth() {
        return 5;
    }

    public boolean isOAEnabled() {
        DataBuilder dataBuilder;
        StackControlDataImpl stackControlDataImpl = this.getStackControl();
        return stackControlDataImpl != null && (dataBuilder = stackControlDataImpl.getData("j9mm.234")) != null;
    }

    public StackControlDataImpl getStackControl(Data data) {
        Data data2;
        Data data3;
        if (data != null && (data3 = data.getTopLevelData(SubsystemDataBuilder.CONFIGURATION)) != null && (data2 = data3.getData(VmControlLabels.STACKTRIGGERCONTROL)) instanceof StackControlDataImpl) {
            return (StackControlDataImpl)data2;
        }
        return null;
    }

    public StackControlDataImpl getStackControl() {
        Data data = MarshallerImpl.getMarshaller().getData(null);
        return this.getStackControl(data);
    }

    public boolean isSamplingEnabled() {
        DataBuilder dataBuilder;
        StackControlDataImpl stackControlDataImpl = this.getStackControl();
        return stackControlDataImpl != null && (dataBuilder = stackControlDataImpl.getData("j9mm.395")) != null;
    }

    public void sendSetCommand(Data data, String ... stringArray) {
        String string;
        JVMData jVMData;
        Data data2;
        if (data instanceof JVMData && (data2 = (jVMData = (JVMData)data).getData(string = JVMLabels.GARBAGE_COLLECTION + SubsystemDataBuilder.CONFIGURATION)) != null) {
            Data[] dataArray = data2.getChildren();
            for (int i = 0; i < dataArray.length; ++i) {
                if (!(dataArray[i] instanceof ControllableSingleConfigurableItemData)) continue;
                ControllableSingleConfigurableItemData controllableSingleConfigurableItemData = (ControllableSingleConfigurableItemData)dataArray[i];
                ConfigurableSource configurableSource = controllableSingleConfigurableItemData.getSource();
                if (configurableSource instanceof JmxEnablementConfigurationSourceImpl) {
                    ((JmxEnablementConfigurationSourceImpl)configurableSource).modify("set", stringArray);
                    continue;
                }
                if (configurableSource instanceof MQTTEnablementConfigurationSourceImpl) {
                    ((MQTTEnablementConfigurationSourceImpl)configurableSource).modify("set", stringArray);
                    continue;
                }
                if (!(configurableSource instanceof LocalNativeEnablementConfigurationSourceImpl)) continue;
                ((LocalNativeEnablementConfigurationSourceImpl)configurableSource).modify("set", stringArray);
            }
        }
    }

    public void sendSetCommand(String ... stringArray) {
        Data data = MarshallerImpl.getMarshaller().getData(null);
        this.sendSetCommand(data, stringArray);
    }

    public void checkEnvironment(EnvironmentData environmentData) {
        String string;
        TableDataRow tableDataRow;
        TableData tableData;
        VMLevelChecker vMLevelChecker;
        this.oaDataAvailable = true;
        JVMDataImpl jVMDataImpl = (JVMDataImpl)environmentData.findRootData();
        if (!jVMDataImpl.isJavaVM()) {
            this.oaDataAvailable = false;
        }
        if ((vMLevelChecker = environmentData.getVMLevelChecker()) != null) {
            if (vMLevelChecker.isVMRealtime() || vMLevelChecker.isVMSoftRealtime() || jVMDataImpl != null && jVMDataImpl.isRealtimeVM() || jVMDataImpl != null && jVMDataImpl.isSoftRealtimeVM()) {
                this.oaDataAvailable = false;
            }
            if (vMLevelChecker.getJavaVersion() == 5 && vMLevelChecker.isVMOlderThan(20090430) || vMLevelChecker.getJavaVersion() == 6 && vMLevelChecker.isVMOlderThan(20090330)) {
                this.oaDataAvailable = false;
            } else if (!this.agentLevelGood(environmentData)) {
                this.oaDataAvailable = false;
            }
        }
        if ((tableData = environmentData.getSystemProperties()) != null && (tableDataRow = tableData.get(COM_IBM_VM_BITMODE)) != null && tableDataRow.getRowData().length == 2 && BITMODE_64.equals(string = (String)tableDataRow.getRowData()[1])) {
            this.is64bitconnection = true;
        }
    }

    public boolean oaDataAvailable() {
        return this.oaDataAvailable;
    }

    public boolean is64bitconnection() {
        return this.is64bitconnection;
    }

    public boolean agentLevelGood(EnvironmentData environmentData) {
        StringData stringData;
        if (environmentData != null && (stringData = (StringData)environmentData.getData(EnvironmentLabels.AGENT_JAR_VERSION)) != null) {
            String string = stringData.getValue();
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            if (8 < string2.length()) {
                string2 = string2.substring(0, 8);
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                TRACE.warning(MessageFormat.format(INCORRECT_AGENT_VERSION, string));
                return false;
            }
            if (n >= 20100701) {
                return true;
            }
        }
        return false;
    }
}

