/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.nodejs;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCType;
import com.ibm.java.diagnostics.healthcenter.gc.parser.nodejs.CSVParser;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.Messages;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.impl.TraceParser;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCInternalObject;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GCDataCSVParser
extends CSVParser {
    public static final String EYECATCHER = "NodeGCData";
    private static final DataFactory factory = DataFactory.getFactory();
    private AxisPair heapAxes = null;
    private AxisPair timeAxes = null;
    private static final Logger TRACE = LogFactory.getTrace(GCDataCSVParser.class);
    private final String CLASSNAME = TraceParser.class.getName();
    private static final String BAD_DATA_PROVIDED = Messages.getString("GCDataCSVParser.bad.data");

    @Override
    protected void prepare(DynamicSource dynamicSource, OutputProperties outputProperties) {
        YDataAxis yDataAxis;
        XDataAxis xDataAxis;
        if (this.heapAxes == null) {
            xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            yDataAxis = GCAxes.prepareHeapAxis(outputProperties);
            this.heapAxes = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.timeAxes == null) {
            xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            yDataAxis = GCAxes.prepareTimeAxis(outputProperties);
            this.timeAxes = factory.createAxisPair(xDataAxis, yDataAxis);
        }
    }

    @Override
    protected boolean handleData(DataBuilder dataBuilder, String[] stringArray) {
        boolean bl = false;
        if (EYECATCHER.equals(stringArray[Columns.EYECATCHER.ordinal()]) && stringArray.length == Columns.values().length) {
            try {
                double d = new Double(stringArray[Columns.TIME.ordinal()]);
                int n = new Integer(stringArray[Columns.HEAP_SIZE.ordinal()]);
                int n2 = new Integer(stringArray[Columns.USED_HEAP.ordinal()]);
                double d2 = new Double(stringArray[Columns.PAUSE_TIME.ordinal()]);
                if (!MarshallerImpl.getMarshaller().isEventOnlyMode()) {
                    this.createGCHeapSizeDataPoint(dataBuilder, d, n);
                    this.createGCUsedHeapDataPoint(dataBuilder, d, n2);
                    this.createGCPauseTimeDataPoint(dataBuilder, d, d2);
                }
                GCInternalObject gCInternalObject = new GCInternalObject(n, n - n2, d2, (long)d);
                gCInternalObject.setType(GCType.intToDisplayName(GCType.GLOBAL_INT));
                MarshallerImpl.getMarshaller().getGCEventHandler().addEvent(gCInternalObject);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                TRACE.logp(Level.WARNING, this.CLASSNAME, "parse", BAD_DATA_PROVIDED, numberFormatException);
            }
        }
        return bl;
    }

    private SubsystemDataBuilder getGCSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createGCSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createGCSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(JVMLabels.GARBAGE_COLLECTION, "com.ibm.java.diagnostics.healthcenter.gc.perspective");
        return subsystemDataBuilder;
    }

    private void createGCPauseTimeDataPoint(DataBuilder dataBuilder, double d, double d2) {
        String string;
        SubsystemDataBuilder subsystemDataBuilder = this.getGCSubsystemData(dataBuilder);
        DataBuilder dataBuilder2 = subsystemDataBuilder.getData(string = GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
        if (dataBuilder2 == null) {
            dataBuilder2 = factory.createTwoDimensionalData(string, this.timeAxes);
            subsystemDataBuilder.addData(dataBuilder2);
        }
        DataPointBuilder dataPointBuilder = this.timeAxes.createDataPointBuilder(0, d, d2);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointBuilder);
    }

    private void createGCHeapSizeDataPoint(DataBuilder dataBuilder, double d, int n) {
        String string;
        SubsystemDataBuilder subsystemDataBuilder = this.getGCSubsystemData(dataBuilder);
        DataBuilder dataBuilder2 = subsystemDataBuilder.getData(string = GCLabels.FLAT_HEAP_SIZE);
        if (dataBuilder2 == null) {
            dataBuilder2 = factory.createTwoDimensionalData(string, this.heapAxes);
            subsystemDataBuilder.addData(dataBuilder2);
        }
        DataPointBuilder dataPointBuilder = this.heapAxes.createDataPointBuilder(0, d, n);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointBuilder);
    }

    private void createGCUsedHeapDataPoint(DataBuilder dataBuilder, double d, int n) {
        String string;
        SubsystemDataBuilder subsystemDataBuilder = this.getGCSubsystemData(dataBuilder);
        DataBuilder dataBuilder2 = subsystemDataBuilder.getData(string = GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
        if (dataBuilder2 == null) {
            dataBuilder2 = factory.createTwoDimensionalData(string, this.heapAxes);
            subsystemDataBuilder.addData(dataBuilder2);
        }
        DataPointBuilder dataPointBuilder = this.heapAxes.createDataPointBuilder(0, d, n);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointBuilder);
    }

    public static enum Columns {
        EYECATCHER,
        TIME,
        TYPE,
        HEAP_SIZE,
        USED_HEAP,
        PAUSE_TIME;

    }
}

