/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.jmx;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.AgentConnection;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.AgentConnectionImpl;
import java.lang.reflect.UndeclaredThrowableException;

public class JMXAgentConnection
extends AgentConnectionImpl {
    private static final int UNSET = -1;
    private final HealthCenterMBean healthCenterMbean;
    private int sessionId = -1;

    public JMXAgentConnection(String string, int n, HealthCenterMBean healthCenterMBean) {
        this.hostName = string;
        this.port = n;
        this.healthCenterMbean = healthCenterMBean;
        if (healthCenterMBean != null) {
            try {
                this.isAgentAlreadyInUse = this.healthCenterMbean.isClientsConnected();
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                this.isAgentAlreadyInUse = false;
            }
        } else {
            this.isAgentAlreadyInUse = false;
        }
    }

    public HealthCenterMBean getProxy() {
        return this.healthCenterMbean;
    }

    @Override
    public boolean startSession() {
        boolean bl = false;
        HealthCenterMBean healthCenterMBean = this.getProxy();
        if (healthCenterMBean != null) {
            try {
                this.sessionId = healthCenterMBean.startSession();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.JMX;
    }

    @Override
    public boolean isEqual(AgentConnection agentConnection) {
        return agentConnection instanceof JMXAgentConnection && this.hostName.equals(agentConnection.getHostname()) && this.port == agentConnection.getPortNumber();
    }
}

