/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.StatusManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.FileSourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.io.File;
import java.text.MessageFormat;

public class FileConnectionDataImpl
extends ConnectionDataImpl {
    private final ConnectionType connectionType;
    private final File file;

    public FileConnectionDataImpl(File file) {
        super(file.getName());
        this.file = file;
        this.connectionType = ConnectionType.FILE;
        if (file.exists()) {
            this.isConnectionAlive = true;
            this.setStatus(Status.HEALTHY);
        } else {
            this.setStatus(Status.PROBLEM);
            this.clearValue();
            this.addValue(MessageFormat.format(Messages.getString("FileConnectionDataImpl.file.does.not.exist"), file.getName()));
        }
    }

    @Override
    public boolean spawnSources(Marshaller marshaller) {
        marshaller.addSource(new FileSourceImpl(this.file, (ConnectionDataBuilder)this));
        String string = Messages.getString("SourceAddingJob.imported.from.file");
        String string2 = MessageFormat.format(string, this.file.getName());
        StatusManager.setSources(string2);
        return true;
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }
}

