/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;

public class FileSourceImpl
extends SourceImpl {
    protected File file;
    private long fileSize;
    private long filePosition = 0L;
    private int lastModified = -1;
    private boolean hasSizeBeenRegistered;

    public FileSourceImpl(File file) {
        this(file, null);
    }

    public FileSourceImpl(String string, File file, ConnectionDataBuilder connectionDataBuilder) {
        super(string, connectionDataBuilder);
        this.file = file;
        if (file != null) {
            this.fileSize = file.length();
        }
        if (this.canFileChangeSize()) {
            FileSourceUpdateJob fileSourceUpdateJob = new FileSourceUpdateJob();
            fileSourceUpdateJob.run();
        }
    }

    public FileSourceImpl(File file, ConnectionDataBuilder connectionDataBuilder) {
        this(file.getName(), file, connectionDataBuilder);
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
        InputStream inputStream = this.getBackingStream();
        sourceListener.notifySourceChanged(inputStream);
    }

    protected boolean canFileChangeSize() {
        return true;
    }

    public boolean hasFileChangedSize() {
        long l = this.getFile().length();
        boolean bl = l > this.fileSize;
        return bl;
    }

    @Override
    public InputStream getBackingStream() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getFile());
            if (!this.hasSizeBeenRegistered) {
                this.hasSizeBeenRegistered = true;
                this.tellConnectionAboutDataReceived(fileInputStream.available());
            }
        }
        catch (IOException iOException) {
            String string = Messages.getString("FileSourceImpl.error.creating.input.stream");
            String string2 = MessageFormat.format(string, this.getFile().getName());
            this.tellConnectionAboutError(string2, string2, iOException);
        }
        return fileInputStream;
    }

    public boolean hasChangedSinceLastGet() {
        long l = this.file.lastModified();
        boolean bl = l > (long)this.lastModified;
        return bl;
    }

    private File getFile() {
        return this.file;
    }

    private class FileSourceUpdateJob
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FileSourceImpl.this.hasFileChangedSize()) {
                Object object = FileSourceImpl.this.listenerListLock;
                synchronized (object) {
                    long l = FileSourceImpl.this.getFile().length();
                    long l2 = l - FileSourceImpl.this.filePosition;
                    FileSourceImpl.this.tellConnectionAboutDataReceived((int)l2);
                    Iterator iterator = FileSourceImpl.this.sourceListeners.iterator();
                    while (iterator.hasNext()) {
                        try {
                            FileInputStream fileInputStream = new FileInputStream(FileSourceImpl.this.getFile());
                            fileInputStream.skip(FileSourceImpl.this.filePosition);
                            ((SourceListener)iterator.next()).notifySourceChanged(fileInputStream);
                        }
                        catch (IOException iOException) {
                            String string = Messages.getString("FileSourceImpl.error.creating.input.stream");
                            String string2 = MessageFormat.format(string, FileSourceImpl.this.getFile().getName());
                            FileSourceImpl.this.tellConnectionAboutError(string2, string2, iOException);
                        }
                    }
                    FileSourceImpl.this.filePosition = l;
                    FileSourceImpl.this.fileSize = l;
                }
            }
        }
    }
}

